package io.intino.monet.box.commands;

import io.intino.monet.box.MonetBox;

import java.time.Clock;
import java.time.Instant;

public class Commands {
	protected final MonetBox box;

	public Commands(MonetBox box) {
		this.box = box;
	}

	protected <C extends Command> C setup(C command, String author) {
		command.author = author;
		command.ts = Instant.now(Clock.systemUTC());
		return command;
	}

}
