package io.intino.monet.box;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.monet.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class OrdersApiService {

	public static AlexandriaSpark setup(AlexandriaSpark server, MonetBox box) {
		server.route("api/orders/v1/order/:orderId").get(manager -> new GetOrderResource(box, manager).execute());
		server.route("api/orders/v1/order/:orderId").post(manager -> new PostOrderResource(box, manager).execute());
		server.route("api/orders/v1/order/:orderId").delete(manager -> new DeleteOrderResource(box, manager).execute());

		return server;
	}
}