package io.intino.monet.box;

import io.intino.alexandria.office.Image;
import io.intino.alexandria.office.ImageView;

import static io.intino.alexandria.office.ImageView.WrapOption.ClampToPage;
import static io.intino.alexandria.office.ImageView.WrapOption.ClampToTemplate;

public interface ImageViewFactory {

    ImageView create(Image image);

    class Default implements ImageViewFactory {

        @Override
        public ImageView create(Image image) {
            ImageView imageView = new ImageView(image);
            imageView.widthWrapping(ClampToPage); // Image can be of any width and will not exceed the page's max width
            imageView.heightWrapping(ClampToTemplate); // Image must have the height specified in the template
            imageView.keepAspectRatio(true); // Maintain the aspect ratio of the original image, so it does not get deformed
            return imageView;
        }
    }
}
