import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiFile from "alexandria-ui-elements/src/displays/components/File";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import DisplaysCheckListWizardIndexEntry from "monet-elements/gen/displays/templates/CheckListWizardIndexEntry";
import DisplaysCheckListWizardStep from "monet-elements/gen/displays/templates/CheckListWizardStep";
import DisplaysProgressDisplay from "monet-elements/src/displays/ProgressDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import OrderTemplateNotifier from "monet-elements/gen/displays/notifiers/OrderTemplateNotifier";
import OrderTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OrderTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new OrderTemplateNotifier(this);
		this.requester = new OrderTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1578997958" visible={false} layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1578997958.a1399398005" format="h4" mode="normal" translate={true} value="Order not found">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683" visible={false} layout="vertical flexible" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442" format="relative overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1043246377" layout="horizontal endjustified">
							<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1043246377.a_2108668678" format="tabsStyle middleAirBottom" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1043246377.a_2108668678.a515718104" name="previewOption" format="tabStyle" mode="normal" translate={true} value="Preview">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1043246377.a_2108668678.a1744057378" name="indexOption" format="tabStyle" mode="normal" translate={true} value="Index">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1043246377.a_2108668678.a286817614" name="editionOption" format="tabStyle" mode="normal" translate={true} value="Edition">
								</UiText>
							</UiSelectorTabs>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887" format="whiteBackground leftBordered rightBordered topBordered strongBordered" layout="vertical flexible">
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a2104339744" layout="vertical flexible">
								<UiFile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a2104339744.a1208049412">
								</UiFile>
							</UiBlockConditional>
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a1152819478" format="spaced" layout="vertical flexible">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a1152819478.a2059737347" format="h6 bold airBottom" mode="normal" translate={true} value="Index">
								</UiText>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a1152819478.a_1768149786" visible={false} layout="vertical">
									<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a1152819478.a_1768149786.a1495770647" multiple={{instances:"indexEntries",arrangement:"Vertical",noItemsMessage:"No steps completed",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
									</UiMultiple>
								</UiBlock>
							</UiBlockConditional>
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446" format="spaced" layout="vertical flexible">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a_703804409" format="airBottom overflowRevert cleanHtmlStyle" visible={false} mode="normal" language="Html" value="">
								</UiTextCode>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a1006104588" visible={false} layout="vertical flexible">
									<DisplaysCheckListWizardStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a1006104588.a1279752164">
									</DisplaysCheckListWizardStep>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a1327638316" visible={false} layout="vertical flexible centercenter">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a1327638316.a1161346775" format="h6 bold" mode="normal" translate={true} value="Congratulations! you have finished order">
									</UiText>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a1327638316.a219876765" title="View work report" target="self" mode="Link" size="Medium" format="middleAirTop">
									</UiAction>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a_104463887.a_1366727446.a1327638316.a57800666" title="View index" target="self" mode="Link" size="Medium" format="middleAirTop">
									</UiAction>
								</UiBlock>
							</UiBlockConditional>
						</UiBlock>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1118467332" format="progressHeight">
						</UiDisplayStamp>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a517663166" format="generatingStyle" visible={false} layout="vertical centercenter">
							<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a517663166.a_124080109" mode="Bar">
							</UiSpinner>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1282048727" format="savingStyle" visible={false} layout="vertical centercenter">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_1036683442.a1282048727.a_1731859802" mode="normal" translate={true} value="Order saved">
							</UiText>
						</UiBlock>
					</UiBlock>
					<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a1473555988">
					</UiDivider>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514" layout="horizontal wrap">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514.a_1038332599" format="airTop" layout="horizontal flexible">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514.a_1038332599.a1044760060" title="Restart" target="self" mode="Button" affirmed="Are you sure to restart fields?" readonly={true} size="Small" format="airRight" highlighted="Outline">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514.a_1823998057" format="airTop" layout="horizontal endjustified">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514.a_1823998057.a_232719970" title="Previous" target="self" mode="Button" readonly={true} size="Small" format="airRight" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514.a_1823998057.a_2085928678" title="Next" target="self" mode="Button" readonly={true} size="Small" format="airRight" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1758623683.a_2089563514.a_1823998057.a542237160" title="Finish" target="self" mode="Button" affirmed="Are you sure to terminate order?" size="Small" format="airRight" highlighted="Fill">
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1552588134" visible={false} layout="vertical flexible centercenter" width="100.0%" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1552588134.a1756630650" format="h4 blueColor" mode="normal" translate={true} value="Order finished. Congratulations!">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
	    if (!this.props.onProxyMessage) return;
	    this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OrderTemplate));
DisplayFactory.register("OrderTemplate", withStyles(styles, { withTheme: true })(withSnackbar(OrderTemplate)));