import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiFileEditable from "alexandria-ui-elements/src/displays/components/FileEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CheckListWizardStepPackageFileNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CheckListWizardStepPackageFileRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CheckListWizardStepPackageFile extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CheckListWizardStepPackageFileNotifier(this);
		this.requester = new CheckListWizardStepPackageFileRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a407648298" layout="vertical flexible">
					<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a407648298.a_1710561705">
					</UiFileEditable>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CheckListWizardStepPackageFile));
DisplayFactory.register("CheckListWizardStepPackageFile", withStyles(styles, { withTheme: true })(withSnackbar(CheckListWizardStepPackageFile)));