/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import io.intino.monet.box.I18n;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import java.util.Locale;

public class Formatters {
    private static final String SecondsFormat = "yyyyMMddHHmmss";
    private static final String TextDayFormat = "dd 'of' MMMM 'of' yyyy";

    public static Instant instantOf(LocalDate date) {
        return Instant.ofEpochSecond(date.toEpochDay() * 24L * 60L * 60L);
    }

    public static String countMessage(int count, String singleLabel, String pluralLabel, String language) {
        return Formatters.countMessage((long)count, singleLabel, pluralLabel, language);
    }

    public static String countMessage(long count, String singleLabel, String pluralLabel, String language) {
        if (count == 0L) {
            return I18n.translate("No " + pluralLabel, language);
        }
        if (count == 1L) {
            return "1 " + I18n.translate(singleLabel, language);
        }
        return Formatters.formattedNumber(count, language) + " " + I18n.translate(pluralLabel, language);
    }

    public static String formattedNumber(long value, String language) {
        return Formatters.formattedNumber(value, Locale.forLanguageTag(language));
    }

    public static String formattedNumber(long value, Locale locale) {
        return NumberFormat.getNumberInstance(locale).format(value);
    }

    public static String dateWithSeconds(Instant date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(SecondsFormat);
        return format.format(Date.from(date));
    }

    public static String textDate(Instant date, String language) {
        return Formatters.date(date, Formatters.textDayFormat(language), language);
    }

    public static String date(Instant date, String format, String language) {
        if (date == null) {
            return null;
        }
        return Formatters.formatDate(format, date, Formatters.locale(language));
    }

    private static String formatDate(String pattern, Instant instant, Locale locale) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        return format.format(Date.from(instant));
    }

    private static Locale locale(String language) {
        if (language.toLowerCase().contains("es")) {
            return new Locale("es", "ES");
        }
        if (language.toLowerCase().contains("pt")) {
            return new Locale("pt", "PT");
        }
        return new Locale("en", "EN");
    }

    private static String textDayFormat(String language) {
        if (language.toLowerCase().contains("es")) {
            return "dd 'de' MMMM 'de' YYYY";
        }
        if (language.toLowerCase().contains("pt")) {
            return "dd 'de' MMMM 'de' YYYY";
        }
        return TextDayFormat;
    }
}

