/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.Json;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.datasources.OrderTypesDatasource;
import io.intino.monet.box.ui.displays.items.OrderTypeItem;
import io.intino.monet.box.ui.displays.templates.AbstractOrderTypesTemplate;
import io.intino.monet.box.ui.displays.templates.OrderInputEditor;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class OrderTypesTemplate
extends AbstractOrderTypesTemplate<MonetBox> {
    private OrderTypes.Record selected;
    private static final Map<String, String> inputMap = new HashMap<String, String>();

    public OrderTypesTemplate(MonetBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.orderTypeItems.onSelect(this::open);
        this.orderTypeItems.onAddItem(this::refresh);
        this.orderTypeItems.source((Datasource)new OrderTypesDatasource((MonetBox)this.box(), this.session()));
        this.orderTypeItems.reload();
        this.openWizard.onExecute(e -> {
            this.inputDialogBox.close();
            this.openOrderTypeWizard();
        });
        this.refresh.onExecute(e -> this.orderTypeItems.reload());
        this.inputDialogBox.onOpen(e -> this.refreshInputDialog());
        this.orderTypeDialogBox.onOpen(e -> this.refreshOrderTypeDialog());
    }

    private void refresh(AddItemEvent event) {
        OrderTypes.Record orderType = (OrderTypes.Record)event.item();
        OrderTypeItem display = (OrderTypeItem)event.component();
        display.code.value(orderType.code() + ": " + this.translate(orderType.target()));
        display.label.value(orderType.label(this.language()));
        display.properties.value(this.properties(orderType).entrySet().stream().map(e -> "<b>" + (String)e.getKey() + "</b>&nbsp;" + (String)e.getValue()).collect(Collectors.joining("&nbsp;&nbsp;")));
    }

    private Map<String, String> properties(OrderTypes.Record orderType) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("manual", this.translate(orderType.isManual() ? "Yes" : "No"));
        properties.put("effort", String.valueOf(orderType.effort()));
        if (orderType.channel() != null) {
            properties.put("channel", orderType.channel().name());
        }
        if (orderType.category() != null) {
            properties.put("category", orderType.category());
        }
        if (!orderType.annexes().isEmpty()) {
            properties.put("annexes", String.join((CharSequence)", ", orderType.annexes()));
        }
        return properties;
    }

    private void refreshInputDialog() {
        this.inputs.clear();
        this.selected.input().forEach(i -> this.fill((String)i, (OrderInputEditor)this.inputs.add()));
    }

    private void refreshOrderTypeDialog() {
        if (this.selected == null) {
            return;
        }
        this.orderTypeDialogBox.title(OrderTypes.of((String)this.selected.code()).label(this.language()));
        Order order = new Order("TEST-" + this.selected.code(), this.selected.code()).input(Json.toString(this.orderInputs()));
        this.orderStamp.order(order);
        this.orderStamp.onComplete((file, form) -> {
            if (file.exists()) {
                file.delete();
            }
            this.orderTypeDialogBox.close();
        });
        this.orderStamp.testEnvironment(true);
        this.orderStamp.refresh();
    }

    private void fill(String input, OrderInputEditor display) {
        display.input(input, inputMap.getOrDefault(input, null));
        display.onChange(value -> inputMap.put(input, (String)value));
        display.refresh();
    }

    private void open(SelectionEvent event) {
        if (event.selection().size() <= 0) {
            return;
        }
        this.selected = (OrderTypes.Record)event.selection().get(0);
        this.orderTypeItems.selection(new ArrayList());
        if (this.selected == null) {
            return;
        }
        if (this.selected.isManual()) {
            this.openOrderTypeWizard();
        } else {
            this.openInputDialog();
        }
    }

    private void openInputDialog() {
        this.inputDialogBox.open();
    }

    private void openOrderTypeWizard() {
        this.orderTypeDialogBox.open();
    }

    private Map<String, String> orderInputs() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("upload", UUID.randomUUID().toString());
        if (this.selected.isManual()) {
            return result;
        }
        this.selected.input().forEach(i -> result.put((String)i, inputMap.getOrDefault(i, "")));
        return result;
    }
}

