/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.rest.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.actions.PostOrderAction;
import io.intino.monet.box.schemas.Order;

public class PostOrderResource
implements Resource {
    private MonetBox box;
    private SparkManager<SparkPushService> manager;

    public PostOrderResource(MonetBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    public void execute() throws AlexandriaException {
        this.write(this.fill(new PostOrderAction()).execute());
    }

    private PostOrderAction fill(PostOrderAction action) throws AlexandriaException {
        action.box = this.box;
        action.context = this.context();
        try {
            action.orderId = (String)RequestAdapter.adapt((String)this.manager.fromPath("orderId"), String.class);
            action.code = (String)RequestAdapter.adapt((String)this.manager.fromQueryOrElseThrow("code", () -> new BadRequest("Parameters missed")), String.class);
            action.input = (String)RequestAdapter.adapt((String)this.manager.fromQueryOrElseThrow("input", () -> new BadRequest("Parameters missed")), String.class);
            action.properties = (String)RequestAdapter.adapt((String)this.manager.fromQuery("properties"), String.class);
        }
        catch (Throwable e) {
            action.onMalformedRequest(e);
        }
        return action;
    }

    private void write(Order object) {
        this.manager.write((Object)ResponseAdapter.adapt((Object)object));
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        context.put((Object)"ip", (Object)this.manager.ip());
        return context;
    }
}

