/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;

public class HashEncoder {
    private static final List<Function<String, String>> Decoders = List.of(hash -> new String(Base64.getDecoder().decode(hash.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8), hash -> new String(Base64.getUrlDecoder().decode(hash.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8), hash -> new String(io.intino.alexandria.Base64.decode((String)hash), StandardCharsets.UTF_8));

    public static String encode(String value) {
        return HashEncoder.doEncode(HashEncoder.reverse(HashEncoder.doEncode(value)));
    }

    public static String decode(String hash) {
        return HashEncoder.doDecode(HashEncoder.reverse(HashEncoder.doDecode(hash)));
    }

    private static String reverse(String value) {
        return new StringBuilder(value).reverse().toString();
    }

    private static String doDecode(String hash) {
        String result = null;
        for (Function<String, String> decoder : Decoders) {
            try {
                result = decoder.apply(hash);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (result == null) {
            throw new RuntimeException("Failed to decode hash " + hash);
        }
        return result;
    }

    private static String doEncode(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }
}

