/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.DisplayHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FieldDefinition;
import io.intino.monet.engine.edition.FieldType;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.FormDefinition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.LocalFormStore;
import io.intino.monet.engine.edition.editors.DateEdition;
import io.intino.monet.engine.edition.editors.ImageEdition;
import io.intino.monet.engine.edition.editors.NoteEdition;
import io.intino.monet.engine.edition.editors.NumberEdition;
import io.intino.monet.engine.edition.editors.OptionEdition;
import io.intino.monet.engine.edition.editors.OptionMultipleEdition;
import io.intino.monet.engine.edition.editors.SectionEdition;
import io.intino.monet.engine.edition.editors.StringEdition;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormHelper {
    public static Form create(MonetBox box, Order order) {
        return new Form(FormHelper.formDefinition(box, order), FormHelper.store(box, order));
    }

    public static FormDefinition formDefinition(MonetBox box, Order order) {
        return new FormDefinition(FormHelper.fields(box, order).toArray(new FieldDefinition[0]));
    }

    public static Map<String, List<String>> values(Form form) {
        return form.editions(new FieldType[0]).stream().filter(e -> !e.isHidden()).collect(Collectors.toMap(Edition::name, FormHelper::valuesOf));
    }

    public static String valueOf(Edition edition) {
        return FormHelper.valueOf(FormHelper.valuesOf(edition));
    }

    public static List<String> valuesOf(Edition edition) {
        if (edition instanceof SectionEdition) {
            return Collections.singletonList(String.valueOf(!((SectionEdition)edition.as(SectionEdition.class)).isEmpty() || !edition.isOptional()));
        }
        if (edition.isEmpty() || edition.isNull()) {
            return Collections.emptyList();
        }
        if (edition instanceof DateEdition) {
            LocalDate localDate = ((DateEdition)edition.as(DateEdition.class)).get();
            return localDate != null ? Collections.singletonList(new Timetag(localDate, Scale.Day).value()) : Collections.emptyList();
        }
        if (edition instanceof ImageEdition) {
            ImageEdition.Image image = ((ImageEdition)edition.as(ImageEdition.class)).get();
            return image != null ? Collections.singletonList(image.label) : Collections.emptyList();
        }
        if (edition instanceof NoteEdition) {
            NoteEdition.Note note = ((NoteEdition)edition.as(NoteEdition.class)).get();
            return note != null ? Collections.singletonList(note.label) : Collections.emptyList();
        }
        if (edition instanceof NumberEdition) {
            return Collections.singletonList(String.valueOf(((NumberEdition)edition.as(NumberEdition.class)).get()));
        }
        if (edition instanceof OptionEdition) {
            return Collections.singletonList(((OptionEdition)edition.as(OptionEdition.class)).get());
        }
        if (edition instanceof OptionMultipleEdition) {
            return Arrays.asList(((OptionMultipleEdition)edition.as(OptionMultipleEdition.class)).get());
        }
        if (edition instanceof StringEdition) {
            return Collections.singletonList(((StringEdition)edition.as(StringEdition.class)).get());
        }
        return Collections.emptyList();
    }

    public static String valueOf(List<String> values) {
        return String.join((CharSequence)";", values);
    }

    private static List<FieldDefinition> fields(MonetBox box, Order order) {
        return FormHelper.checkListTriples(order).entrySet().stream().map(e -> new FieldDefinition(((OrderTypes.Checklist.Field)e.getKey()).name, FormHelper.triplesOf(box, e))).collect(Collectors.toList());
    }

    private static Map<String, String> triplesOf(MonetBox box, Map.Entry<OrderTypes.Checklist.Field, Map<String, String>> entry) {
        HashMap<String, String> result = new HashMap<String, String>(entry.getValue());
        result.put("attachment-repository", box.archetype().definitions().orderTypes().attachmentsDirectory().getAbsolutePath());
        result.put("thesaurus-repository", box.archetype().definitions().orderTypes().thesaurusDirectory().getAbsolutePath());
        return result;
    }

    private static Map<OrderTypes.Checklist.Field, Map<String, String>> checkListTriples(Order order) {
        return DisplayHelper.checkListTriples(order);
    }

    private static FormStore store(MonetBox box, Order order) {
        File directory = box.archetype().repository().workorders().getStoreDirectory(order.store());
        LocalFormStore result = new LocalFormStore(directory);
        try {
            result.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

