/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.orders;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.engine.Order;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrdersDatabase
implements Closeable {
    public static final String INSERT = "INSERT INTO orders (id, code, input, properties, createDate, scheduleDate, dueDate) Values ('%s','%s','%s','%s',%d,%d,%d);";
    public static final String UPDATE = "UPDATE orders SET input='%s', properties='%s', scheduleDate=%d, dueDate=%d WHERE id='%s';";
    public static final String DELETE = "DELETE FROM orders WHERE id='%s';";
    final File file;
    private Connection connection;
    private Statement modifyStatement;
    private PreparedStatement queryStatement;
    private Statement queryStatementForCount;
    private PreparedStatement requestQueryStatement;
    private int pendingTransactions = 0;
    private long lastActivity = Instant.now().toEpochMilli();
    private static final int timeThreshold = 5000;
    private static final int amountThreshold = 5000;

    public OrdersDatabase(File file) {
        this.file = file;
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + file);
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS orders (id text NOT NULL PRIMARY KEY, code text, input text, properties text, createDate bigint, scheduleDate bigint, dueDate bigint);");
            this.connection.createStatement().execute("CREATE INDEX IF NOT EXISTS idx_orders ON orders (id);");
            this.modifyStatement = this.connection.createStatement();
            this.requestQueryStatement = this.connection.prepareStatement("SELECT * FROM orders WHERE id=?");
            this.queryStatement = this.connection.prepareStatement("SELECT * FROM orders");
            this.queryStatementForCount = this.connection.createStatement();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    public synchronized void commit() {
        if (this.pendingTransactions == 0 || Instant.now().toEpochMilli() - this.lastActivity < 5000L) {
            return;
        }
        this.doCommit();
    }

    public synchronized void add(Order order) {
        try {
            Long createDate = order.createDate() != null ? Long.valueOf(order.createDate().toEpochMilli()) : null;
            Long scheduleDate = order.scheduleDate() != null ? Long.valueOf(order.scheduleDate().toEpochMilli()) : null;
            Long dueDate = order.dueDate() != null ? Long.valueOf(order.dueDate().toEpochMilli()) : null;
            String input = order.input() != null ? order.input() : "{}";
            String properties = order.properties() != null ? order.properties() : "{}";
            this.modifyStatement.execute(String.format(INSERT, order.id(), order.code(), input, properties, createDate, scheduleDate, dueDate));
            this.updatePending();
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    public synchronized void update(Order order) {
        try {
            Long scheduleDate = order.scheduleDate() != null ? Long.valueOf(order.scheduleDate().toEpochMilli()) : null;
            Long dueDate = order.dueDate() != null ? Long.valueOf(order.dueDate().toEpochMilli()) : null;
            String input = order.input() != null ? order.input() : "{}";
            String properties = order.properties() != null ? order.properties() : "{}";
            this.modifyStatement.execute(String.format(UPDATE, input, properties, scheduleDate, dueDate, order.id()));
            this.updatePending();
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    public synchronized void delete(String id) {
        try {
            this.modifyStatement.execute(String.format(DELETE, id));
            this.updatePending();
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    public synchronized List<Order> getAll() {
        List<Order> list;
        block8: {
            ResultSet rs = this.queryStatement.executeQuery();
            try {
                list = this.ordersOf(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                    return Collections.emptyList();
                }
            }
            rs.close();
        }
        return list;
    }

    public synchronized Order get(String id) {
        try {
            this.requestQueryStatement.setString(1, id);
            this.requestQueryStatement.execute();
            List<Order> orderList = this.ordersOf(this.requestQueryStatement.getResultSet());
            return orderList.isEmpty() ? null : orderList.get(0);
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public synchronized int count() {
        int n;
        block8: {
            String query = "SELECT count(*) AS total FROM orders";
            ResultSet resultSet = this.queryStatementForCount.executeQuery(query);
            try {
                n = resultSet.getInt("total");
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Logger.error((String)("Query: " + query), (Throwable)e);
                    return 0;
                }
            }
            resultSet.close();
        }
        return n;
    }

    private List<Order> ordersOf(ResultSet rs) throws SQLException {
        ArrayList<Order> result = new ArrayList<Order>();
        while (rs.next()) {
            result.add(this.orderOf(rs));
        }
        return result;
    }

    private Order orderOf(ResultSet rs) throws SQLException {
        Order result = new Order(rs.getString(1), rs.getString(2));
        result.input(rs.getString(3));
        result.properties(rs.getString(4));
        result.createDate(Instant.ofEpochMilli(rs.getLong(5)));
        result.scheduleDate(rs.getLong(6) != 0L ? Instant.ofEpochMilli(rs.getLong(6)) : null);
        result.dueDate(rs.getLong(7) != 0L ? Instant.ofEpochMilli(rs.getLong(7)) : null);
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.connection.isClosed()) {
                return;
            }
            this.doCommit();
            this.modifyStatement.close();
            this.requestQueryStatement.close();
            this.queryStatement.close();
            this.queryStatementForCount.close();
            this.connection.close();
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void updatePending() {
        ++this.pendingTransactions;
        this.lastActivity = Instant.now().toEpochMilli();
        if (this.pendingTransactions >= 5000) {
            this.doCommit();
        }
    }

    private synchronized void doCommit() {
        try {
            this.connection.commit();
            this.pendingTransactions = 0;
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    private String clean(String value) {
        return value != null ? value.replace("'", "''") : "";
    }
}

