/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.commands.order;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.commands.Command;
import io.intino.monet.box.util.OrderHelper;
import io.intino.monet.box.util.WorkReportHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.WorkReport;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FieldType;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.editors.ImageEdition;
import io.intino.monet.engine.edition.editors.NoteEdition;
import io.intino.monet.engine.edition.editors.PackageEdition;
import io.intino.monet.engine.edition.editors.SignatureEdition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResolveOrderCommand
extends Command<File> {
    public Order order;
    public boolean testEnvironment;
    public String language;
    public Form form;
    public Instant stampDate;

    public ResolveOrderCommand(MonetBox box) {
        super(box);
    }

    public static boolean canExecute(MonetBox box, Order order, Form form, String author) {
        WorkReportGenerator generator = box.orderReportGenerator();
        return generator.canGenerate(ResolveOrderCommand.workReport(order, ResolveOrderCommand.attributes(box, order, form), author), form);
    }

    public File executePreview() {
        return this.generate(ResolveOrderCommand.workReport(this.order, this.attributes(), this.images(), this.language, this.author()));
    }

    @Override
    public File execute() {
        WorkReport report = ResolveOrderCommand.workReport(this.order, this.attributes(), this.images(), this.language, this.author());
        File result = this.generate(report);
        this.savePackageFiles(result);
        this.box.orderApi().orderFinished(this.order, report, result);
        this.box.orderApi().delete(this.order);
        return result;
    }

    private File generate(WorkReport report) {
        WorkReportGenerator generator = this.box.orderReportGenerator();
        if (generator == null) {
            return null;
        }
        return generator.generate(report, this.form, this.testEnvironment);
    }

    private Map<String, String> attributes() {
        return ResolveOrderCommand.attributes(this.box, this.order, this.form);
    }

    private static Map<String, String> attributes(MonetBox box, Order order, Form form) {
        Map<String, String> result = OrderHelper.valuesOf(order, form);
        return WorkReportHelper.addCalculationsTo(result, order, box.archetype().definitions().orderTypes());
    }

    private void savePackageFiles(File result) {
        try {
            if (result == null) {
                return;
            }
            String uploadFileId = this.order.inputMap().getOrDefault("upload", null);
            if (uploadFileId == null) {
                return;
            }
            File uploadZipFile = this.box.archetype().repository().uploads().getUploadZipFile(uploadFileId);
            List<File> files = this.packageFiles();
            Zip zip = new Zip(uploadZipFile);
            zip.write(this.order.code() + "-work-report.pdf", (InputStream)new FileInputStream(result), new StandardOpenOption[0]);
            files.forEach(f -> {
                try {
                    zip.write(f.getName(), Files.newInputStream(f.toPath(), new OpenOption[0]), new StandardOpenOption[]{StandardOpenOption.CREATE});
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                }
            });
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private List<Resource> images() {
        List<Resource> result = this.form.editions(new FieldType[]{FieldType.Image}).stream().filter(f -> !f.isHidden()).map(this::resourceOf).collect(Collectors.toList());
        result.addAll(this.form.editions(new FieldType[]{FieldType.Note}).stream().filter(f -> !f.isHidden()).map(this::resourceOf).collect(Collectors.toList()));
        result.addAll(this.form.editions(new FieldType[]{FieldType.Signature}).stream().filter(f -> !f.isHidden()).map(this::resourceOf).collect(Collectors.toList()));
        return result;
    }

    private Resource resourceOf(Edition edition) {
        if (edition instanceof ImageEdition) {
            return this.resourceOf((ImageEdition)edition.as(ImageEdition.class));
        }
        if (edition instanceof NoteEdition) {
            return this.resourceOf((NoteEdition)edition.as(NoteEdition.class));
        }
        if (edition instanceof SignatureEdition) {
            return this.resourceOf((SignatureEdition)edition.as(SignatureEdition.class));
        }
        return new Resource(edition.name(), ResolveOrderCommand.class.getResourceAsStream("/empty.png"));
    }

    private Resource resourceOf(ImageEdition edition) {
        ImageEdition.Image image = edition.get();
        if (image != null && image.file != null && image.file.exists()) {
            return OrderHelper.resourceOf(image.file);
        }
        return new Resource(edition.name(), ResolveOrderCommand.class.getResourceAsStream("/empty.png"));
    }

    private Resource resourceOf(NoteEdition edition) {
        NoteEdition.Note note = edition.get();
        if (note != null && note.file != null && note.file.exists()) {
            return OrderHelper.resourceOf(note.file);
        }
        return new Resource(edition.name(), ResolveOrderCommand.class.getResourceAsStream("/empty.png"));
    }

    private Resource resourceOf(SignatureEdition edition) {
        SignatureEdition.Signature signature = edition.get();
        if (signature != null && signature.file != null && signature.file.exists()) {
            return OrderHelper.resourceOf(signature.file);
        }
        return new Resource(edition.name(), ResolveOrderCommand.class.getResourceAsStream("/empty.png"));
    }

    private List<File> packageFiles() {
        return this.form.editions(new FieldType[]{FieldType.Package}).stream().filter(f -> !f.isHidden()).map(e -> ((PackageEdition)e).get().files()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static WorkReport workReport(Order order, Map<String, String> attributes, String author) {
        return ResolveOrderCommand.workReport(order, attributes, Collections.emptyList(), "en", author);
    }

    private static WorkReport workReport(Order order, Map<String, String> attributes, List<Resource> images, String language, String author) {
        WorkReport result = new WorkReport();
        result.order(order);
        result.attributes(attributes);
        result.images(images);
        result.language(language);
        result.finished(Instant.now());
        return result;
    }
}

