/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.archetype.Archetype;
import io.intino.monet.box.OrderFinishedListener;
import io.intino.monet.box.orders.OrdersDatabase;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.WorkReport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class OrderApi {
    private final Archetype archetype;
    private final OrdersDatabase ordersDatabase;
    private OrderFinishedListener orderFinishedListener;

    public OrderApi(Archetype archetype) {
        this.archetype = archetype;
        this.ordersDatabase = new OrdersDatabase(archetype.datamarts().monet().getOrders());
    }

    public void onOrderFinished(OrderFinishedListener listener) {
        this.orderFinishedListener = listener;
    }

    public List<Order> orders() {
        return this.ordersDatabase.getAll();
    }

    public int count() {
        return this.ordersDatabase.count();
    }

    public Order order(String id) {
        return this.ordersDatabase.get(id);
    }

    public Order create(String id, String code, String input) {
        return this.create(new Order(id, code).input(input));
    }

    public Order create(Order order) {
        this.ordersDatabase.add(order);
        return order;
    }

    public Order update(Order order) {
        this.ordersDatabase.update(order);
        return order;
    }

    public void delete(String orderId) {
        this.delete(this.order(orderId));
    }

    public void delete(Order order) {
        if (order == null) {
            return;
        }
        this.ordersDatabase.delete(order.id());
        this.deleteStore(order);
    }

    public void orderFinished(Order order, WorkReport report, File reportFile) {
        if (this.orderFinishedListener == null) {
            return;
        }
        this.orderFinishedListener.accept(new OrderFinishedListener.OrderFinishedEvent().order(order).report(report).reportFile(reportFile));
    }

    public void stop() {
        this.ordersDatabase.close();
    }

    public void commit() {
        this.ordersDatabase.commit();
    }

    private void deleteStore(Order order) {
        try {
            if (order == null || order.isStoreDefined()) {
                return;
            }
            File storeDirectory = this.archetype.repository().workorders().getStoreDirectory(order.store());
            if (!storeDirectory.exists()) {
                return;
            }
            FileUtils.deleteDirectory((File)storeDirectory);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

