/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.monet.archetype.Archetype;
import io.intino.monet.box.AbstractBox;
import io.intino.monet.box.MonetConfiguration;
import io.intino.monet.box.OrderApi;
import io.intino.monet.box.OrderFinishedListener;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.commands.Commands;
import io.intino.monet.box.commands.CommandsFactory;
import io.intino.monet.engine.OrderTypes;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class MonetBox
extends AbstractBox {
    private Archetype archetype;
    private CommandsFactory commandsFactory;
    private WorkReportGenerator workReportGenerator;
    private OrderApi orderApi;

    public MonetBox(String[] args) {
        this(new MonetConfiguration(args));
        this.archetype = new Archetype(this.configuration.home());
    }

    public MonetBox(MonetConfiguration configuration) {
        super(configuration);
        this.archetype = new Archetype(configuration.home());
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        if (o instanceof WorkReportGenerator) {
            this.workReportGenerator = (WorkReportGenerator)o;
        }
        return this;
    }

    public Archetype archetype() {
        return this.archetype;
    }

    @Override
    public void beforeStart() {
        this.commandsFactory = new CommandsFactory(this);
        this.orderApi = new OrderApi(this.archetype);
        OrderTypes.init((File)this.archetype.definitions().getOrderTypes());
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
        this.orderApi.stop();
    }

    public void commitDatabases() {
        this.orderApi.commit();
    }

    public OrderApi orderApi() {
        return this.orderApi;
    }

    public void onOrderFinished(OrderFinishedListener listener) {
        this.orderApi.onOrderFinished(listener);
    }

    public WorkReportGenerator orderReportGenerator() {
        return this.workReportGenerator;
    }

    public <F extends Commands> F commands(Class<F> clazz) {
        return this.commandsFactory.command(clazz);
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        try {
            if (authServiceUrl == null) {
                return null;
            }
            return new AmidasOauthAccessor(new Space(new URL(this.configuration().url())), authServiceUrl);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public URL logoUrl() {
        try {
            String logo = this.configuration().logo();
            File logoFile = logo != null && !logo.isEmpty() ? new File(logo) : this.archetype().configuration().getLogo();
            return logoFile.exists() ? logoFile.toURI().toURL() : MonetBox.class.getResource("/logo.png");
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

