/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.office.DocxBuilder;
import io.intino.alexandria.office.ImageView;
import java.io.File;
import java.io.IOException;

public class WorkReportTemplate {
    private final File file;
    private final DocxBuilder docxBuilder;
    private boolean empty = true;

    public WorkReportTemplate(File templateFile) {
        if (!templateFile.exists()) {
            throw new IllegalArgumentException("Template file " + templateFile + " does not exist");
        }
        this.file = templateFile;
        this.docxBuilder = DocxBuilder.create((File)templateFile);
    }

    public File file() {
        return this.file;
    }

    public WorkReportTemplate set(String field, String value) {
        this.docxBuilder.replace(field, value);
        this.empty = false;
        return this;
    }

    public WorkReportTemplate set(String field, ImageView value) {
        this.docxBuilder.replace(field, value);
        this.empty = false;
        return this;
    }

    public void save(File file) throws IOException {
        this.docxBuilder.save(file);
    }

    public boolean empty() {
        return this.empty;
    }

    public String toString() {
        return "WorkReportTemplate:" + this.file.toString();
    }
}

