/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.office.PdfBuilder;
import io.intino.alexandria.office.PdfMerger;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.workreports.WorkReportBuilder;
import io.intino.monet.box.workreports.WorkReportTemplate;
import io.intino.monet.engine.WorkReport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PdfWorkReportGenerator {
    private final MonetBox box;
    private final File destination;
    private WorkReportBuilder builder;

    public PdfWorkReportGenerator(MonetBox box, File destination) {
        this.box = box;
        this.destination = destination;
        this.builder = new WorkReportBuilder(box);
    }

    public PdfWorkReportGenerator builder(WorkReportBuilder builder) {
        this.builder = builder;
        return this;
    }

    public void generate(WorkReport workReport) {
        try {
            Map<String, WorkReportTemplate> templates = this.setWorkReportInformation(workReport);
            List<File> pdfDocuments = this.generateTempPdfDocuments(templates);
            this.mergeAndGenerateTheFinalWorkReportDocument(pdfDocuments);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void mergeAndGenerateTheFinalWorkReportDocument(List<File> pdfDocuments) throws IOException {
        try {
            if (pdfDocuments.size() == 1) {
                this.moveToDestination(pdfDocuments.get(0));
            } else {
                this.mergeIntoTheFinalDocument(pdfDocuments);
            }
        }
        finally {
            pdfDocuments.forEach(File::delete);
        }
    }

    private void mergeIntoTheFinalDocument(List<File> pdfDocuments) throws IOException {
        PdfMerger merger = new PdfMerger();
        pdfDocuments.forEach(arg_0 -> ((PdfMerger)merger).append(arg_0));
        merger.merge(this.destination);
    }

    private void moveToDestination(File file) throws IOException {
        Files.move(file.toPath(), this.destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private List<File> generateTempPdfDocuments(Map<String, WorkReportTemplate> templates) {
        return templates.values().stream().map(this::generateDocumentFor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private File generateDocumentFor(WorkReportTemplate template) {
        File tmpFile = new File(this.box.archetype().tmp().root(), this.currentInstant() + ".docx");
        File pdfFile = new File(this.box.archetype().tmp().root(), this.currentInstant() + ".pdf");
        if (template.empty()) {
            return null;
        }
        try {
            template.save(tmpFile);
            PdfBuilder.create((File)tmpFile).save(pdfFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating pdf of " + template.file() + ": " + e.getMessage(), e);
        }
        finally {
            tmpFile.delete();
        }
        return pdfFile;
    }

    private String currentInstant() {
        return Instant.now().toString().replace(":", "");
    }

    private Map<String, WorkReportTemplate> setWorkReportInformation(WorkReport workReport) throws WorkReportBuilder.WorkReportException {
        return this.builder.workReport(workReport).build();
    }
}

