import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CheckListWizardIndexEntryNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CheckListWizardIndexEntryRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CheckListWizardIndexEntry extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CheckListWizardIndexEntryNotifier(this);
		this.requester = new CheckListWizardIndexEntryRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="topDottedBordered checkListWizardIndexEntryStyle" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_677756937" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_677756937.a_1726014727" layout="vertical" width="30.0%" height="100.0%">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_677756937.a_1726014727.a_592930520" title="" target="self" mode="Link" size="Medium" format="bold">
						</UiAction>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_677756937.a_1222836468" layout="vertical" width="70.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_677756937.a_1222836468.a642204782" mode="normal">
						</UiText>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CheckListWizardIndexEntry));
DisplayFactory.register("CheckListWizardIndexEntry", withStyles(styles, { withTheme: true })(withSnackbar(CheckListWizardIndexEntry)));