import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractAttachmentRenderer from "../../gen/displays/AbstractAttachmentRenderer";
import AttachmentRendererNotifier from "../../gen/displays/notifiers/AttachmentRendererNotifier";
import AttachmentRendererRequester from "../../gen/displays/requesters/AttachmentRendererRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';
import InnerHTML from 'dangerously-set-html-content'

const styles = theme => ({});

class AttachmentRenderer extends AbstractAttachmentRenderer {

	constructor(props) {
		super(props);
		this.notifier = new AttachmentRendererNotifier(this);
		this.requester = new AttachmentRendererRequester(this);
		this.state = {
		    ...this.state,
		    content: this.props.content != null ? this.props.content : '',
		}
	};

	render() {
	    if (this.state.content === "") return (<React.Fragment/>);
	    return (<InnerHTML id={this.props.id + "-html"} html={this.state.content} />);
	};

	refresh = (content) => {
	    this.setState({content});
	};

}

export default withStyles(styles, { withTheme: true })(withSnackbar(AttachmentRenderer));
DisplayFactory.register("AttachmentRenderer", withStyles(styles, { withTheme: true })(withSnackbar(AttachmentRenderer)));