import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractProgressDisplay from "../../gen/displays/AbstractProgressDisplay";
import ProgressDisplayNotifier from "../../gen/displays/notifiers/ProgressDisplayNotifier";
import ProgressDisplayRequester from "../../gen/displays/requesters/ProgressDisplayRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';
import classNames from 'classnames';

const styles = theme => ({
    bar : {
        height: '15px',
        width: '100%',
        position: 'relative',
        border: '1px solid #aaa'
    },
    title : {
        position: 'absolute',
        color: 'black',
        fontSize: '7pt',
    },
    left : {
        background: '#2e8e00', // Green
        position: 'absolute',
        height: '100%',
        color: 'white',
        fontSize: '8pt',
        fontWeight: 'bold',
        paddingLeft: '3px',
    },
    center : {
        position: 'absolute',
        textAlign: 'center',
        width: '100%',
        marginTop: '-2px',
        zIndex: '1',
    },
    right : {
        background: '#c2c2c2', // Grey
        position: 'absolute',
        height: '100%',
        color: '#c2c2c2',
        fontSize: '8pt',
        fontWeight: 'bold',
        paddingRight: '3px',
        textAlign: 'right',
    },
});

class ProgressDisplay extends AbstractProgressDisplay {

	constructor(props) {
		super(props);
		this.notifier = new ProgressDisplayNotifier(this);
		this.requester = new ProgressDisplayRequester(this);
		this.state = {
		    value: 0,
		    label: '',
		}
	};

	render() {
	    const value = this.state.value;
	    if (value == -1) return (<React.Fragment/>);
	    const { classes } = this.props;
	    const doneWidth = this._doneWidth();
	    const remainingWidth = this._remainingWidth();
	    const doneVisible = doneWidth > 5;
	    const remainingVisible = remainingWidth > 15;
	    return (
	        <div style={{height:'15px'}}>
                <div className={classes.bar} title={this._valueFullText()}>
                    {this.state.label != null && <div className={classes.center}>{this.state.label}</div>}
                    <div className={classes.left} style={{width:doneWidth+'%',paddingLeft:doneWidth==0?'0':'3px'}} >{doneVisible && this._doneValueText(doneWidth)}</div>
                    <div className={classes.right} style={{left:doneWidth+'%',width:remainingWidth+'%',paddingRight:remainingWidth==0?'0':'3px'}}>{remainingVisible && this._remainingValueText(remainingWidth)}</div>
                </div>
            </div>
	    );
	};

	_doneWidth = () => {
	    const value = this.state.value;
	    if (value > 100) return 100;
	    return Math.round(value);
	};

	_remainingWidth = () => {
	    return 100 - this._doneWidth();
	};

	_valueFullText = () => {
	    const value = this.state.value;
	    const doneValue = value + "%";
	    const remainingValue = (100-value) + "%";
	    return doneValue + " " + this.translate("of") + " " + remainingValue;
    };

	_doneValueText = (doneWidth) => {
	    const value = this.state.value;
	    return value + "%";
	};

	_remainingValueText = (remainingWidth) => {
	    const value = this.state.value;
	    return (100-value) + "%";
	};

	refresh = (data) => {
	    this.setState({value: data.value, label: data.label});
	};

}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProgressDisplay));
DisplayFactory.register("ProgressDisplay", withStyles(styles, { withTheme: true })(withSnackbar(ProgressDisplay)));