import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import OrderItemNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import OrderItemRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OrderItem extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new OrderItemNotifier(this);
		this.requester = new OrderItemRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a882160958" format="verySmallSize greyColor" mode="uppercase">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1585078723" format="h5" mode="normal">
				</UiText>
				<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1591012412" format="body2 cleanHtmlStyle" mode="normal" language="Html" value="">
				</UiTextCode>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(OrderItem));
DisplayFactory.register("OrderItem", withStyles(styles, { withTheme: true })(withSnackbar(OrderItem)));