import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"pt" : {
			"No elements" : "Sem elementos",
			"Could not resolve order" : "Não foi possível resolver o pedido",
			"Could not resolve order. Check parameters." : "Não foi possível resolver o pedido. Verifique os parâmetros.",
			"Could not preview order" : "Não foi possível visualizar o pedido",
			"Could not preview order. Check parameters." : "Não foi possível visualizar o pedido. Verifique os parâmetros.",
			"Refresh" : "Atualizar",
			"Preview" : "Vista prévia",
			"Cancel" : "Cancelar",
			"Accept" : "Aceitar",
			"Previous" : "Anterior",
			"Next" : "Próximo",
			"Finish" : "Finalizar",
			"Continue" : "Continuar",
			"Add" : "Adicionar",
			"Download" : "Download",
			"Remove" : "Retirar",
			"Affirm" : "Confirme",
			"Photo description (optional)" : "Descrição da foto (opcional)",
			"Photo (optional)" : "Foto (opcional)",
			"Do you want to complete this section?" : "Deseja completar esta seção?",
			"No files added" : "Nenhum arquivo adicionado",
			"Value out of range: %.1f-%.1f" : "Valor fora do intervalo: %.1f-%.1f",
			"Restart" : "Reiniciar",
			"Are you sure to restart fields?" : "Tem certeza de reiniciar os campos?",
			"Are you sure to terminate order?" : "Tem certeza de encerrar o pedido?",
			"%d steps" : "%d passos",
			"Fill inputs" : "Encher inputs",
			"Edition" : "Edição",
			"Index" : "Índice",
			"No steps completed" : "Nenhuma etapa concluída",
			"Not filled" : "Não preenchido",
			"Filled" : "Preenchido",
			"file" : "arquivo",
			"files" : "arquivos",
			"Congratulations! you have finished order" : "Parabéns! você terminou o pedido",
			"View work report" : "Ver relatório de trabalho",
			"View index" : "Ver índice",
			"No files" : "Sem arquivos",
			"Image defined" : "Imagem definida",
			"Signature defined" : "Assinatura definida",
			"Image not defined" : "Imagem não definida",
			"Signature not defined" : "Assinatura não definida",
			"Work report not found" : "Relatório de trabalho não encontrado",
			"Order saved" : "Pedido salvo",
			"Skip step" : "Pular etapa",
			"Order not found" : "Pedido não encontrado",
			"Order finished. Congratulations!" : "Encomenda finalizada. Parabéns!",
			"View details" : "Ver detalhes"
		},
		"es" : {
			"No elements" : "Sin elementos",
			"Could not resolve order" : "No se pudo resolver la orden",
			"Could not resolve order. Check parameters." : "No se pudo resolver la orden. Compruebe los parámetros.",
			"Could not preview order" : "No se pudo generar la vista previa",
			"Could not preview order. Check parameters." : "No se pudo generar la vista previa. Compruebe los parámetros.",
			"Refresh" : "Refrescar",
			"Preview" : "Vista previa",
			"Cancel" : "Cancelar",
			"Accept" : "Aceptar",
			"Previous" : "Anterior",
			"Next" : "Siguiente",
			"Finish" : "Finalizar",
			"Continue" : "Continuar",
			"Add" : "Añadir",
			"Download" : "Descargar",
			"Remove" : "Quitar",
			"Affirm" : "Confirmar",
			"Photo description (optional)" : "Descripción de la foto (opcional)",
			"Photo (optional)" : "Foto (opcional)",
			"Do you want to complete this section?" : "¿Desea cumplimentar esta sección?",
			"No files added" : "No se han añadido archivos",
			"Value out of range: %.1f-%.1f" : "Valor fuera de rango: %.1f-%.1f",
			"Restart" : "Reiniciar",
			"Are you sure to restart fields?" : "¿Está seguro/a que desea reiniciar los campos?",
			"Are you sure to terminate order?" : "¿Está seguro que desea terminar la orden de trabajo?",
			"%d steps" : "%d pasos",
			"Fill inputs" : "Rellenar inputs",
			"Edition" : "Edición",
			"Index" : "Índice",
			"No steps completed" : "Sin pasos completados",
			"Not filled" : "Sin cumplimentar",
			"Filled" : "Cumplimentado",
			"file" : "archivo",
			"files" : "archivos",
			"Congratulations! you have finished order" : "¡Felicidades! Ha finalizado la orden",
			"View work report" : "Ver el parte de trabajo",
			"View index" : "Ver índice",
			"No files" : "Sin archivos",
			"Image defined" : "Imagen definida",
			"Signature defined" : "Firma definida",
			"Image not defined" : "Imagen no definida",
			"Signature not defined" : "Firma no definida",
			"Work report not found" : "Parte de trabajo no encontrado",
			"Order saved" : "Orden guardada",
			"Skip step" : "Saltar paso",
			"Order not found" : "Orden no encontrada",
			"Order finished. Congratulations!" : "Orden finalizada. ¡Felicidades!",
			"View details" : "Ver detalles"
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;