/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework.stores;

import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.loaders.ClassFinder;
import io.intino.magritte.io.StashDeserializer;
import io.intino.magritte.io.model.Stash;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;

public class ResourcesStore
implements Store {
    Set<String> whileList = new HashSet<String>();

    @Override
    public Stash stashFrom(String path) {
        InputStream stream;
        InputStream inputStream = stream = this.shouldOpen(path) ? ClassFinder.getResourceAsStream(this.getPath(path)) : null;
        if (stream == null) {
            return null;
        }
        return StashDeserializer.stashFrom((InputStream)stream);
    }

    public Store setWhiteList(Collection<String> whileList) {
        this.whileList.clear();
        this.whileList.addAll(whileList);
        return this;
    }

    private boolean shouldOpen(String path) {
        return this.whileList.isEmpty() || this.whileList.contains(path);
    }

    @Override
    public String relativePathOf(URL url) {
        try {
            if (url.getProtocol().contains("jar")) {
                return this.relativePathOfJar(url.toString());
            }
            String inputPath = new File(url.toURI()).getAbsolutePath();
            String rootPath = Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).filter(path -> !path.endsWith(".jar")).map(path -> path.endsWith(File.separator) ? path : path + File.separator).filter(inputPath::startsWith).findFirst().orElse("");
            return inputPath.substring(rootPath.length());
        }
        catch (URISyntaxException | NoSuchElementException e) {
            Logger.getGlobal().severe(e.getCause().getMessage());
            Logger.getGlobal().severe("Url at " + url.toString() + " is not inside java resources");
            return null;
        }
    }

    private String relativePathOfJar(String url) {
        return url.substring(url.indexOf("jar!/") + 5);
    }

    @Override
    public URL resourceFrom(String path) {
        return ClassFinder.getResource(this.getPath(path));
    }

    @Override
    public URL writeResource(InputStream inputStream, String newPath, URL oldUrl, Node node) {
        Logger.getGlobal().severe("Resource at " + newPath + "could not be stored. Stores based on java resources cannot save resources. Use a file system based store.");
        return null;
    }

    @Override
    public void writeStash(Stash stash, String path) {
        Logger.getGlobal().severe("Stash at " + path + "could not be stored. Stores based on java resources cannot save stashes");
    }

    @Override
    public boolean allowWriting() {
        return false;
    }

    private String getPath(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }
}

