/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Node;
import java.util.List;
import java.util.function.BinaryOperator;

public class GraphMerger {
    public static Graph doMerge(Graph mergedGraph, List<Graph> graphs, BinaryOperator<Node> operator) {
        graphs.forEach(g -> {
            mergedGraph.loaders.addAll(g.loaders);
            mergedGraph.languages.addAll(g.languages);
            g.concepts.forEach((k, v) -> mergedGraph.concepts.putIfAbsent((String)k, (Concept)v));
            g.nodes.forEach((k, v) -> {
                Node node = v;
                if (mergedGraph.nodes.containsKey(k)) {
                    node = (Node)operator.apply(mergedGraph.nodes.get(k), v);
                }
                mergedGraph.nodes.put((String)k, node);
            });
            if (mergedGraph.layerFactory == null) {
                mergedGraph.layerFactory = g.layerFactory;
            }
            mergedGraph.openedStashes.addAll(g.openedStashes);
        });
        mergedGraph.nodes.forEach((k, v) -> mergedGraph.model.add((Node)v));
        return mergedGraph;
    }
}

