/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.operations;

import io.intino.builder.CompilerConfiguration;
import io.intino.magritte.builder.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.magritte.io.StashSerializer;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StashGenerationOperation
extends ModelOperation {
    public static final String STASH = ".stash";
    private static final Logger LOG = Logger.getLogger(StashGenerationOperation.class.getName());
    private final CompilerConfiguration conf;
    private String outDSL;
    private boolean M1;

    public StashGenerationOperation(CompilationUnit compilationUnit) {
        super(compilationUnit);
        this.conf = compilationUnit.configuration();
    }

    public void call(Model model) {
        this.outDSL = this.conf.dsl().outDsl() == null ? this.conf.module() : this.conf.dsl().outDsl();
        this.M1 = model.mograms().stream().anyMatch(m -> m.level() == Level.M1);
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println("@#$%@# Presentable:[" + this.conf.module() + " - " + this.conf.dsl().outDsl() + "] Generating Stashes...");
            }
            if (this.conf.test() || this.M1) {
                this.createSeparatedStashes(model);
            } else {
                this.createFullStash(model);
            }
        }
        catch (TaraException e) {
            LOG.log(java.util.logging.Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.unit.getPhase(), this.unit, (Throwable)e);
        }
    }

    private void createSeparatedStashes(Model model) {
        this.unpack(model).forEach(mograms -> {
            try {
                this.writeStashTo(this.stashDestination(new File(((Mogram)mograms.get(0)).source().getPath())), this.stashOf((List<Mogram>)mograms, this.unit.language()));
            }
            catch (TaraException e) {
                LOG.log(java.util.logging.Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
            }
        });
    }

    private void createFullStash(Model model) throws TaraException {
        if (model.components().isEmpty()) {
            return;
        }
        this.writeStashTo(this.stashDestination(new File(((Mogram)model.components().get(0)).source().getPath())), this.stashOf(model.components(), this.unit.language()));
    }

    private Stash stashOf(List<Mogram> mograms, Language language) throws TaraException {
        try {
            return new StashCreator(mograms, language, this.outDSL, this.conf).create();
        }
        catch (Throwable e) {
            throw new TaraException("Error creating stashes: " + e.getMessage());
        }
    }

    private void writeStashTo(File taraFile, Stash stash) {
        try {
            byte[] content = StashSerializer.serialize((Stash)stash);
            File file = this.stashDestination(taraFile);
            stash.path = file.getName();
            file.getParentFile().mkdirs();
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(content);
            }
            catch (IOException e) {
                LOG.log(java.util.logging.Level.SEVERE, "Error writing stashes: " + e.getMessage(), e);
                throw new CompilationFailedException(this.unit.getPhase(), this.unit, (Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.log(java.util.logging.Level.SEVERE, "Error writing stashes: " + e.getMessage(), e);
            throw new CompilationFailedException(this.unit.getPhase(), this.unit, e);
        }
    }

    private File stashDestination(File taraFile) {
        File target = this.conf.outDirectory();
        target.mkdirs();
        return this.conf.test() || this.M1 ? new File(target, taraFile.getName().split("\\.")[0] + STASH) : new File(target, Format.firstUpperCase().format((Object)this.conf.dsl().outDsl()).toString() + STASH);
    }

    private List<List<Mogram>> unpack(Model model) {
        HashMap<String, List<Mogram>> mograms = new HashMap<String, List<Mogram>>();
        model.components().forEach(m -> {
            if (!mograms.containsKey(m.source().getPath())) {
                mograms.put(m.source().getPath(), new ArrayList());
            }
            ((List)mograms.get(m.source().getPath())).add(m);
        });
        return this.unpack(mograms);
    }

    private List<List<Mogram>> unpack(Map<String, List<Mogram>> mograms) {
        return new ArrayList<List<Mogram>>(mograms.values());
    }
}

