/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.operations;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Engine;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.AbstractGraphCreator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.GraphLoaderCreator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerFrameCreator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.templates.GraphTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativesCreator;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LayerGenerationOperation
extends ModelOperation
implements TemplateTags {
    private static final Logger LOG = Logger.getGlobal();
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private static final String GRAPH = "Graph";
    private final CompilerConfiguration conf;
    private final File srcFolder;
    private final File outFolder;
    private final Engine engine;
    private final Map<String, List<String>> outMap = new LinkedHashMap<String, List<String>>();

    public LayerGenerationOperation(CompilationUnit compilationUnit) {
        super(compilationUnit);
        this.conf = compilationUnit.configuration();
        this.outFolder = this.conf.genDirectory();
        this.srcFolder = this.conf.srcDirectory();
        this.engine = Generator.customize(new LayerTemplate());
    }

    public void call(Model model) {
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Cleaning Old Layers...");
            }
            if (model.mograms().stream().anyMatch(m -> m.level() != Level.M1)) {
                this.cleanOldLayers(model);
            }
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Generating Layers...");
            }
            this.createClasses(model);
            this.registerOutputs(this.writeNativeClasses(model));
            this.unit.addOutputItems(this.outMap);
        }
        catch (Throwable e) {
            LOG.log(java.util.logging.Level.SEVERE, "Error during java className generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.unit.getPhase(), this.unit, e);
        }
    }

    private Map<String, String> writeNativeClasses(Model model) {
        return new NativesCreator(model, this.unit.language(), this.conf).create();
    }

    private void createClasses(Model model) {
        if (model.mograms().stream().anyMatch(m -> m.level() != Level.M1)) {
            Map<String, Map<String, String>> layers = this.createLayerClasses(model);
            layers.values().forEach(this::writeLayers);
            this.writeAbstractGraph(model, layers);
            this.writeGraph(this.createGraph());
        } else {
            this.writeGraphLoader(model);
        }
    }

    private void writeGraphLoader(Model model) {
        File target = new File(new File(this.outFolder, this.conf.generationPackage().toLowerCase().replace(DOT, File.separator)), "GraphLoader.java");
        this.write(target, new GraphLoaderCreator(this.unit.language(), this.conf).create(model));
        if (this.outMap.isEmpty()) {
            this.unit.getSourceUnits().forEach((s, v) -> this.put(s.getPath(), target.getAbsolutePath()));
        } else {
            for (List<String> paths : this.outMap.values()) {
                paths.add(target.getAbsolutePath());
            }
        }
    }

    private void writeAbstractGraph(Model model, Map<String, Map<String, String>> layers) {
        AbstractGraphCreator abstractGraphCreator = new AbstractGraphCreator(this.unit.language(), this.conf);
        this.registerOutputs(layers, this.writeAbstractGraph(abstractGraphCreator.create(model)));
    }

    private void registerOutputs(Map<String, Map<String, String>> layers, String abstractGraphPath) {
        this.fillLayerInOutMap(layers);
        for (List<String> paths : this.outMap.values()) {
            paths.add(abstractGraphPath);
        }
    }

    private void registerOutputs(Map<String, String> nativeOuts) {
        for (Map.Entry<String, String> src : nativeOuts.entrySet()) {
            if (!this.outMap.containsKey(src.getValue())) {
                this.outMap.put(src.getValue(), new ArrayList());
            }
            this.outMap.get(src.getValue()).add(src.getKey());
        }
    }

    private void fillLayerInOutMap(Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            for (String out : entry.getValue().keySet()) {
                if (this.isUnderSource(new File(out))) continue;
                this.put(entry.getKey(), out);
            }
        }
    }

    private void put(String key, String value) {
        if (!this.outMap.containsKey(key)) {
            this.outMap.put(key, new ArrayList());
        }
        this.outMap.get(key).add(value);
    }

    private String createGraph() {
        FrameBuilder builder = new FrameBuilder(new String[]{"wrapper"});
        builder.add("generatedLanguage", (Object)this.conf.dsl().outDsl());
        builder.add("workingPackage", (Object)this.conf.generationPackage());
        return Generator.customize(new GraphTemplate()).render((Object)builder.toFrame());
    }

    private Map<String, Map<String, String>> createLayerClasses(Model model) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        model.components().stream().filter(mogram -> mogram.level() != Level.M1).forEach(mogram -> this.renderMogram((Map<String, Map<String, String>>)map, (Mogram)mogram));
        return map;
    }

    private void renderMogram(Map<String, Map<String, String>> map, Mogram mogram) {
        String destination;
        Map.Entry<String, Frame> layerFrame = new LayerFrameCreator(this.conf, this.unit.language()).create(mogram);
        if (!map.containsKey(mogram.source().getPath())) {
            map.put(mogram.source().getPath(), new LinkedHashMap());
        }
        map.get(mogram.source().getPath()).put(destination, new File(destination = this.destination(layerFrame)).exists() ? "" : this.render(layerFrame));
        this.renderFrame(map, mogram, layerFrame);
    }

    private void renderFrame(Map<String, Map<String, String>> map, Mogram mogram, Map.Entry<String, Frame> layerFrame) {
        if (mogram.is(Annotation.Decorable)) {
            Map.Entry<String, Frame> frame = new LayerFrameCreator(this.conf, this.unit.language()).createDecorable(mogram);
            File file = new File(this.srcTarget(frame));
            if (file.exists() && mogram.is(Annotation.Generalization)) {
                this.checkAbstractDecorable(file);
            }
            map.get(mogram.source().getPath()).put(file.getAbsolutePath(), file.exists() ? "" : this.render(frame));
        } else {
            this.removeDecorable(layerFrame.getKey(), mogram.name());
        }
    }

    private void checkAbstractDecorable(File file) {
        try {
            String text = Files.readString(file.toPath());
            if (text.contains("public class")) {
                text = text.replaceFirst("public class", "public abstract class");
                Files.writeString(file.toPath(), (CharSequence)text, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            LOG.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
    }

    private void removeDecorable(String key, String name) {
        File parentFile = new File(this.outFolder, key.replace(DOT, File.separator) + JAVA).getParentFile();
        File file = new File(parentFile, Format.firstUpperCase().format(Format.javaValidName().format((Object)("abstract" + name))).toString() + JAVA);
        if (file.exists()) {
            file.delete();
        }
    }

    private String destination(Map.Entry<String, Frame> layerFrameMap) {
        return new File(this.outFolder, layerFrameMap.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String srcTarget(Map.Entry<String, Frame> layerFrameMap) {
        return new File(this.srcFolder, layerFrameMap.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private void writeLayers(Map<String, String> layersMap) {
        for (Map.Entry<String, String> entry : layersMap.entrySet()) {
            File file = new File(entry.getKey());
            if (entry.getValue().isEmpty() || this.isUnderSource(file) && file.exists()) continue;
            file.getParentFile().mkdirs();
            this.write(file, entry.getValue());
        }
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private String writeAbstractGraph(String text) {
        File target = new File(new File(this.outFolder, this.conf.generationPackage().replace(DOT, File.separator)), "AbstractGraph.java");
        target.getParentFile().mkdirs();
        return this.write(target, text) ? target.getAbsolutePath() : null;
    }

    private void writeGraph(String text) {
        File target = new File(new File(this.srcFolder, this.conf.generationPackage().toLowerCase().replace(DOT, File.separator)), String.valueOf(Format.firstUpperCase().format(Format.javaValidName().format((Object)this.conf.dsl().outDsl()))) + "Graph.java");
        if (!target.exists()) {
            this.write(target, text);
        }
    }

    private void cleanOldLayers(Model model) {
        String generationPackage = this.conf.generationPackage() == null ? this.conf.module() : this.conf.generationPackage();
        File out = new File(this.conf.genDirectory(), generationPackage.toLowerCase());
        List<File> layers = this.filterOld(this.collectAllLayers(out), out, model);
        layers.forEach(File::delete);
    }

    private List<File> filterOld(List<File> files, File base, Model model) {
        List<File> current = this.calculateCurrentLayers(base, model);
        return files.stream().filter(layer -> !current.contains(layer) && !this.isUnderSource((File)layer)).collect(Collectors.toList());
    }

    private List<File> calculateCurrentLayers(File base, Model model) {
        return model.components().stream().filter(m -> m.level() != Level.M1 && !m.isAnonymous()).map(m -> new File(this.calculateLayerPath((Mogram)m, base) + JAVA)).collect(Collectors.toList());
    }

    private String calculateLayerPath(Mogram mogram, File generationPackage) {
        return generationPackage.getPath() + File.separator + Format.javaValidName().format((Object)mogram.name()).toString();
    }

    private List<File> collectAllLayers(File out) {
        ArrayList<File> list = new ArrayList<File>();
        if (!out.isDirectory() && !out.getName().equals("Graph.java")) {
            list.add(out);
        } else if (!out.isDirectory()) {
            for (File file : Objects.requireNonNull(out.listFiles(f -> !"natives".equals(f.getName())))) {
                list.addAll(this.collectAllLayers(file));
            }
        }
        return list;
    }

    private boolean write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)text, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            LOG.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private String render(Map.Entry<String, Frame> layerFrame) {
        return this.engine.render((Object)layerFrame.getValue());
    }

    private String prefix() {
        return "@#$%@# Presentable:[" + this.conf.module() + " - " + this.conf.dsl().outDsl() + "]";
    }
}

