/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.stash;

import io.intino.builder.CompilerConfiguration;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.stash.StashHelper;
import io.intino.magritte.io.Helper;
import io.intino.magritte.io.model.Concept;
import io.intino.magritte.io.model.Node;
import io.intino.magritte.io.model.Stash;
import io.intino.magritte.io.model.Variable;
import io.intino.tara.Language;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StashCreator {
    private static final String STASH = ".stash";
    private final List<Mogram> mograms;
    private final Language language;
    private final File resourceFolder;
    private final boolean test;
    private final Stash stash = new Stash();
    private final String outDSL;
    private final String workingPackage;

    public StashCreator(List<Mogram> mograms, Language language, String outDSL, CompilerConfiguration conf) {
        this.mograms = mograms;
        this.language = language;
        this.outDSL = Format.javaValidName().format(Format.firstUpperCase().format((Object)outDSL)).toString();
        this.workingPackage = conf.generationPackage();
        this.resourceFolder = conf.resDirectory();
        this.test = conf.test();
        this.stash.language = language.languageName();
        this.stash.path = (mograms.stream().anyMatch(m -> m.level().ordinal() > Level.M1.ordinal()) ? outDSL : new File(mograms.getFirst().source()).getName().split("\\.")[0]) + STASH;
    }

    private static String toSystemIndependentName(String fileName) {
        return fileName.replace('\\', '/');
    }

    public Stash create() {
        this.mograms.forEach(node -> this.create((Mogram)node, null));
        this.stash.contentRules = this.collectContents(this.mograms.stream().filter(mogram -> !mogram.is(Annotation.Component) && mogram.facetPrescription() == null && mogram.level() != Level.M1).collect(Collectors.toList()));
        return this.stash;
    }

    private void create(Mogram mogram, Concept container) {
        if (mogram.level() == Level.M1) {
            if (container == null) {
                this.stash.nodes.add(this.createNode(mogram));
            } else {
                container.nodes.add(this.createNode(mogram));
            }
        } else {
            this.createConcept(mogram);
        }
    }

    private void createConcept(Mogram mogram) {
        if (mogram.facetPrescription() != null) {
            this.stash.concepts.addAll(this.createFacetConcept(mogram));
        } else {
            List<Mogram> components = this.collectTypeComponents(mogram.components());
            Concept concept = Helper.newConcept((String)StashHelper.name(mogram, this.workingPackage), (boolean)mogram.is(Annotation.Generalization), (mogram.level() == Level.M3 ? 1 : 0) != 0, (mogram.facetPrescription() != null ? 1 : 0) != 0, (mogram.container() instanceof Model && !mogram.is(Annotation.Component) ? 1 : 0) != 0, (String)this.className(mogram), (String)(mogram.parent() != null ? Format.qualifiedName().format((Object)NameFormatter.layerQualifiedName((Mogram)mogram.parent().get())).toString() : null), StashHelper.collectTypes(mogram), this.collectContents(components), this.propertiesOf(mogram), this.parametersOf(mogram), Collections.emptyList());
            this.stash.concepts.add(concept);
            for (Mogram component : mogram.mograms()) {
                this.create(component, concept);
            }
        }
    }

    private List<Concept> createFacetConcept(Mogram facetMogram) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        Concept concept = new Concept();
        concepts.add(concept);
        concept.isMetaConcept = facetMogram.level().equals((Object)Level.M3);
        concept.isAbstract = facetMogram.is(Annotation.Generalization);
        concept.isAspect = true;
        concept.name = StashHelper.name(facetMogram, this.workingPackage);
        concept.className = this.facetClassName(facetMogram);
        concept.types = StashHelper.collectTypes(facetMogram);
        concept.parent = this.calculateParent(facetMogram);
        concept.variables = this.propertiesOf(facetMogram);
        concept.parameters = this.parametersOf(facetMogram);
        concept.contentRules = this.collectContents(this.collectTypeComponents(facetMogram.components()));
        for (Mogram component : facetMogram.components()) {
            this.create(component, concept);
        }
        return concepts;
    }

    private String className(Mogram mogram) {
        return this.workingPackage + "." + Format.withDollar().format(Format.noPackage().format((Object)NameFormatter.getQn(mogram, this.workingPackage))).toString();
    }

    private String facetClassName(Mogram facetMogram) {
        return this.workingPackage + "." + String.valueOf(Format.withDollar().format((Object)Format.noPackage().format((Object)NameFormatter.getQn(facetMogram, this.workingPackage)).toString()));
    }

    private String calculateParent(Mogram mogram) {
        return mogram.parent() != null ? NameFormatter.layerQn((Mogram)mogram.parent().get()) : null;
    }

    private Concept createChildAspectType(Mogram facetMogram, Mogram mogram, Concept parent) {
        Concept child = new Concept();
        child.name = StashHelper.name(facetMogram, this.workingPackage);
        child.parent = parent.name;
        child.isAbstract = facetMogram.is(Annotation.Generalization);
        child.className = this.facetClassName(facetMogram);
        ArrayList<String> childTypes = new ArrayList<String>(parent.types);
        childTypes.add(parent.name);
        child.types = new ArrayList(childTypes);
        child.contentRules = parent.contentRules;
        return child;
    }

    private List<Mogram> collectTypeComponents(List<Mogram> mograms) {
        return mograms.stream().filter(component -> component.level() != Level.M1).collect(Collectors.toList());
    }

    private List<Concept.Content> collectContents(List<Mogram> mograms) {
        return mograms.stream().filter(m -> m.facetPrescription() == null && m.level() != Level.M1).map(m -> new Concept.Content(NameFormatter.layerQualifiedName(m), m.container().sizeOf((Element)m).min(), m.container().sizeOf((Element)m).max())).collect(Collectors.toList());
    }

    private List<Node> createNodes(List<Mogram> nodes) {
        return nodes.stream().map(this::createNode).collect(Collectors.toList());
    }

    private Node createNode(Mogram node) {
        Node instanceNode = new Node();
        instanceNode.name = this.buildReferenceName(node);
        instanceNode.layers.addAll(StashHelper.collectTypes(node));
        instanceNode.variables.addAll(this.parametersOf(node));
        instanceNode.nodes.addAll(this.createNodes(node.components()));
        return instanceNode;
    }

    private boolean isNotEmpty(Valued v) {
        return !v.values().isEmpty() && v.values().getFirst() != null && StashCreator.isNotEmptyReference(v);
    }

    private static boolean isNotEmptyReference(Valued v) {
        Primitive.Reference r;
        Object e = v.values().getFirst();
        if (e instanceof Primitive.Reference && (r = (Primitive.Reference)e).isEmpty()) {
            return false;
        }
        return !(v.values().getFirst() instanceof EmptyMogram);
    }

    private List<Variable> propertiesOf(Mogram mogram) {
        return mogram.properties().stream().filter(this::isNotEmpty).map(this::transformTaraVariableToStashVariable).toList();
    }

    private List<Variable> parametersOf(Mogram mogram) {
        return mogram.parameters().stream().filter(this::isNotEmpty).map(this::createVariableFromParameter).toList();
    }

    private Variable transformTaraVariableToStashVariable(Property prop) {
        Variable variable = new Variable();
        variable.name = prop.name();
        variable.values = prop.isReference() && !(prop.values().get(0) instanceof Primitive.Expression) ? this.buildReferenceValues(prop.values()) : (prop.values().get(0) instanceof Primitive.Expression ? this.createNativeReference(prop) : (prop.type().equals((Object)Primitive.RESOURCE) && prop.values().get(0).toString().startsWith("$") ? StashHelper.buildResourceValue(prop.values(), prop.source().getPath()) : this.getValue(prop)));
        return variable;
    }

    private Variable createVariableFromParameter(PropertyDescription parameter) {
        Variable variable = new Variable();
        variable.name = parameter.name();
        variable.values = parameter.definition() != null && parameter.definition().isReference() || parameter.type().equals((Object)Primitive.REFERENCE) ? this.buildReferenceValues(parameter.values()) : (parameter.values().getFirst() instanceof Primitive.Expression ? this.createNativeReference(parameter) : (parameter.type().equals((Object)Primitive.RESOURCE) && parameter.values().getFirst().toString().startsWith("$") ? StashHelper.buildResourceValue(parameter.values(), parameter.source().getPath()) : this.getValue(parameter)));
        return variable;
    }

    private List<Object> createNativeReference(Property property) {
        String aPackage = NativeFormatter.calculatePackage(property.container());
        return new ArrayList<Object>(Collections.singletonList(this.reactivePrefix(property) + this.workingPackage.toLowerCase() + ".natives." + (String)(aPackage.isEmpty() ? "" : aPackage + ".") + Format.javaValidName().format(Format.firstUpperCase().format((Object)property.name())).toString() + "_" + property.getUID()));
    }

    private List<Object> createNativeReference(PropertyDescription parameter) {
        String aPackage = NativeFormatter.calculatePackage(parameter.container());
        return new ArrayList<Object>(Collections.singletonList(this.reactivePrefix(parameter) + this.workingPackage.toLowerCase() + ".natives." + (String)(aPackage.isEmpty() ? "" : aPackage + ".") + Format.javaValidName().format(Format.firstUpperCase().format((Object)parameter.name())).toString() + "_" + parameter.getUID()));
    }

    private String reactivePrefix(Property prop) {
        return prop.type().equals((Object)Primitive.FUNCTION) || prop.annotations().contains(Annotation.Reactive) ? "" : "$@";
    }

    private String reactivePrefix(PropertyDescription prop) {
        return prop.type().equals((Object)Primitive.FUNCTION) || prop.definition().annotations().contains(Annotation.Reactive) ? "" : "$@";
    }

    private List<Object> getValue(Property prop) {
        Primitive.Reference r;
        Object e = prop.values().getFirst();
        if (e instanceof Primitive.Reference && (r = (Primitive.Reference)e).isEmpty()) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(StashHelper.hasToBeConverted(prop.values(), prop.type()) ? this.convert((Valued)prop) : (prop.rule(FunctionRule.class) != null ? this.formatNativeReferenceOfVariable(prop.values()) : prop.values()));
    }

    private List<Object> formatNativeReferenceOfVariable(List<Object> values) {
        return values.stream().map(value -> "$@" + value.toString()).collect(Collectors.toList());
    }

    private List<Object> getValue(PropertyDescription parameter) {
        Primitive.Reference r;
        Object e = parameter.values().getFirst();
        if (e instanceof Primitive.Reference && (r = (Primitive.Reference)e).isEmpty()) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(StashHelper.hasToBeConverted(parameter.values(), parameter.type()) ? this.convert((Valued)parameter) : parameter.values());
    }

    private List<?> convert(Valued valued) {
        Primitive type = valued.type();
        if (type.equals((Object)Primitive.WORD)) {
            return Primitive.WORD.convert(valued.values().toArray());
        }
        if (type.equals((Object)Primitive.LONG) && this.areIntegers(valued)) {
            return valued.values().stream().map(v -> (long)((Integer)v)).collect(Collectors.toList());
        }
        if (type.equals((Object)Primitive.INSTANT)) {
            return Primitive.INSTANT.convert(valued.values().toArray(new String[0]));
        }
        if (type.equals((Object)Primitive.RESOURCE)) {
            return valued.values().stream().map(o -> this.relative((File)o)).collect(Collectors.toList());
        }
        return type.convert(valued.values().toArray(new String[0]));
    }

    private boolean areIntegers(Valued valued) {
        return valued.values().stream().allMatch(v -> v instanceof Integer);
    }

    private String relative(File file) {
        String resources;
        String path = StashCreator.toSystemIndependentName(file.getAbsolutePath());
        return path.equals(resources = StashCreator.toSystemIndependentName(this.resourceFolder.getAbsolutePath())) ? path : path.substring(resources.length() + 1);
    }

    private List<Object> buildReferenceValues(List<Object> values) {
        Primitive.Reference r;
        Object object = values.getFirst();
        if (object instanceof Primitive.Reference && (r = (Primitive.Reference)object).isEmpty()) {
            return new ArrayList<Object>();
        }
        return values.stream().map(this::buildReferenceName).collect(Collectors.toList());
    }

    private String buildReferenceName(Object o) {
        Primitive.Reference r;
        if (o instanceof Primitive.Reference && !(r = (Primitive.Reference)o).isToInstance()) {
            return this.mogramStashQualifiedName((Mogram)r.get().get());
        }
        if (o instanceof Mogram) {
            return this.mogramStashQualifiedName((Mogram)o);
        }
        return StashHelper.buildInstanceReference(o);
    }

    private String mogramStashQualifiedName(Mogram mogram) {
        return (String)(mogram.level() == Level.M1 ? this.getStash(mogram) + "#" : "") + NameFormatter.layerQn(mogram);
    }

    private String getStash(Mogram mogram) {
        return this.test || mogram.level() == Level.M1 ? this.getStashByNode(mogram) : this.outDSL;
    }

    private String getStashByNode(Mogram mogram) {
        String file = new File(mogram.source()).getName();
        return file.substring(0, file.lastIndexOf("."));
    }
}

