/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Adapter;
import io.intino.itrules.Engine;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.ExpressionsTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeParameterAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativePropertyAdapter;
import io.intino.tara.Language;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class NativesCreator {
    private static final Logger LOG = Logger.getLogger(NativesCreator.class.getName());
    private static final String NATIVES = "natives";
    private static final String nativeExtension = ".java";
    private final String nativesPackage;
    private final Model model;
    private final Language language;
    private final CompilerConfiguration conf;
    private final File genDirectory;
    private final String outDSL;

    public NativesCreator(Model model, Language language, CompilerConfiguration conf) {
        this.model = model;
        this.language = language;
        this.conf = conf;
        this.genDirectory = conf.genDirectory();
        this.outDSL = conf.dsl().outDsl() != null ? conf.dsl().outDsl().toLowerCase() : conf.module();
        this.nativesPackage = conf.generationPackage().toLowerCase().replace(".", File.separator) + File.separator + NATIVES + File.separator;
    }

    public Map<String, String> create() {
        ArrayList<PropertyDescription> parameters = new ArrayList<PropertyDescription>();
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Mogram mogram : this.model.mograms()) {
            this.extractNativeParameters(mogram, parameters);
            this.extractNativeProperties(mogram, properties);
        }
        return this.createNativeClasses(parameters, properties);
    }

    private Map<String, String> createNativeClasses(List<PropertyDescription> parameters, List<Property> props) {
        HashMap<String, String> destination2Origin = new HashMap<String, String>();
        HashMap<File, String> nativeCodes = new HashMap<File, String>();
        if (parameters.isEmpty() && props.isEmpty()) {
            return destination2Origin;
        }
        if (!parameters.isEmpty()) {
            nativeCodes.putAll(this.createNativeParameterClasses(parameters, destination2Origin));
        }
        if (!props.isEmpty()) {
            nativeCodes.putAll(this.createNativePropertyClasses(props, destination2Origin));
        }
        for (Map.Entry nativeCode : nativeCodes.entrySet()) {
            this.writeJavaCode((File)nativeCode.getKey(), (String)nativeCode.getValue());
        }
        return destination2Origin;
    }

    private Map<File, String> createNativeParameterClasses(List<PropertyDescription> parameters, Map<String, String> originToDestiny) {
        Engine expressionsTemplate = this.expressionsTemplate();
        LinkedHashMap<File, String> nativeCodes = new LinkedHashMap<File, String>();
        parameters.forEach(p -> {
            FrameBuilder builder = new FrameBuilder();
            builder.put(PropertyDescription.class, (Adapter)new NativeParameterAdapter(this.language, this.outDSL, p.container().level(), this.conf.generationPackage(), this.conf.dsl().generationPackage(), NativeFormatter.calculatePackage(p.container()), this.conf.intinoProjectDirectory()));
            this.createNativeFrame(originToDestiny, expressionsTemplate, nativeCodes, this.calculateDestination((PropertyDescription)p), builder.append(p), p.type(), p.source().getPath());
        });
        return nativeCodes;
    }

    private Map<File, String> createNativePropertyClasses(List<Property> natives, Map<String, String> files) {
        Engine expressionsTemplate = this.expressionsTemplate();
        LinkedHashMap<File, String> nativeCodes = new LinkedHashMap<File, String>();
        natives.forEach(prop -> {
            FrameBuilder builder = new FrameBuilder();
            builder.put(Property.class, (Adapter)new NativePropertyAdapter(this.language, this.outDSL, this.conf.generationPackage(), this.conf.dsl().generationPackage(), NativeFormatter.calculatePackage(prop.container()), this.conf.intinoProjectDirectory()));
            this.createNativeFrame(files, expressionsTemplate, nativeCodes, this.calculateDestination((Property)prop), builder.append(prop), prop.type(), prop.source().getPath());
        });
        return nativeCodes;
    }

    private void createNativeFrame(Map<String, String> destination2Origin, Engine engine, Map<File, String> nativeCodes, File destination, FrameBuilder builder, Primitive type, String file2) {
        FrameBuilder frameBuilder = builder.add("java");
        if (Primitive.FUNCTION.equals((Object)type)) {
            frameBuilder.add(type.name());
        }
        nativeCodes.put(destination, engine.render((Object)frameBuilder.toFrame()));
        if (!destination2Origin.containsKey(file2)) {
            destination2Origin.put(destination.getAbsolutePath(), file2);
        }
    }

    private Engine expressionsTemplate() {
        return Generator.customize(new ExpressionsTemplate());
    }

    private File calculateDestination(PropertyDescription parameter) {
        return new File(this.genDirectory, this.nativesPackage + NativeFormatter.calculatePackage(parameter.container()).replace(".", File.separator) + File.separator + this.nativeName(parameter));
    }

    private File calculateDestination(Property prop) {
        return new File(this.genDirectory, this.nativesPackage + NativeFormatter.calculatePackage(prop.container()).replace(".", File.separator) + File.separator + this.nativeName(prop));
    }

    private String nativeName(Property property) {
        return Format.javaValidName().format(Format.firstUpperCase().format((Object)property.name())).toString() + "_" + property.getUID() + nativeExtension;
    }

    private String nativeName(PropertyDescription parameter) {
        return Format.javaValidName().format(Format.firstUpperCase().format((Object)parameter.name())).toString() + "_" + parameter.getUID() + nativeExtension;
    }

    private void writeJavaCode(File file, String nativeText) {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            Files.write(file.toPath(), nativeText.getBytes(this.conf.sourceEncoding()), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
    }

    private void extractNativeParameters(Mogram mogram, List<PropertyDescription> natives) {
        natives.addAll(mogram.parameters().stream().filter(p -> Primitive.FUNCTION.equals((Object)p.type()) || this.isExpression((PropertyDescription)p)).toList());
        for (Mogram inner : mogram.mograms()) {
            this.extractNativeParameters(inner, natives);
        }
    }

    private void extractNativeProperties(Mogram mogram, List<Property> natives) {
        natives.addAll(mogram.properties().stream().filter(v -> (Primitive.FUNCTION.equals((Object)v.type()) || this.isExpression((Property)v)) && !v.values().isEmpty()).toList());
        for (Mogram inner : mogram.mograms()) {
            this.extractNativeProperties(inner, natives);
        }
    }

    private boolean isExpression(Property valued) {
        return !valued.values().isEmpty() && valued.values().get(0) instanceof Primitive.Expression || valued.annotations().contains(Annotation.Reactive);
    }

    private boolean isExpression(PropertyDescription parameter) {
        return !parameter.values().isEmpty() && parameter.values().get(0) instanceof Primitive.Expression || parameter.definition().annotations().contains(Annotation.Reactive);
    }
}

