/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeExtractor;
import io.intino.tara.Language;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.model.rules.property.NativeObjectRule;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.ReferenceProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeFormatter
implements TemplateTags {
    private final String outDsl;
    private final Language language;
    private final String aPackage;
    private final String workingPackage;
    private final boolean m1;
    private final Map<String, Set<String>> imports;
    private final Map<String, String> workingPackages;
    private String languageWorkingPackage;

    public NativeFormatter(Language language, String outDsl, String subPackage, String workingPackage, String languageWorkingPackage, boolean m1, File importsFile) {
        this.outDsl = outDsl;
        this.language = language;
        this.aPackage = subPackage;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
        this.m1 = m1;
        this.workingPackages = Map.of(language.languageName(), languageWorkingPackage == null ? "" : languageWorkingPackage, outDsl, workingPackage);
        this.imports = this.load(importsFile);
    }

    private static String getQn(Mogram owner, String language, boolean m0) {
        return !m0 ? NameFormatter.getQn(owner, language) : language.toLowerCase() + "." + (String)owner.types().get(0);
    }

    private static String getQn(Facet facet, String language, boolean m0) {
        return NativeFormatter.asFacet(facet, language);
    }

    private static String asFacet(Facet facet, String language) {
        return null;
    }

    private static String getQn(Mogram owner, Mogram node, String workingPackage, boolean m0) {
        return !m0 ? NameFormatter.getQn(owner, workingPackage) : workingPackage.toLowerCase() + "." + (String)owner.types().get(0);
    }

    public static String getSignature(PropertyDescription parameter) {
        return ((FunctionRule)parameter.definition().rule(FunctionRule.class)).signature();
    }

    public static String getInterface(PropertyDescription parameter) {
        FunctionRule rule = (FunctionRule)parameter.definition().rule(FunctionRule.class);
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String getInterface(Property property) {
        FunctionRule rule = (FunctionRule)property.rule(FunctionRule.class);
        if (rule == null || rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String formatBody(String body, String signature) {
        String formattedBody;
        String returnText = "return ";
        String string = formattedBody = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!(signature.contains(" void ") || formattedBody.contains("\n") || formattedBody.startsWith("return "))) {
            return "return " + formattedBody;
        }
        return formattedBody;
    }

    public static String getReturn(String body) {
        String returnText = "return ";
        String string = body = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!body.contains("\n") && !body.startsWith("return ")) {
            return "return ";
        }
        return "";
    }

    public static String getSignature(Property property) {
        return ((FunctionRule)property.rule(FunctionRule.class)).signature();
    }

    public static String buildContainerPath(String languageWorkingPackage, Mogram node, String workingPackage) {
        if (node instanceof Mogram) {
            Mogram scope;
            Mogram mogram = scope = node.level() == Level.M1 ? NativeFormatter.firstNoFeature((ElementContainer)node) : NativeFormatter.firstNoFeatureAndNamed((ElementContainer)node);
            if (scope == null) {
                return "";
            }
            if (scope.level() == Level.M1) {
                return NativeFormatter.getTypeAsScope(scope, languageWorkingPackage);
            }
            return NativeFormatter.getQn(scope, node, workingPackage, false);
        }
        if (node instanceof Facet) {
            Mogram scope = NativeFormatter.firstNoFeatureAndNamed((ElementContainer)node);
            if (scope == null) {
                return "";
            }
            return scope.level() == Level.M1 ? NativeFormatter.getTypeAsScope(scope, languageWorkingPackage) : NativeFormatter.getQn(scope, workingPackage, false);
        }
        return "";
    }

    public static String buildExpressionContainerPath(String typeWorkingPackage, Mogram owner, String outDSL, String workingPackage) {
        String trueWorkingPackage = NativeFormatter.extractWorkingPackage(typeWorkingPackage, workingPackage);
        if (owner instanceof Mogram) {
            Mogram scope;
            Mogram mogram = scope = owner.level() == Level.M1 ? NativeFormatter.firstNoFeature((ElementContainer)owner) : NativeFormatter.firstNoFeatureAndNamed((ElementContainer)owner);
            if (scope == null) {
                return "";
            }
            if (scope.level() == Level.M1) {
                return NativeFormatter.getTypeAsScope(scope, trueWorkingPackage);
            }
            return NativeFormatter.getQn(scope, owner, workingPackage, false);
        }
        if (owner instanceof Facet) {
            return ((Mogram)owner.container()).level() == Level.M1 ? NativeFormatter.getTypeAsScope(owner, trueWorkingPackage) : NativeFormatter.getQn((Facet)owner, workingPackage, false);
        }
        return "";
    }

    private static String extractWorkingPackage(String scope, String language) {
        return scope != null && !scope.isEmpty() ? scope : language;
    }

    private static String getTypeAsScope(Mogram scope, String languageWorkingPackage) {
        return languageWorkingPackage + "." + (scope instanceof Mogram ? NameFormatter.cleanQn((String)scope.types().get(0)) : NameFormatter.cleanQn(NativeFormatter.facetType((Facet)scope)));
    }

    private static List<Facet> containerFacets(Mogram scope) {
        ElementContainer container;
        for (container = scope.container(); container != null && ((Mogram)container).appliedFacets().isEmpty(); container = container.container()) {
        }
        return container != null ? ((Mogram)container).appliedFacets() : Collections.emptyList();
    }

    private static String facetType(Facet facet) {
        return facet.type().toLowerCase() + "." + facet.type() + Resolver.shortType((String)((String)((Mogram)facet.target().get()).types().get(0)));
    }

    private static Mogram firstNoFeature(ElementContainer owner) {
        for (ElementContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Mogram) || container instanceof MogramRoot || ((Mogram)container).is(Annotation.Feature)) continue;
            return (Mogram)container;
        }
        return owner instanceof Mogram ? (Mogram)owner : (Mogram)owner.container();
    }

    private static Mogram firstNoFeatureAndNamed(ElementContainer owner) {
        for (ElementContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Mogram) || container instanceof MogramRoot || ((Mogram)container).isAnonymous() || ((Mogram)container).is(Annotation.Feature)) continue;
            return (Mogram)container;
        }
        return owner instanceof Mogram ? (Mogram)owner : (Mogram)owner.container();
    }

    private static ElementContainer searchFeatureReference(Mogram owner) {
        MogramRoot model = NativeFormatter.model((ElementContainer)owner);
        if (model == null) {
            return owner;
        }
        ElementContainer nodeContainer = NativeFormatter.searchFeatureReference((ElementContainer)model, owner);
        return nodeContainer != null ? nodeContainer : owner;
    }

    private static ElementContainer searchFeatureReference(ElementContainer container, Mogram target) {
        for (Mogram component : container.components()) {
            ElementContainer nodeContainer = NativeFormatter.searchFeatureReference((ElementContainer)component, target);
            if (nodeContainer == null) continue;
            return nodeContainer;
        }
        return null;
    }

    private static MogramRoot model(ElementContainer owner) {
        for (ElementContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Mogram) || !(container instanceof MogramRoot)) continue;
            return (MogramRoot)container;
        }
        return null;
    }

    public static String calculatePackage(Mogram container) {
        Mogram node = NativeFormatter.firstNamedContainer(container);
        return node == null ? "" : NameFormatter.layerQn(node).replace("$", ".").replace("#", ".").toLowerCase();
    }

    private static Mogram firstNamedContainer(Mogram container) {
        List<Mogram> containers = NativeFormatter.collectStructure(container);
        Mogram candidate = null;
        for (Mogram nodeContainer : containers) {
            if (nodeContainer instanceof Mogram && !nodeContainer.isAnonymous()) {
                candidate = nodeContainer;
                continue;
            }
            if (nodeContainer instanceof Mogram) break;
            candidate = nodeContainer;
        }
        return candidate;
    }

    private static List<Mogram> collectStructure(Mogram container) {
        ArrayList<Mogram> containers = new ArrayList<Mogram>();
        for (Mogram current = container; current != null && !(current instanceof MogramRoot); current = current.container()) {
            containers.add(0, current);
        }
        return containers;
    }

    private static Constraint.Property findParameter(List<Constraint.Property> props, String name) {
        return props.stream().filter(prop -> prop.name().equals(name)).findFirst().orElse(null);
    }

    private Map<String, Set<String>> load(File importsFile) {
        if (importsFile == null) {
            return new HashMap<String, Set<String>>();
        }
        try {
            return (Map)new Gson().fromJson((Reader)new FileReader(importsFile), new TypeToken<Map<String, Set<String>>>(this){}.getType());
        }
        catch (FileNotFoundException e) {
            return new HashMap<String, Set<String>>();
        }
    }

    public void fillFrameForFunctionProperty(Property prop, Object body, FrameBuilderContext context) {
        String signature = NativeFormatter.getSignature(prop);
        context.add("package", (Object)this.aPackage);
        HashSet<String> imports = new HashSet<String>(((FunctionRule)prop.rule(FunctionRule.class)).imports());
        imports.addAll(this.collectImports((Valued)prop));
        if (!imports.isEmpty()) {
            context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        }
        if (!context.contains("scope")) {
            context.add("scope", (Object)this.workingPackage);
        }
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("rule")) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(prop)));
        }
        if (!context.contains("name")) {
            context.add("name", (Object)prop.name());
        }
        if (!context.contains("qn")) {
            context.add("qn", (Object)prop.container().qualifiedName());
        }
        context.add("file", (Object)prop.source().getPath());
        context.add("line", (Object)prop.line());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), signature));
        }
        context.add("nativeContainer", (Object)NameFormatter.cleanQn(NativeFormatter.buildContainerPath(this.workingPackages.getOrDefault(this.language.languageName(), this.workingPackage), prop.container(), this.workingPackage)));
        context.add("signature", (Object)signature);
        context.add("uid", (Object)prop.getUID());
        NativeExtractor extractor = new NativeExtractor(signature);
        context.add("methodName", (Object)extractor.methodName());
        context.add("parameters", (Object)extractor.parameters());
        context.add("returnType", (Object)extractor.returnType());
        context.add("exception", (Object)extractor.exceptions());
    }

    public void fillFrameForFunctionParameter(PropertyDescription parameter, Object body, FrameBuilderContext context) {
        String signature = NativeFormatter.getSignature(parameter);
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl);
        }
        if (!context.contains("name")) {
            context.add("name", (Object)parameter.name());
        }
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("qn")) {
            context.add("qn", (Object)NameFormatter.cleanQn(parameter.container().qualifiedName()));
        }
        if (!context.contains("scope")) {
            context.add("scope", (Object)this.workingPackageScope((Valued)parameter, this.workingPackage));
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("rule".toLowerCase())) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(parameter)));
        }
        HashSet<String> imports = new HashSet<String>(((FunctionRule)parameter.definition().rule(FunctionRule.class)).imports());
        imports.addAll(this.collectImports((Valued)parameter));
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        context.add("signature", (Object)signature);
        context.add("file", (Object)parameter.source().getPath());
        context.add("line", (Object)parameter.line());
        context.add("nativeContainer", (Object)NameFormatter.cleanQn(NativeFormatter.buildContainerPath(parameter.scope(), parameter.container(), this.workingPackage)));
        context.add("uid", (Object)parameter.getUID());
        NativeExtractor extractor = new NativeExtractor(signature);
        context.add("methodName", (Object)extractor.methodName());
        context.add("parameters", (Object)extractor.parameters());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), signature));
        }
        context.add("returnType", (Object)extractor.returnType());
        context.add("exception", (Object)extractor.exceptions());
    }

    private String workingPackageScope(Valued valued, String workingPackage) {
        return this.workingPackages.getOrDefault(this.language.languageName(), this.workingPackage);
    }

    public void fillFrameFunctionProperty(FrameBuilderContext context, Property prop, Object body) {
        context.add("native");
        context.add("file", (Object)prop.source().getPath());
        context.add("line", (Object)prop.line());
        HashSet<String> imports = new HashSet<String>(prop.rule(FunctionRule.class) != null ? ((FunctionRule)prop.rule(FunctionRule.class)).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)prop));
        if (!context.contains("rule".toLowerCase())) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(prop)));
        }
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("name")) {
            context.add("name", (Object)prop.name());
        }
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl);
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        context.add("nativeContainer".toLowerCase(), (Object)this.buildContainerPathOfExpression((Valued)prop));
        if (!context.contains("type")) {
            context.add("type", (Object)this.typeFrame(this.type(prop), prop.isMultiple()));
        }
        context.add("uid", (Object)prop.getUID());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), prop.type().getName()));
        }
    }

    public void fillFrameFunctionParameter(FrameBuilderContext context, PropertyDescription parameter, String body) {
        context.add("native");
        context.add("file", (Object)parameter.source().getPath());
        context.add("line", (Object)parameter.line());
        HashSet<String> imports = new HashSet<String>(parameter.rule(FunctionRule.class) != null ? ((FunctionRule)parameter.rule(FunctionRule.class)).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)parameter));
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        context.add("nativeContainer", (Object)this.buildContainerPathOfExpression((Valued)parameter));
        context.add("uid", (Object)parameter.getUID());
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("name".toLowerCase())) {
            context.add("name", (Object)parameter.name());
        }
        if (!context.contains("generatedLanguage".toLowerCase())) {
            context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        if (!context.contains("workingPackage".toLowerCase())) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("type".toLowerCase())) {
            context.add("type", (Object)this.typeFrame(this.type(parameter), this.isMultiple(parameter)));
        }
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body, parameter.type().getName()));
        }
    }

    public String type(Property prop) {
        boolean multiple = prop.isMultiple();
        if (prop.isReference()) {
            return NameFormatter.getQn((Mogram)((ReferenceProperty)prop).target().get(), this.workingPackage);
        }
        if (Primitive.OBJECT.equals((Object)prop.type())) {
            return ((NativeObjectRule)prop.rule(NativeObjectRule.class)).type();
        }
        if (Primitive.WORD.equals((Object)prop.type())) {
            return NameFormatter.getQn(prop.container(), this.workingPackage) + "." + String.valueOf(Format.firstUpperCase().format((Object)prop.name()));
        }
        return prop.type().javaName();
    }

    private boolean isMultiple(PropertyDescription parameter) {
        Constraint.Property constraint = this.propertyConstraintOf(parameter);
        if (constraint == null) {
            return false;
        }
        Size rule = constraint.rules().stream().filter(r -> r instanceof Size).findFirst().orElse(null);
        return rule != null && !rule.isSingle();
    }

    public String type(PropertyDescription parameter) {
        boolean multiple = parameter.isMultiple();
        return parameter.type().equals((Object)Primitive.OBJECT) ? ((NativeObjectRule)parameter.rule(NativeObjectRule.class)).type() : parameter.type().javaName();
    }

    private Frame typeFrame(String type, boolean multiple) {
        return (multiple ? new FrameBuilder(new String[]{"list"}).add("value", (Object)type) : new FrameBuilder().add("value", (Object)type)).toFrame();
    }

    private List<String> collectImports(Valued parameter) {
        String qn = (parameter.container().qualifiedName() + "." + parameter.name()).replace(":", "");
        return this.imports.containsKey(qn) ? new ArrayList(this.imports.get(qn)) : Collections.emptyList();
    }

    public String buildContainerPathOfExpression(Valued valued) {
        return NameFormatter.cleanQn(NativeFormatter.buildExpressionContainerPath(this.workingPackage, valued.container(), this.outDsl, this.workingPackage));
    }

    public Constraint.Property propertyConstraintOf(PropertyDescription parameter) {
        List<Constraint.Property> properties = this.parameterConstraintsOf(parameter.container());
        if (properties.isEmpty() || properties.size() <= parameter.position()) {
            return null;
        }
        return NativeFormatter.findParameter(properties, parameter.name());
    }

    private List<Constraint.Property> parameterConstraintsOf(Mogram mogram) {
        if (this.language == null) {
            return Collections.emptyList();
        }
        List nodeConstraints = this.language.constraints((String)mogram.types().get(0));
        if (nodeConstraints == null) {
            return Collections.emptyList();
        }
        ArrayList constraints = new ArrayList(nodeConstraints);
        ArrayList<Constraint.Property> parameters = new ArrayList<Constraint.Property>();
        for (Constraint constraint : constraints) {
            if (constraint instanceof Constraint.Property) {
                parameters.add((Constraint.Property)constraint);
                continue;
            }
            if (!(constraint instanceof Constraint.Facet)) continue;
            parameters.addAll(((Constraint.Facet)constraint).constraints().stream().filter(c -> c instanceof Constraint.Property).map(c -> (Constraint.Property)c).collect(Collectors.toList()));
        }
        return parameters;
    }
}

