/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.Language;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.rules.Size;
import io.intino.tara.processors.model.MogramImpl;
import io.intino.tara.processors.model.ReferenceProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class TypesProvider
implements TemplateTags {
    private TypesProvider() {
    }

    static List<String> getTypes(Mogram mogram, Language language) {
        Size size;
        List<String> types = mogram.annotations().stream().map(Enum::name).collect(Collectors.toList());
        types.add("Node");
        if (mogram instanceof MogramImpl) {
            types.add("NodeImpl");
        }
        if ((size = mogram.container().sizeOf((Element)mogram)) != null && size.isSingle()) {
            types.add("single");
        }
        if (TypesProvider.isOverriding(mogram)) {
            types.add("overriden");
        }
        types.addAll(TypesProvider.nodeAnnotations(mogram, language));
        return types;
    }

    private static boolean isOverriding(Mogram mogram) {
        Mogram c;
        ElementContainer elementContainer;
        return mogram.parent() != null && (elementContainer = mogram.container()) instanceof Mogram && ((c = (Mogram)elementContainer).parent() != null && ((Mogram)mogram.parent().get()).container().equals(c.parent().get()) || c.parent() != null && TypesProvider.containerContainsParent(mogram));
    }

    private static boolean containerContainsParent(Mogram mogram) {
        ElementContainer elementContainer = mogram.container();
        if (!(elementContainer instanceof Mogram)) {
            return false;
        }
        Mogram m = (Mogram)elementContainer;
        boolean contains = ((Mogram)m.parent().get()).contains((Mogram)mogram.parent().get());
        return contains || TypesProvider.hasReference((Mogram)m.parent().get(), (Mogram)mogram.parent().get());
    }

    private static boolean hasReference(Mogram node, Mogram component) {
        for (Mogram candidate : node.components()) {
            MogramReference r;
            if (!(candidate instanceof MogramReference) || !(r = (MogramReference)candidate).target().equals(component)) continue;
            return true;
        }
        return false;
    }

    static String[] getTypes(Facet facet) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aspect");
        list.add(facet.type());
        return list.toArray(new String[0]);
    }

    private static List<String> nodeAnnotations(Mogram node, Language language) {
        ArrayList<String> annotations = new ArrayList<String>();
        List assumptions = language.assumptions((String)node.types().get(0));
        if (assumptions == null) {
            return annotations;
        }
        for (Assumption assumption : assumptions) {
            String name = assumption.getClass().getInterfaces()[0].getSimpleName();
            if (!name.endsWith("Instance")) continue;
            annotations.add(name);
        }
        return annotations;
    }

    public static Set<String> getTypes(Property prop) {
        HashSet<String> types = new HashSet<String>();
        if (prop.values().isEmpty()) {
            types.add("required");
        }
        if (!prop.values().isEmpty() && (prop.values().get(0) instanceof EmptyMogram || prop.values().get(0) == null)) {
            types.add("empty");
        }
        types.add(prop.getClass().getSimpleName());
        types.add("variable");
        if (prop instanceof ReferenceProperty) {
            types.add("reference");
        }
        if (prop.type().equals((Object)Primitive.OBJECT)) {
            types.add("objectVariable");
        }
        types.add(prop.type().getName());
        if (Primitive.isJavaPrimitive((String)prop.type().getName())) {
            types.add("primitive");
        }
        if (prop.isMultiple()) {
            types.add("multiple");
        }
        types.addAll(prop.annotations().stream().map(tag -> tag.name().toLowerCase()).toList());
        return types;
    }

    public static String[] getTypes(Constraint.Property parameter, boolean isRequired) {
        HashSet<String> types = new HashSet<String>();
        types.add(parameter.getClass().getSimpleName());
        types.add("variable");
        if (parameter.type().equals((Object)Primitive.REFERENCE) && !parameter.type().equals((Object)Primitive.WORD)) {
            types.add("reference");
        }
        types.add(parameter.type().getName());
        if (parameter.rules().stream().filter(r -> r instanceof Size).map(s -> (Size)s).findFirst().get().max() > 1) {
            types.add("multiple");
        }
        types.addAll(parameter.annotations().stream().map(Enum::name).toList());
        return types.toArray(new String[0]);
    }

    public static String[] getTypes(PropertyDescription parameter) {
        HashSet<String> types = new HashSet<String>();
        types.add(parameter.getClass().getSimpleName());
        types.add("variable");
        types.add("parameter");
        types.add(parameter.type().getName());
        if (parameter.values().size() > 1) {
            types.add("multiple");
        }
        types.addAll(parameter.definition().annotations().stream().map(Enum::name).toList());
        return types.toArray(new String[0]);
    }
}

