/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.tara.Language;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.CustomRule;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.model.rules.property.NativeCustomWordRule;
import io.intino.tara.model.rules.property.NativeWordRule;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import io.intino.tara.model.rules.property.WordRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class PropertyAdapter
extends Generator
implements Adapter<Property>,
TemplateTags {
    PropertyAdapter(Language language, String generatedLanguage, String workingPackage, String languageWorkingPackage) {
        super(language, generatedLanguage, workingPackage, languageWorkingPackage);
    }

    public void adapt(Property property, FrameBuilderContext context) {
        FrameBuilder ruleBuilder;
        Rule<?> rule;
        TypesProvider.getTypes(property).forEach(arg_0 -> ((FrameBuilderContext)context).add(arg_0));
        context.add("name", (Object)property.name());
        context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        context.add("language", (Object)this.language.languageName().toLowerCase());
        Mogram container = property.container();
        context.add("containerName", (Object)container.name());
        context.add("qn", (Object)NameFormatter.cleanQn(this.buildQN(container)));
        if (property.values().stream().anyMatch(Objects::nonNull) && !(property.values().get(0) instanceof EmptyMogram)) {
            this.addValues(property, context);
        }
        if ((rule = PropertyAdapter.rule(property)) != null && (ruleBuilder = this.ruleToFrame(rule)) != null) {
            context.add("rule", (Object)ruleBuilder.toFrame());
        }
        context.add("type", (Object)this.getType(property));
        if (Primitive.WORD.equals((Object)property.type())) {
            this.fillWordVariable(property, context);
        } else if (property.type().equals((Object)Primitive.FUNCTION) || property.annotations().contains(Annotation.Reactive)) {
            this.fillNativeProperty(context, property);
        }
    }

    private static Rule<?> rule(Property property) {
        return property.rules().stream().filter(r -> r instanceof WordRule || r instanceof CustomRule || r instanceof FunctionRule).findFirst().orElse(null);
    }

    private void fillWordVariable(Property property, FrameBuilderContext context) {
        if (property.rule(PropertyCustomRule.class) != null || property.rule(NativeCustomWordRule.class) != null || property.rule(WordRule.class) != null && ((WordRule)property.rule(WordRule.class)).isCustom()) {
            context.add("outDefined");
        } else {
            List allowedWords = property.rule(FunctionRule.class) != null ? ((NativeWordRule)property.rule(NativeWordRule.class)).words() : ((WordRule)property.rule(WordRule.class)).words();
            context.add("words", (Object)allowedWords.toArray(new Object[0]));
        }
    }

    private String buildQN(Mogram mogram) {
        return NameFormatter.getQn(mogram, this.workingPackage.toLowerCase());
    }

    private void addValues(Property property, FrameBuilderContext context) {
        if (Primitive.WORD.equals((Object)property.type())) {
            context.add("wordValues", (Object)this.getWordValues(property));
        } else if (Primitive.STRING.equals((Object)property.type())) {
            context.add("values", (Object)this.asString(property.values()));
        } else {
            context.add("values", (Object)property.values().toArray());
        }
    }

    private String[] getWordValues(Property property) {
        return (String[])property.values().stream().map(Object::toString).toArray(String[]::new);
    }

    private String[] asString(List<Object> objects) {
        return (String[])objects.stream().map(object -> "\"" + object.toString() + "\"").toArray(String[]::new);
    }

    private void fillNativeProperty(FrameBuilderContext context, Property property) {
        Object next = property.values().isEmpty() || !(property.values().get(0) instanceof Primitive.Expression) ? null : property.values().get(0);
        NativeFormatter adapter = new NativeFormatter(this.language, this.outDsl, NativeFormatter.calculatePackage(property.container()), this.workingPackage, this.languageWorkingPackage, false, null);
        if (Primitive.FUNCTION.equals((Object)property.type())) {
            adapter.fillFrameForFunctionProperty(property, next, context);
            this.imports.addAll(new ArrayList(((FunctionRule)property.rule(FunctionRule.class)).imports()));
        } else {
            adapter.fillFrameFunctionProperty(context, property, next);
        }
    }
}

