/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.Language;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.Size;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.Model;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MogramAdapter
extends Generator
implements Adapter<Mogram>,
TemplateTags {
    private Mogram initNode;
    private FrameBuilderContext context;

    MogramAdapter(String outDsl, Language language, Mogram initNode, String workingPackage, String languageWorkingPackage) {
        super(language, outDsl, workingPackage, languageWorkingPackage);
        this.initNode = initNode;
    }

    public void adapt(Mogram mogram, FrameBuilderContext context) {
        this.context = context;
        TypesProvider.getTypes(mogram, this.language).forEach(arg_0 -> ((FrameBuilderContext)context).add(arg_0));
        context.add("modelType", (Object)(mogram.level() == Level.M3 ? "Platform" : "Product"));
        this.addNodeInfo(mogram, context);
        this.addProperties(mogram, context);
        this.addComponents(mogram, context);
        this.addReferences(mogram, context);
        this.addNonAbstractCreates(mogram, context);
        this.addFacetClasses(mogram, context);
        this.addAvailableFacets(mogram, context);
        if (mogram.facetPrescription() != null) {
            this.addFacetConstrains(mogram, context);
            if (!(mogram.container() instanceof Model)) {
                this.addTargetComponents(mogram, context);
                this.addFacet(mogram, (Mogram)mogram.facetPrescription().get(), context);
            }
        }
        this.addParent(mogram, context);
    }

    private void addFacetClasses(Mogram node, FrameBuilderContext context) {
        this.facetMograms(node).forEach(m -> this.addFacetSlot(context, (Mogram)m));
    }

    private Stream<Mogram> facetMograms(Mogram mogram) {
        return mogram.mograms().stream().filter(n -> n.facetPrescription() != null);
    }

    private void addFacetSlot(FrameBuilderContext context, Mogram aspectNode) {
        context.add("node", (Object)FrameBuilder.from((FrameBuilderContext)context).append((Object)aspectNode).add("aspect").toFrame());
    }

    private void addReferences(Mogram mogram, FrameBuilderContext context) {
        mogram.referenceComponents().forEach(r -> context.add("node", (Object)this.frameOf((HasMogram)r).add("owner").toFrame()));
    }

    private FrameBuilder frameOf(HasMogram ref) {
        FrameBuilder builder = new FrameBuilder();
        Mogram target = (Mogram)ref.target().get();
        this.addNodeInfo(target, (FrameBuilderContext)builder);
        this.getTypes(ref).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        this.addProperties(target, (FrameBuilderContext)builder);
        return builder;
    }

    private List<String> getTypes(HasMogram ref) {
        Mogram target = (Mogram)ref.target().get();
        List<String> types = target.annotations().stream().map(Enum::name).collect(Collectors.toList());
        types.add("Node");
        Size size = ref.container().sizeOf((Element)ref);
        if (size != null && size.isSingle()) {
            types.add("single");
        }
        return types;
    }

    private void addFacet(Mogram facet, Mogram target, FrameBuilderContext context) {
        String qn = NameFormatter.cleanQn(NameFormatter.getQn(target, this.workingPackage));
        FrameBuilder builder = new FrameBuilder().add("aspect").add("name", (Object)target.name()).add("qn", (Object)qn).add("generatedLanguage", (Object)this.outDsl);
        if (facet.isSub() && facet.parent() != null) {
            builder.add("overriden");
        }
        context.add("aspect", (Object)builder.toFrame());
        context.add("core", (Object)new FrameBuilder().add("core").add("qn", (Object)qn).add("name", (Object)target.name()).toFrame());
    }

    private void addTargetComponents(Mogram facet, FrameBuilderContext context) {
        Mogram target = (Mogram)facet.facetPrescription().get();
        this.effectiveComponents(target).filter(c -> !this.isOverriden((Mogram)c, facet)).forEach(c -> MogramAdapter.addCoreMogram(facet, context, c));
        this.effectiveReferenceComponents(target).filter(c -> !this.isOverriden((Mogram)c.target().get(), facet)).forEach(c -> this.addCoreMogramReference(facet, context, (HasMogram)c));
    }

    private void addCoreMogramReference(Mogram facet, FrameBuilderContext context, HasMogram c) {
        FrameBuilder builder = this.frameOf(c).add("target");
        builder.add("targetContainer", (Object)facet.container().name());
        if (c.container().sizeOf((Element)c).isSingle()) {
            builder.add("single");
        }
        context.add("node", (Object)builder.toFrame());
    }

    private static void addCoreMogram(Mogram facet, FrameBuilderContext context, Mogram c) {
        FrameBuilder builder = FrameBuilder.from((FrameBuilderContext)context).append((Object)c).add("target");
        builder.add("targetContainer", (Object)((Mogram)facet.facetPrescription().get()).name());
        if (c.container().sizeOf((Element)c).isSingle()) {
            builder.add("single");
        }
        context.add("node", (Object)builder.toFrame());
    }

    private void addNodeInfo(Mogram node, FrameBuilderContext context) {
        boolean decorable;
        context.add("generatedLanguage", (Object)this.outDsl).add("workingPackage", (Object)this.workingPackage);
        if (this.initNode != null && !node.equals((Object)this.initNode)) {
            context.add("inner", (Object)true);
        }
        if (node.doc() != null) {
            context.add("doc", (Object)node.doc());
        }
        if (node.container() != null) {
            context.add("containerName", (Object)node.container().name());
        }
        this.addType(context, node);
        this.addName(context, node);
        boolean bl = decorable = node.is(Annotation.Decorable) || MogramAdapter.isInDecorable(node);
        if (node.is(Annotation.Generalization) || decorable) {
            context.add("abstract", (Object)true);
        }
        if (decorable) {
            context.add("decorable", (Object)true);
        }
        node.annotations().stream().filter(this.isLayerInterface()).forEach(tag -> context.add("flag", tag));
        if (node.parent() != null) {
            context.add("child");
        }
        if (node.components().stream().anyMatch(c -> c.level().equals((Object)Level.M1))) {
            context.add("metaType", (Object)(this.languageWorkingPackage + "." + this.metaType(node)));
        }
    }

    private void addNonAbstractCreates(Mogram node, FrameBuilderContext context) {
        if (node instanceof MogramReference) {
            return;
        }
        List components = node.components();
        components.stream().filter(c -> !c.isAnonymous()).flatMap(c -> this.collectChildren((Mogram)c).stream()).filter(m -> !m.isAnonymous() && !m.is(Annotation.Generalization) && m.facetPrescription() == null && !components.contains(m)).map(this::createFrame).forEach(child -> context.add("create", (Object)child.add("node").add("owner").toFrame()));
    }

    private FrameBuilder createFrame(Mogram mogram) {
        FrameBuilder builder = new FrameBuilder(new String[]{"reference", "create"});
        TypesProvider.getTypes(mogram, this.language).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        this.addName((FrameBuilderContext)builder, mogram);
        this.addProperties(mogram, (FrameBuilderContext)builder);
        return builder;
    }

    private List<Mogram> collectChildren(Mogram parent) {
        LinkedHashSet<Mogram> set = new LinkedHashSet<Mogram>();
        for (Mogram child : parent.children()) {
            set.add(child);
            set.addAll(this.collectChildren(child));
        }
        return new ArrayList<Mogram>(set);
    }

    private void addType(FrameBuilderContext frame, Mogram mogram) {
        List mograms = mogram.metaMograms();
        frame.add("conceptLayer", (Object)NameFormatter.layerQualifiedName((Mogram)mograms.get(0)));
        frame.add("type", (Object)this.mogramType(mogram, this.sizeConstraint(mogram)));
    }

    private Size sizeConstraint(Mogram mogram) {
        String string;
        ElementContainer elementContainer = mogram.container();
        if (elementContainer instanceof Mogram) {
            Mogram m = (Mogram)elementContainer;
            string = (String)m.types().get(0);
        } else {
            string = "";
        }
        Constraint.Component constraint = this.language.constraints(string).stream().filter(c -> c instanceof Constraint.Component && ((Constraint.Component)c).type().equals(mogram.types().get(0))).findFirst().orElse(null);
        if (constraint == null) {
            return Size.MULTIPLE();
        }
        return (Size)constraint.rules().stream().filter(rule -> rule instanceof Size).findFirst().orElse((Rule)Size.MULTIPLE());
    }

    private String mogramType(Mogram node, Size size) {
        return Resolver.shortType((String)((String)node.types().get(0))) + (!size.isSingle() ? "List" : "");
    }

    private void addAvailableFacets(Mogram mogram, FrameBuilderContext context) {
        this.allowedFacets(mogram).forEach(facet -> {
            FrameBuilder builder = new FrameBuilder(new String[]{"availableAspect"});
            builder.add("name", (Object)facet.name());
            if (facet.is(Annotation.Generalization)) {
                builder.add("abstract").add(Annotation.Generalization.name());
            }
            if (mogram.is(Annotation.Generalization)) {
                builder.add("abstract", (Object)"null");
            }
            String qn = NameFormatter.cleanQn(NameFormatter.getQn(facet, this.workingPackage));
            builder.add("qn", (Object)qn);
            builder.add("stashQn", (Object)qn);
            this.effectiveProperties((Mogram)facet).filter(p -> ((Size)p.rule(Size.class)).isRequired()).filter(p -> {
                Property overrided = this.overriden((Property)p, (Mogram)facet);
                return overrided == null || ((Size)overrided.rule(Size.class)).isRequired();
            }).forEach(p -> builder.add("variable", (Object)MogramAdapter.facetPropertyFrame(mogram, context, p)));
            context.add("availableAspect", (Object)builder.toFrame());
        });
    }

    private Property overriden(Property p, Mogram m) {
        return m.properties().stream().filter(pr -> pr.name().equals(p.name())).findFirst().orElse(null);
    }

    private static Frame facetPropertyFrame(Mogram mogram, FrameBuilderContext context, Property p) {
        return FrameBuilder.from((FrameBuilderContext)context).append((Object)p).add("required").add("container", (Object)(MogramAdapter.isInDecorable(mogram) ? mogram.qualifiedName() : mogram.name())).toFrame();
    }

    private Collection<Mogram> allowedFacets(Mogram mogram) {
        LinkedHashSet<Mogram> mograms = new LinkedHashSet<Mogram>();
        for (NamedReference facet : mogram.applicableFacets()) {
            mograms.add((Mogram)facet.get());
            mograms.addAll(this.collectChildren((Mogram)facet.get()));
        }
        return mograms;
    }

    private void addName(FrameBuilderContext context, Mogram node) {
        if (node.name() != null) {
            context.add("name", (Object)node.name());
        }
        String qn = NameFormatter.cleanQn(this.buildQN(node));
        context.add("qn", (Object)qn).add("stashQn", (Object)qn);
    }

    private String buildQN(Mogram mogram) {
        return NameFormatter.getQn(mogram, this.workingPackage.toLowerCase());
    }

    private void addProperties(Mogram mogram, FrameBuilderContext context) {
        this.effectiveProperties(mogram).forEach(p -> {
            FrameBuilder builder = FrameBuilder.from((FrameBuilderContext)this.context);
            if (!p.container().equals((Object)mogram)) {
                builder.add("inherited");
            }
            context.add("variable", (Object)builder.add("owner").append(p).add("container", (Object)(MogramAdapter.isInDecorable(mogram) ? this.completeName(mogram) : mogram.name())).toFrame());
        });
        if (mogram.facetPrescription() != null) {
            ((Mogram)mogram.facetPrescription().get()).properties().stream().filter(p -> !this.isOverriden(mogram, (Property)p)).forEach(p -> context.add("variable", (Object)FrameBuilder.from((FrameBuilderContext)context).append(p).add("target").add("container", (Object)(MogramAdapter.isInDecorable(mogram) ? this.completeName(mogram) : mogram.name())).toFrame()));
            mogram.facetConstraints().stream().flatMap(c -> ((Mogram)c.target().get()).properties().stream()).forEach(p -> context.add("variable", (Object)FrameBuilder.from((FrameBuilderContext)context).append(p).add("target").add("container", (Object)(MogramAdapter.isInDecorable(mogram) ? this.completeName(mogram) : mogram.name())).toFrame()));
        }
    }

    protected void addComponents(Mogram mogram, FrameBuilderContext context) {
        this.effectiveComponents(mogram).filter(c -> !c.level().equals((Object)Level.M1) && !c.isAnonymous()).forEach(c -> {
            if (c.equals((Object)mogram)) {
                return;
            }
            FrameBuilder builder = FrameBuilder.from((FrameBuilderContext)context).append(c).add("owner");
            if (!c.container().equals((Object)mogram)) {
                builder.add("inherited");
            }
            context.add("node", (Object)builder.toFrame());
        });
    }

    private String completeName(Mogram node) {
        return node.qualifiedName();
    }

    private boolean isOverriden(Mogram node, Property prop) {
        return node.properties().stream().anyMatch(p -> p.name().equals(prop.name()));
    }

    private boolean isOverriden(Mogram targetNodeComponent, Mogram aspectNode) {
        return aspectNode.components().stream().anyMatch(component -> component.name() != null && component.name().equals(targetNodeComponent.name()));
    }

    private void addFacetConstrains(Mogram node, FrameBuilderContext context) {
        node.facetConstraints().forEach(c -> context.add("constraint", (Object)new FrameBuilder(new String[]{"constraint"}).add("name", (Object)((Mogram)c.target().get()).name()).add("qn", (Object)NameFormatter.cleanQn(NameFormatter.getQn((Mogram)c.target().get(), this.workingPackage))).toFrame()));
    }

    void setInitNode(Mogram initNode) {
        this.initNode = initNode;
    }
}

