/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.templates.GraphLoaderTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.model.Mogram;
import io.intino.tara.processors.model.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GraphLoaderCreator
extends Generator
implements TemplateTags {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilerConfiguration conf;

    public GraphLoaderCreator(Language language, CompilerConfiguration conf) {
        super(language, conf.dsl().outDsl(), conf.generationPackage(), conf.dsl().generationPackage());
        this.conf = conf;
    }

    public String create(Model model) {
        FrameBuilder builder = new FrameBuilder(new String[]{"graphLoader"});
        builder.add("workingPackage", (Object)this.workingPackage);
        builder.add("name", (Object)this.outDsl);
        builder.add("language", (Object)this.language.languageName());
        builder.add("language_workingPackage", (Object)this.conf.dsl().generationPackage());
        builder.add("stash", (Object)this.createStashes(model));
        return Generator.customize(new GraphLoaderTemplate()).render((Object)builder.toFrame());
    }

    private Frame[] createStashes(Model model) {
        return (Frame[])this.unpack(model).stream().map(nodes -> {
            try {
                return this.stashFrame(this.stashOf((List<Mogram>)nodes, this.language));
            }
            catch (TaraException e) {
                LOG.log(Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(Frame[]::new);
    }

    private List<List<Mogram>> unpack(Model model) {
        HashMap<String, List<Mogram>> nodes = new HashMap<String, List<Mogram>>();
        model.components().forEach(node -> {
            if (!nodes.containsKey(node.source().getPath())) {
                nodes.put(node.source().getPath(), new ArrayList());
            }
            ((List)nodes.get(node.source().getPath())).add(node);
        });
        return this.unpack(nodes);
    }

    private List<List<Mogram>> unpack(Map<String, List<Mogram>> nodes) {
        return new ArrayList<List<Mogram>>(nodes.values());
    }

    private Stash stashOf(List<Mogram> nodes, Language language) throws TaraException {
        try {
            return new StashCreator(nodes, language, this.conf.module(), this.conf).create();
        }
        catch (Throwable e) {
            throw new TaraException("Error creating stashes: " + e.getMessage());
        }
    }
}

