/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.GraphTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.PropertyAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Property;
import io.intino.tara.model.rules.Size;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.Model;
import java.util.Collection;
import java.util.stream.Collectors;

public class AbstractGraphCreator
extends Generator
implements TemplateTags {
    private final CompilerConfiguration conf;

    public AbstractGraphCreator(Language language, CompilerConfiguration conf) {
        super(language, conf.dsl().outDsl(), conf.generationPackage(), conf.dsl().generationPackage());
        this.conf = conf;
    }

    public String create(Model model) {
        FrameBuilder builder = new FrameBuilder(new String[]{"graph"});
        builder.add("workingPackage", (Object)this.workingPackage);
        builder.add("name", (Object)this.outDsl);
        this.collectMainNodes(model).stream().filter(node -> node.name() != null).forEach(node -> builder.add("node", (Object)this.createRootNodeFrame((Mogram)node, model.sizeOf((Element)node))));
        Stash stash = new StashCreator(model.components(), this.language, this.outDsl, this.conf).create();
        builder.add("stash", (Object)this.stashFrame(stash));
        builder.add("parentPackage", (Object)this.languageWorkingPackage);
        return Generator.customize(new GraphTemplate()).render((Object)builder.toFrame());
    }

    private Frame createRootNodeFrame(Mogram node, Size size) {
        FrameBuilder builder = new FrameBuilder(new String[]{"node"});
        if (size.isSingle()) {
            builder.add("single");
        }
        if (node.level() == Level.M1) {
            builder.add("instance");
        }
        if (node.is(Annotation.Generalization)) {
            builder.add("abstract");
        }
        String qn = NameFormatter.getQn(node, this.workingPackage.toLowerCase());
        builder.add("qn", (Object)qn).add("stashQn", (Object)qn).add("generatedLanguage", (Object)this.outDsl).add("name", (Object)node.name());
        this.addType(node, size, builder);
        node.properties().stream().filter(variable -> variable.values().isEmpty()).forEach(variable -> builder.add("variable", (Object)this.frameOf((Property)variable)));
        this.addTerminalProperties(node, (FrameBuilderContext)builder);
        return builder.toFrame();
    }

    private void addType(Mogram node, Size rule, FrameBuilder builder) {
        String doc = ((Mogram)node.metaMograms().get(0)).doc();
        if (doc == null) {
            return;
        }
        builder.add("type", (Object)this.nodeType(node, rule));
    }

    private String nodeType(Mogram node, Size rule) {
        return Resolver.shortType((String)((String)node.types().get(0))) + (!rule.isSingle() ? "List" : "");
    }

    private Frame frameOf(Property property) {
        return new FrameBuilder(new String[]{"variable", property.type().getName()}).put(Property.class, (Adapter)new PropertyAdapter(this.language, this.outDsl, this.workingPackage, this.languageWorkingPackage)).append((Object)property).toFrame();
    }

    private Collection<Mogram> collectMainNodes(Model model) {
        return model.components().stream().filter(n -> !n.is(Annotation.Component) && !n.is(Annotation.Feature)).collect(Collectors.toList());
    }
}

