/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte;

import io.intino.itrules.Adapter;
import io.intino.itrules.Engine;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.itrules.adapters.ExcludeAdapter;
import io.intino.itrules.template.Template;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.magritte.io.StashSerializer;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.model.rules.property.NativeObjectRule;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import io.intino.tara.model.rules.property.ReferenceRule;
import io.intino.tara.model.rules.property.WordRule;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.ReferenceProperty;
import io.intino.tara.processors.parser.NativeExtractor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Generator
implements TemplateTags {
    public static final int CHUNK_SIZE = 4000;
    protected final Language language;
    protected final String outDsl;
    protected final String workingPackage;
    protected final String languageWorkingPackage;
    protected Set<String> imports = new HashSet<String>();

    public Generator(Language language, String outDsl, String workingPackage, String languageWorkingPackage) {
        this.language = language;
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
    }

    public static boolean isInDecorable(Mogram mogram) {
        ElementContainer container = mogram.container();
        if (container instanceof MogramRoot) {
            return false;
        }
        while (!(container.container() instanceof MogramRoot)) {
            container = container.container();
        }
        return ((Mogram)container).is(Annotation.Decorable);
    }

    public Set<String> getImports() {
        return this.imports;
    }

    protected void addParent(Mogram mogram, FrameBuilderContext context) {
        if (mogram.parent() == null) {
            if (!mogram.children().isEmpty() || context.contains("create") || context.contains("node")) {
                context.add("parentSuper", (Object)false);
            }
            return;
        }
        Mogram parent = (Mogram)mogram.parent().get();
        String parentQN = NameFormatter.cleanQn(NameFormatter.getQn(parent, this.workingPackage));
        context.add("parent", (Object)parentQN);
        if (context.contains("create") || context.contains("node")) {
            context.add("parentSuper", (Object)true).add("parentName", (Object)parentQN);
        }
        if (context.contains("node") && this.hasLists(parent) || parent.facetPrescription() != null && !(parent.facetPrescription().get() instanceof MogramRoot) && this.hasLists((Mogram)parent.facetPrescription().get())) {
            context.add("parentClearName", (Object)parentQN);
        }
    }

    protected Frame stashFrame(Stash stash) {
        int i;
        FrameBuilder builder = new FrameBuilder(new String[]{"stash"});
        String name = stash.path.replace(".stash", "");
        String code = Base64.getEncoder().encodeToString(StashSerializer.serialize((Stash)stash));
        for (i = 0; i < code.length() / 4000; ++i) {
            builder.add("part", (Object)new FrameBuilder(new String[]{"part"}).add("name", (Object)name).add("index", (Object)i).add("code", (Object)code.substring(4000 * i, 4000 * (i + 1))));
        }
        int rest = code.length() % 4000;
        if (rest > 0) {
            builder.add("part", (Object)new FrameBuilder(new String[]{"part"}).add("name", (Object)name).add("index", (Object)i).add("code", (Object)code.substring(code.length() - rest)));
        }
        return builder.toFrame();
    }

    protected String getType(Property prop) {
        if (prop.isReference()) {
            return NameFormatter.cleanQn(NameFormatter.getQn((Mogram)((ReferenceProperty)prop).target().get(), this.workingPackage.toLowerCase()));
        }
        if (Primitive.WORD.equals((Object)prop.type())) {
            PropertyCustomRule customRule = (PropertyCustomRule)prop.rule(PropertyCustomRule.class);
            return customRule != null ? this.workingPackage.toLowerCase() + ".rules." + String.valueOf(Format.firstUpperCase().format((Object)customRule.externalClass())) : Format.firstUpperCase().format((Object)prop.name()).toString();
        }
        if (Primitive.OBJECT.equals((Object)prop.type())) {
            return ((NativeObjectRule)prop.rule(NativeObjectRule.class)).type();
        }
        return prop.type().javaName();
    }

    private <T> T ruleOfTypeConcrete(List<Rule> rules, Class<T> aClass) {
        return rules.stream().filter(aClass::isInstance).findFirst().orElse(null);
    }

    protected FrameBuilder ruleToFrame(Rule rule) {
        if (rule == null) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder();
        builder.put(Rule.class, (Adapter)new ExcludeAdapter(new String[]{"loadedClass"}));
        builder.append((Object)rule);
        if (rule instanceof PropertyCustomRule) {
            FrameBuilder frameBuilder = new FrameBuilder(new String[]{"customRule"});
            String qualifiedName = ((PropertyCustomRule)rule).qualifiedName();
            if (qualifiedName == null) {
                return frameBuilder;
            }
            frameBuilder.add("qn", (Object)NameFormatter.cleanQn(qualifiedName));
            frameBuilder.add("aClass", (Object)NameFormatter.cleanQn(((PropertyCustomRule)rule).externalClass()));
            if (((PropertyCustomRule)rule).isMetric()) {
                frameBuilder.add("metric");
                frameBuilder.add("default", (Object)((PropertyCustomRule)rule).getDefaultUnit());
            }
            return frameBuilder;
        }
        return builder;
    }

    protected Predicate<Annotation> isLayerInterface() {
        return tag -> tag.equals((Object)Annotation.Component) || tag.equals((Object)Annotation.Feature) || tag.equals((Object)Annotation.Private);
    }

    protected void addTerminalProperties(Mogram mogram, FrameBuilderContext context) {
        List<Constraint> terminalCoreVariables = this.collectTerminalCoreVariables(mogram);
        if (mogram.parent() == null && !terminalCoreVariables.isEmpty() && !context.contains("metaType")) {
            context.add("metaType", (Object)(this.languageWorkingPackage + "." + this.metaType(mogram)));
        }
        terminalCoreVariables.forEach(c -> this.addTerminalVariable(mogram, this.languageWorkingPackage + "." + (String)mogram.types().get(0), context, (Constraint.Property)c, mogram.parent() != null, this.isRequired(mogram, (Constraint.Property)c), "metaType", this.languageWorkingPackage));
        this.addAspectVariables(mogram, context);
        if (!context.contains("container")) {
            context.add("container", (Object)(Generator.isInDecorable(mogram) ? mogram.qualifiedName() : mogram.name()));
        }
    }

    private boolean isRequired(Mogram mogram, Constraint.Property c) {
        while (mogram != null) {
            for (PropertyDescription parameter : mogram.parameters()) {
                if (!parameter.name().equals(c.name())) continue;
                return false;
            }
            mogram = (Mogram)mogram.parent();
        }
        return true;
    }

    private void addAspectVariables(Mogram mogram, FrameBuilderContext context) {
        for (Facet aspect : mogram.appliedFacets()) {
            context.add("metaAspect", (Object)new FrameBuilder(new String[]{"metaAspect"}).add("name", (Object)aspect.type()).add("type", (Object)(this.languageWorkingPackage + "." + aspect.fullType())).toFrame());
        }
        this.collectTerminalFacetVariables(mogram).forEach((key, value) -> value.forEach(c -> this.addTerminalVariable(mogram, this.languageWorkingPackage + "." + (String)mogram.types().get(0), context, (Constraint.Property)c, mogram.parent() != null, this.isRequired(mogram, (Constraint.Property)c), (String)key, this.languageWorkingPackage)));
    }

    private List<Constraint> collectTerminalCoreVariables(Mogram mogram) {
        List allows = this.language.constraints((String)mogram.types().get(0));
        return Collections.emptyList();
    }

    private Map<String, List<Constraint>> collectTerminalFacetVariables(Mogram mogram) {
        List constraints = this.language.constraints((String)mogram.types().get(0));
        if (constraints == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Constraint>> map = new HashMap<String, List<Constraint>>();
        List<Constraint> aspects = constraints.stream().filter(c -> c instanceof Constraint.Facet && this.hasFacet(mogram, ((Constraint.Facet)c).type())).toList();
        for (Constraint aspect : aspects) {
            map.put(((Constraint.Facet)aspect).type(), new ArrayList());
        }
        aspects.forEach(f -> map.put(((Constraint.Facet)f).type(), ((Constraint.Facet)f).constraints().stream().filter(this.byTerminalParameters(mogram)).collect(Collectors.toList())));
        return map;
    }

    protected String metaType(Mogram mogram) {
        String type = (String)mogram.types().get(0);
        return type.contains(":") ? type.split(":")[1] + "." + type.replace(":", "") : (String)mogram.types().get(0);
    }

    private void addTerminalVariable(Mogram mogram, String type, FrameBuilderContext context, Constraint.Property parameter, boolean inherited, boolean isRequired, String containerName, String languageWorkingPackage) {
        FrameBuilder varBuilder = this.createFrame(parameter, type, inherited, isRequired, containerName, languageWorkingPackage);
        if (!varBuilder.contains("container")) {
            varBuilder.add("container", (Object)(Generator.isInDecorable(mogram) ? mogram.qualifiedName() : mogram.name()));
        }
        context.add("variable", (Object)varBuilder.toFrame());
    }

    private boolean hasFacet(Mogram mogram, String type) {
        return mogram.appliedFacets().stream().anyMatch(aspect -> aspect.type().equals(type));
    }

    private Predicate<Constraint> byTerminalParameters(Mogram mogram) {
        return o -> o instanceof Constraint.Property && !this.isRedefined((Constraint.Property)o, mogram.properties());
    }

    private boolean isRedefined(Constraint.Property c, List<? extends Property> property) {
        return property.stream().anyMatch(prop -> prop.name().equals(c.name()));
    }

    private FrameBuilder createFrame(Constraint.Property parameter, String type, boolean inherited, boolean isRequired, String containerName, String workingPackage) {
        WordRule rule;
        FrameBuilder builder = new FrameBuilder(TypesProvider.getTypes(parameter, isRequired)).add("metaType").add("target");
        if (inherited) {
            builder.add("inherited");
        }
        builder.add("name", (Object)parameter.name());
        builder.add("containerName", (Object)containerName);
        builder.add("qn", (Object)type);
        builder.add("language", (Object)this.language.languageName().toLowerCase());
        builder.add("workingPackage", (Object)workingPackage);
        builder.add("type", (Object)this.type(parameter));
        if (parameter.type().equals((Object)Primitive.WORD)) {
            rule = this.ruleOfTypeConcrete(parameter.rules(), WordRule.class);
            List words = rule.words();
            if (rule.isCustom()) {
                builder.add("outDefined");
                builder.add("externalClass", (Object)NameFormatter.cleanQn(rule.externalClass()));
            }
            builder.add("wordValues", (Object)words.toArray(new Object[0]));
        }
        if (parameter.type().equals((Object)Primitive.FUNCTION)) {
            rule = this.ruleOfTypeConcrete(parameter.rules(), FunctionRule.class);
            String signature = rule.signature();
            NativeExtractor extractor = new NativeExtractor(signature);
            builder.add("methodName", (Object)extractor.methodName());
            builder.add("parameters", (Object)extractor.parameters());
            builder.add("returnType", (Object)extractor.returnType());
            builder.add("rule", (Object)rule.interfaceClass());
            this.imports.addAll(new ArrayList(rule.imports()));
        }
        if (!builder.contains("generatedLanguage")) {
            builder.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        return builder;
    }

    private String type(Constraint.Property parameter) {
        return parameter.type() == Primitive.REFERENCE ? this.languageWorkingPackage + "." + (String)this.ruleOfTypeConcrete(parameter.rules(), ReferenceRule.class).allowedReferences().get(0) : parameter.type().getName();
    }

    public static Engine customize(Template template) {
        Engine engine = new Engine(template);
        engine.add("string", Format.string());
        engine.add("reference", Format.reference());
        engine.add("toCamelCase", Format.toCamelCase());
        engine.add("snakeCaseToCamelCase", Format.snakeCaseToCamelCase());
        engine.add("withDollar", Format.withDollar());
        engine.add("noPackage", Format.noPackage());
        engine.add("key", Format.key());
        engine.add("WithoutType", Format.nativeParameterWithoutType());
        engine.add("javaValidName", Format.javaValidName());
        engine.add("javaValidWord", Format.javaValidWord());
        engine.add("withoutGeneric", Format.withoutGeneric());
        return engine;
    }

    protected Stream<Property> effectiveProperties(Mogram mogram) {
        Mogram current;
        LinkedHashMap properties = new LinkedHashMap();
        Mogram mogram2 = current = mogram.parent() != null ? (Mogram)mogram.parent().get() : null;
        while (current != null) {
            current.properties().forEach(p -> properties.put(p.name(), p));
            current = current.parent() != null ? (Mogram)current.parent().get() : null;
        }
        ArrayList list = new ArrayList(properties.values());
        Collections.reverse(list);
        mogram.properties().stream().filter(property -> list.stream().noneMatch(p -> p.name().equals(property.name()))).forEach(list::add);
        return list.stream();
    }

    protected Stream<Mogram> effectiveComponents(Mogram mogram) {
        Mogram current;
        LinkedHashMap mograms = new LinkedHashMap();
        Mogram mogram2 = current = mogram.parent() != null ? (Mogram)mogram.parent().get() : null;
        while (current != null) {
            current.components().forEach(m -> mograms.put(m.name(), m));
            current.components().stream().flatMap(c -> c.children().stream()).forEach(c -> mograms.put(c.name(), c));
            current = current.parent() != null ? (Mogram)current.parent().get() : null;
        }
        ArrayList list = new ArrayList(mograms.values());
        Collections.reverse(list);
        mogram.components().stream().filter(c -> list.stream().noneMatch(p -> p.name().equals(c.name()))).forEach(list::add);
        return list.stream();
    }

    protected Stream<HasMogram> effectiveReferenceComponents(Mogram mogram) {
        Mogram current;
        LinkedHashMap refs = new LinkedHashMap();
        Mogram mogram2 = current = mogram.parent() != null ? (Mogram)mogram.parent().get() : null;
        while (current != null) {
            current.referenceComponents().stream().map(r -> (HasMogram)r).forEach(r -> refs.put(((Mogram)r.target().get()).name(), r));
            current = current.parent() != null ? (Mogram)current.parent().get() : null;
        }
        ArrayList list = new ArrayList(refs.values());
        Collections.reverse(list);
        mogram.referenceComponents().stream().map(r -> (HasMogram)r).filter(c -> list.stream().noneMatch(hs -> ((Mogram)hs.target().get()).name().equals(((Mogram)c.target().get()).name()))).forEach(list::add);
        return list.stream();
    }

    private boolean hasLists(Mogram mogram) {
        return this.effectiveComponents(mogram).anyMatch(c -> !c.container().sizeOf((Element)c).isSingle() && !c.is(Annotation.Final)) || this.effectiveReferenceComponents(mogram).anyMatch(c -> !c.container().sizeOf((Element)c).isSingle() && !c.annotations().contains(Annotation.Final));
    }
}

