package io.intino.magritte.builder.compiler.codegeneration.magritte.layer.templates.layer;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class LayerTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("Layer", "decorable")).output(literal("package ")).output(placeholder("package", "javaValidName", "lowercase")).output(expression().output(literal(".")).output(placeholder("container", "lowercase"))).output(literal(";\n\npublic ")).output(expression().output(placeholder("abstract"))).output(literal(" class ")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal(" extends Abstract")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal(" {\n\tpublic ")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal("(io.intino.magritte.framework.Node node) {\n\t\tsuper(node);\n\t}\n\n\t")).output(expression().output(placeholder("decorableNode").multiple("\n\n"))).output(literal("\n}\n")));
		rules.add(rule().condition(trigger("decorablenode")).output(literal("public static ")).output(expression().output(placeholder("abstract"))).output(literal(" class ")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal(" extends Abstract")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal(" {\n\tpublic ")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal("(io.intino.magritte.framework.Node node) {\n\t\tsuper(node);\n\t}\n\n\t")).output(expression().output(placeholder("decorableNode").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(allTypes("Layer")).output(literal("package ")).output(placeholder("package", "javaValidName", "lowercase")).output(literal(";\n\nimport ")).output(placeholder("workingPackage", "javaValidName", "lowercase")).output(literal(".*;\n")).output(expression().output(placeholder("imports").multiple("\n"))).output(literal("\n\n")).output(placeholder("node")));
		rules.add(rule().condition(all(all(allTypes("single", "owner"), not(any(any(allTypes("overriden"), allTypes("instance")), allTypes("inherited")))), trigger("add"))).output(literal("if (node.is(\"")).output(placeholder("stashQn", "noPackage", "withDollar")).output(literal("\")) this.")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName", "javaValidName")).output(literal(" = node.as(")).output(placeholder("qn", "reference")).output(literal(".class);")));
		rules.add(rule().condition(all(all(allTypes("owner"), not(any(any(allTypes("overriden"), allTypes("instance")), allTypes("inherited")))), trigger("add"))).output(literal("if (node.is(\"")).output(placeholder("stashQn", "noPackage", "withDollar")).output(literal("\")) this.")).output(placeholder("name", "toCamelCase", "FirstLowerCase")).output(literal("List.add(node.as(")).output(placeholder("qn", "reference")).output(literal(".class));")));
		rules.add(rule().condition(all(allTypes("overriden"), trigger("add"))));
		rules.add(rule().condition(all(all(allTypes("single", "owner"), not(any(any(allTypes("overriden"), allTypes("instance")), allTypes("inherited")))), trigger("remove"))).output(literal("if (node.is(\"")).output(placeholder("stashQn", "noPackage", "withDollar")).output(literal("\")) this.")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName", "javaValidName")).output(literal(" = null;")));
		rules.add(rule().condition(all(all(allTypes("owner"), not(any(any(allTypes("overriden"), allTypes("instance")), allTypes("inherited")))), trigger("remove"))).output(literal("if (node.is(\"")).output(placeholder("stashQn", "noPackage", "withDollar")).output(literal("\")) this.")).output(placeholder("name", "toCamelCase", "FirstLowerCase")).output(literal("List.remove(node.as(")).output(placeholder("qn", "reference")).output(literal(".class));")));
		rules.add(rule().condition(all(allTypes("overriden"), trigger("remove"))));
		rules.add(rule().condition(all(all(allTypes("node"), not(any(any(any(any(allTypes("aspect"), allTypes("final")), allTypes("instance")), allTypes("generalization")), allTypes("inherited")))), trigger("new"))).output(literal("public ")).output(placeholder("qn", "reference")).output(literal(" ")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName", "javaValidName")).output(literal("(")).output(placeholder("variable", "parameters").multiple(", ")).output(literal(") {\n\t")).output(placeholder("qn", "reference")).output(literal(" newElement = core$().graph().concept(")).output(placeholder("qn", "reference")).output(literal(".class).createNode(this.name, core$()).as(")).output(placeholder("qn", "reference")).output(literal(".class);\n\t")).output(placeholder("variable", "assign").multiple("\n")).output(literal("\n\treturn newElement;\n}")));
		rules.add(rule().condition(all(all(allTypes("node"), not(any(any(any(any(any(any(allTypes("aspect"), allTypes("single")), allTypes("final")), allTypes("instance")), allTypes("generalization")), allTypes("overriden")), allTypes("inherited")))), trigger("clear"))).output(literal("public void ")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal("(java.util.function.Predicate<")).output(placeholder("qn", "reference")).output(literal("> filter) {\n\tnew java.util.ArrayList<>(")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal("List()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);\n}")));
		rules.add(rule().condition(all(all(allTypes("node", "create"), not(any(any(any(allTypes("aspect"), allTypes("final")), allTypes("instance")), allTypes("inherited")))), trigger("new"))).output(literal("public ")).output(placeholder("qn", "reference")).output(literal(" ")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName", "javaValidName")).output(literal("(")).output(placeholder("variable", "parameters").multiple(", ")).output(literal(") {\n\t")).output(placeholder("qn", "reference")).output(literal(" newElement = core$().graph().concept(")).output(placeholder("qn", "reference")).output(literal(".class).createNode(this.name, core$()).as(")).output(placeholder("qn", "reference")).output(literal(".class);\n\t")).output(placeholder("variable", "assign").multiple("\n")).output(literal("\n\treturn newElement;\n}")));
		rules.add(rule().condition(all(all(allTypes("node", "create"), not(any(any(any(allTypes("single"), allTypes("final")), allTypes("instance")), allTypes("inherited")))), trigger("clear"))).output(literal("public void ")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal("(java.util.function.Predicate<")).output(placeholder("qn", "reference")).output(literal("> filter) {\n\tnew java.util.ArrayList<>(")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal("List()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);\n}")));
		rules.add(rule().condition(all(allTypes("node", "owner"), trigger("new"))));
		rules.add(rule().condition(all(allTypes("node", "owner"), trigger("clear"))));
		rules.add(rule().condition(all(all(all(allTypes("availableAspect"), not(allTypes("generalization"))), attribute("variable")), trigger("availableaspect"))).output(literal("public ")).output(placeholder("qn")).output(literal(" as")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\treturn a$(")).output(placeholder("qn", "reference")).output(literal(".class);\n}\n\npublic ")).output(placeholder("qn")).output(literal(" as")).output(placeholder("name", "FirstUpperCase")).output(literal("(")).output(expression().output(placeholder("variable", "parameters").multiple(", "))).output(literal(") {\n\t")).output(placeholder("qn", "reference")).output(literal(" newElement = core$().addAspect(")).output(placeholder("qn", "reference")).output(literal(".class);\n\t")).output(placeholder("variable", "assign").multiple("\n")).output(literal("\n\treturn newElement;\n}\n\npublic boolean is")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\treturn core$().is(")).output(placeholder("qn", "reference")).output(literal(".class);\n}\n\npublic void remove")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\tcore$().removeAspect(")).output(placeholder("qn", "reference")).output(literal(".class);\n}")));
		rules.add(rule().condition(all(all(allTypes("availableAspect"), not(allTypes("generalization"))), trigger("availableaspect"))).output(literal("\npublic ")).output(placeholder("qn", "reference")).output(literal(" as")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\tio.intino.magritte.framework.Layer as = a$(")).output(placeholder("qn", "reference")).output(literal(".class);\n\treturn as != null ? (")).output(placeholder("qn", "reference")).output(literal(") as : core$().addAspect(")).output(placeholder("qn", "reference")).output(literal(".class);\n}\n\npublic boolean is")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\treturn core$().is(")).output(placeholder("qn", "reference")).output(literal(".class);\n}\n\npublic void remove")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\tcore$().removeAspect(")).output(placeholder("qn", "reference")).output(literal(".class);\n}")));
		rules.add(rule().condition(all(allTypes("availableAspect"), trigger("availableaspect"))).output(literal("public ")).output(placeholder("qn", "reference")).output(literal(" as")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\treturn a$(")).output(placeholder("qn", "reference")).output(literal(".class);\n}\n\npublic boolean is")).output(placeholder("name", "FirstUpperCase")).output(literal("() {\n\treturn core$().is(")).output(placeholder("qn", "reference")).output(literal(".class);\n}")));
		rules.add(rule().condition(all(allTypes("core"), trigger("core"))).output(literal("public ")).output(placeholder("qn", "reference")).output(literal(" as")).output(placeholder("name")).output(literal("() {\n\treturn (")).output(placeholder("qn", "reference")).output(literal(") a$(")).output(placeholder("qn", "reference")).output(literal(".class);\n}")));
		rules.add(rule().condition(all(all(allTypes("aspect"), not(allTypes("overriden"))), trigger("aspectassign"))).output(literal("if (layer instanceof ")).output(placeholder("qn", "reference")).output(literal(") _")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal(" = (")).output(placeholder("qn", "reference")).output(literal(") layer;")));
		rules.add(rule().condition(all(allTypes("constraint"), trigger("aspectassign"))).output(literal("if (layer instanceof ")).output(placeholder("qn", "reference")).output(literal(") _")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal(" = (")).output(placeholder("qn", "reference")).output(literal(") layer;")));
		rules.add(rule().condition(trigger("decorable")).output(literal("Abstract")));
		rules.add(rule().condition(all(all(all(all(not(allTypes("target")), allTypes("nodeimpl")), not(allTypes("instance"))), not(allTypes("inherited"))), trigger("node"))).output(literal("public")).output(expression().output(literal(" ")).output(placeholder("inner"))).output(expression().output(literal(" ")).output(placeholder("abstract"))).output(literal(" class ")).output(placeholder("decorable")).output(expression().output(placeholder("name", "javaValidName", "FirstUpperCase"))).output(expression().output(literal(" extends ")).output(placeholder("parent")).next(expression().output(literal(" extends io.intino.magritte.framework.Layer")))).output(expression().output(literal(" implements ")).output(placeholder("flag", "tag").multiple(", "))).output(literal(" {\n\t")).output(expression().output(placeholder("variable", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("node", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("aspect", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("constraint", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("metaType"))).output(literal("\n\t")).output(expression().output(placeholder("metaAspect").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("decorable")).output(placeholder("name", "javaValidName", "FirstUpperCase")).output(literal("(io.intino.magritte.framework.Node node) {\n\t\tsuper(node);\n\t\t")).output(expression().output(literal("_metaType = a")).output(literal("$")).output(literal("(")).output(placeholder("metaType", "typeInit")).output(literal(".class);"))).output(literal("\n\t\t")).output(expression().output(literal("_")).output(placeholder("metaAspect", "name")).output(literal(" = a")).output(literal("$")).output(literal("(")).output(placeholder("metaAspect", "typeInit")).output(literal(".class);"))).output(literal("\n\t}\n\n\t")).output(expression().output(placeholder("variable", "getter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(placeholder("variable", "setter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(placeholder("node", "getter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(placeholder("node", "setter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(placeholder("availableAspect").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(placeholder("core"))).output(literal("\n\n\t")).output(expression().output(literal("protected java.util.List<io.intino.magritte.framework.Node")).output(literal(">")).output(literal(" componentList")).output(literal("$")).output(literal("() {")).output(literal("\n")).output(literal("\tjava.util.Set<io.intino.magritte.framework.Node")).output(literal(">")).output(literal(" components = new java.util.LinkedHashSet<")).output(literal(">")).output(literal("(super.componentList")).output(literal("$")).output(literal("());")).output(literal("\n")).output(literal("\t")).output(placeholder("node", "componentList").multiple("\n")).output(literal("\n")).output(literal("\treturn new java.util.ArrayList<")).output(literal(">")).output(literal("(components);")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t@Override\n\tprotected java.util.Map<java.lang.String, java.util.List<?>> variables$() {\n\t\tjava.util.Map<java.lang.String, java.util.List<?>> map = new java.util.LinkedHashMap<>(")).output(placeholder("parent", "var")).output(literal(");\n\t\t")).output(expression().output(placeholder("variable", "list").multiple("\n"))).output(literal("\n\t\treturn map;\n\t}\n\n\t")).output(expression().output(literal("@Override")).output(literal("\n")).output(literal("protected void addNode")).output(literal("$")).output(literal("(io.intino.magritte.framework.Node node) {")).output(literal("\n")).output(literal("\tsuper.addNode")).output(literal("$")).output(literal("(node);")).output(literal("\n")).output(literal("\t")).output(placeholder("node", "add").multiple("\n")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(literal("@Override")).output(literal("\n")).output(literal("protected void removeNode")).output(literal("$")).output(literal("(io.intino.magritte.framework.Node node) {")).output(literal("\n")).output(literal("\tsuper.removeNode")).output(literal("$")).output(literal("(node);")).output(literal("\n")).output(literal("\t")).output(placeholder("node", "remove").multiple("\n")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t@Override\n\tprotected void load$(java.lang.String name, java.util.List<?> values) {\n\t\tsuper.load$(name, values);\n\t\t")).output(expression().output(placeholder("aspect", "init"))).output(literal("\n\t\t")).output(expression().output(placeholder("metaType", "metaTypeLoad"))).output(literal("\n\t\t")).output(expression().output(placeholder("metaAspect", "metaAspectLoad"))).output(literal("\n\t\t")).output(expression().output(placeholder("variable", "init").multiple("\nelse "))).output(literal("\n\t}\n\n\t@Override\n\tprotected void set$(java.lang.String name, java.util.List<?> values) {\n\t\tsuper.set$(name, values);\n\t\t")).output(expression().output(placeholder("aspect", "set"))).output(literal("\n\t\t")).output(expression().output(placeholder("metaType", "metaTypeSet"))).output(literal("\n\t\t")).output(expression().output(placeholder("metaAspect", "metaAspectSet"))).output(literal("\n\t\t")).output(expression().output(placeholder("variable", "set").multiple("\nelse "))).output(literal("\n\t}\n\n\t")).output(expression().output(literal("@Override")).output(literal("\n")).output(literal("protected void sync")).output(literal("$")).output(literal("(io.intino.magritte.framework.Layer layer) {")).output(literal("\n")).output(literal("\tsuper.sync")).output(literal("$")).output(literal("(layer);")).output(literal("\n")).output(literal("\t")).output(placeholder("aspect", "aspectAssign").multiple("\nelse ")).output(literal("\n")).output(literal("\t")).output(placeholder("constraint", "aspectAssign").multiple("\nelse ")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(literal("public Create create() {")).output(literal("\n")).output(literal("\treturn new Create(null);")).output(literal("\n")).output(literal("}")).output(literal("\n")).output(literal("\n")).output(literal("public Create create(java.lang.String name) {")).output(literal("\n")).output(literal("\treturn new Create(name);")).output(literal("\n")).output(literal("}")).output(literal("\n")).output(literal("\n")).output(literal("public class Create ")).output(placeholder("parentName", "parentCreate")).output(literal(" {")).output(literal("\n")).output(literal("\t")).output(placeholder("parentSuper", "parentvariable")).output(literal("\n")).output(literal("\n")).output(literal("\tpublic Create(java.lang.String name) {")).output(literal("\n")).output(literal("\t\t")).output(placeholder("parentSuper", "parentinit")).output(literal("\n")).output(literal("\t}")).output(literal("\n")).output(literal("\n")).output(literal("\t")).output(placeholder("node", "new").multiple("\n\n")).output(literal("\n")).output(literal("\t")).output(placeholder("create", "new").multiple("\n\n")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(literal("public Clear clear() {")).output(literal("\n")).output(literal("\treturn new Clear();")).output(literal("\n")).output(literal("}")).output(literal("\n")).output(literal("\n")).output(literal("public class Clear ")).output(placeholder("parentClearName", "parentClear")).output(literal(" {")).output(literal("\n")).output(literal("\t")).output(placeholder("node", "clear").multiple("\n\n")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(placeholder("node").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("workingPackage", "javaValidName", "lowerCase")).output(literal(".")).output(placeholder("generatedLanguage", "javaValidName", "FirstUpperCase")).output(literal("Graph graph() {\n\t\treturn core$().graph().as(")).output(placeholder("workingPackage", "javaValidName", "lowerCase")).output(literal(".")).output(placeholder("generatedLanguage", "javaValidName", "FirstUpperCase")).output(literal("Graph.class);\n\t}\n}")));
		rules.add(rule().condition(trigger("parentcreate")).output(literal("extends ")).output(placeholder("")).output(literal(".Create")));
		rules.add(rule().condition(trigger("parentclear")).output(literal("extends ")).output(placeholder("")).output(literal(".Clear")));
		rules.add(rule().condition(all(allTypes("metaAspect"), trigger("name"))).output(placeholder("name", "javaValidName", "FirstLowerCase")));
		rules.add(rule().condition(all(allTypes("metaAspect"), trigger("typeinit"))).output(placeholder("type")));
		rules.add(rule().condition(trigger("typeinit")).output(placeholder("")));
		rules.add(rule().condition(all(attribute("", "true"), trigger("parentinit"))).output(literal("super(name);")));
		rules.add(rule().condition(all(attribute("", "false"), trigger("parentinit"))).output(literal("this.name = name;")));
		rules.add(rule().condition(all(attribute("", "true"), trigger("parentvariable"))));
		rules.add(rule().condition(all(attribute("", "false"), trigger("parentvariable"))).output(literal("protected final java.lang.String name;")));
		rules.add(rule().condition(trigger("metatypeload")).output(literal("core$().load(_metaType, name, values);")));
		rules.add(rule().condition(trigger("metatypeset")).output(literal("core$().set(_metaType, name, values);")));
		rules.add(rule().condition(trigger("metaaspectload")).output(literal("core$().load(_")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal(", name, values);")));
		rules.add(rule().condition(trigger("metaaspectset")).output(literal("core$().set(_")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal(", name, values);")));
		rules.add(rule().condition(trigger("metatype")).output(literal("protected ")).output(placeholder("")).output(literal(" _metaType;")));
		rules.add(rule().condition(trigger("metaaspect")).output(literal("protected ")).output(placeholder("type")).output(literal(" _")).output(placeholder("name", "toCamelCase", "FirstLowerCase", "javaValidName")).output(literal(";")));
		rules.add(rule().condition(trigger("tag")).output(literal("io.intino.magritte.framework.tags.")).output(placeholder("", "lowerCase", "FirstUpperCase")));
		rules.add(rule().condition(all(attribute("layer"), trigger("var"))));
		rules.add(rule().condition(trigger("var")).output(literal("super.variables$()")));
		rules.add(rule().condition(all(attribute("", "true"), trigger("inner"))).output(literal("static")));
		rules.add(rule().condition(all(attribute("", "true"), trigger("abstract"))).output(literal("abstract")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}