package io.intino.magritte.builder.codegeneration.language;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class LanguageTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((type("Model"))).output(literal("package tara.dsl;\n\nimport io.intino.magritte.lang.model.Tag;\nimport io.intino.magritte.lang.model.Primitive;\nimport io.intino.magritte.lang.model.rules.Size;\nimport io.intino.magritte.lang.model.rules.variable.*;\n\nimport java.util.Arrays;\nimport java.util.Locale;\n\nimport static io.intino.magritte.lang.semantics.constraints.RuleFactory.*;\n\npublic class ")).output(mark("name", "reference", "FirstUpperCase")).output(literal(" extends io.intino.magritte.dsl.Tara {\n\tpublic ")).output(mark("name", "reference", "FirstUpperCase")).output(literal("() {\n\t\t")).output(mark("node", "super").multiple("\n")).output(literal("\n\t\t")).output(mark("root", "call").multiple("\n")).output(literal("\n\t}\n\n\t")).output(mark("root", "method").multiple("\n")).output(literal("\n\n\t@Override\n\tpublic String languageName() {\n\t\treturn \"")).output(mark("name", "FirstUpperCase")).output(literal("\";\n\t}\n\n\t@Override\n    public Locale locale() {\n        return ")).output(mark("locale")).output(literal(";\n    }\n\n    @Override\n    public boolean isTerminalLanguage() {\n        return ")).output(mark("terminal")).output(literal(";\n    }\n\n\t@Override\n\tpublic String metaLanguage() {\n\t\treturn ")).output(mark("metaLanguage", "quoted")).output(literal(";\n\t}\n}")),
				rule().condition((type("instance")), (trigger("super"))).output(literal("declare(")).output(mark("qn", "quoted")).output(literal(", Arrays.asList(")).output(mark("nodeType").multiple(", ")).output(literal("), ")).output(mark("path", "quoted")).output(literal(");")),
				rule().condition((type("node")), (trigger("super"))).output(literal("def(\"")).output(mark("name")).output(literal("\").with(context(")).output(expression().output(mark("nodeType"))).output(literal(")")).output(expression().output(literal(".")).output(mark("constraints"))).output(expression().output(literal(".")).output(mark("assumptions"))).output(expression().output(literal(".")).output(mark("doc"))).output(literal(");")),
				rule().condition((trigger("call"))).output(literal("Root")).output(mark("number")).output(literal(".load(this);")),
				rule().condition((trigger("method"))).output(literal("private static class Root")).output(mark("number")).output(literal(" {\n\tprivate static void load(")).output(mark("language", "reference", "firstUpperCase")).output(literal(" self) {\n\t\t")).output(mark("node").multiple("\n")).output(literal("\n\t}\n}")),
				rule().condition((type("instance")), (trigger("node"))).output(literal("self.declare(")).output(mark("qn", "quoted")).output(literal(", Arrays.asList(")).output(mark("nodeType").multiple(", ")).output(literal("), ")).output(mark("path", "quoted")).output(literal(");")),
				rule().condition((type("node")), (trigger("node"))).output(literal("self.def(\"")).output(mark("name")).output(literal("\").with(self.context(")).output(expression().output(mark("nodeType"))).output(literal(")")).output(expression().output(literal(".")).output(mark("constraints"))).output(expression().output(literal(".")).output(mark("assumptions"))).output(expression().output(literal(".")).output(mark("doc"))).output(literal(");")),
				rule().condition((type("nodeType")), (trigger("nodetype"))).output(mark("type", "quoted").multiple(", ")),
				rule().condition((trigger("constraints"))).output(literal("has(")).output(expression().output(mark("constraint").multiple(", "))).output(literal(")")),
				rule().condition((type("constraint")), (type("component")), (trigger("constraint"))).output(literal("component(")).output(mark("type", "quoted")).output(literal(", Arrays.asList(")).output(mark("size").multiple(", ")).output(literal(")")).output(expression().output(literal(", ")).output(mark("tags").multiple(", "))).output(literal(")")),
				rule().condition((type("constraint")), (type("parameter")), (type("reference")), (trigger("constraint"))).output(literal("parameter(\"")).output(mark("name")).output(literal("\", \"")).output(mark("type")).output(literal("\", ")).output(expression().output(literal("\"")).output(mark("aspect")).output(literal("\"")).next(expression().output(literal("\"\"")))).output(literal(", ")).output(mark("size")).output(literal(", ")).output(mark("position")).output(literal(", \"")).output(mark("scope")).output(literal("\", ")).output(expression().output(mark("rule")).next(expression().output(literal("null")))).output(expression().output(literal(", ")).output(mark("tags").multiple(", "))).output(literal(")")),
				rule().condition((type("constraint")), (type("parameter")), (trigger("constraint"))).output(literal("parameter(\"")).output(mark("name")).output(literal("\", ")).output(mark("type", "primitive")).output(literal(", ")).output(expression().output(literal("\"")).output(mark("aspect")).output(literal("\"")).next(expression().output(literal("\"\"")))).output(literal(", ")).output(mark("size")).output(literal(", ")).output(mark("position")).output(literal(", \"")).output(mark("scope")).output(literal("\", ")).output(expression().output(mark("rule")).next(expression().output(literal("null")))).output(expression().output(literal(", ")).output(mark("tags").multiple(", "))).output(literal(")")),
				rule().condition((type("constraint")), (type("metaAspect")), (trigger("constraint"))).output(literal("metaAspect(\"")).output(mark("value")).output(literal("\"")).output(expression().output(literal(", ")).output(mark("with", "quoted").multiple(", "))).output(literal(")")),
				rule().condition((type("constraint")), (type("aspect")), (trigger("constraint"))).output(literal("aspect(\"")).output(mark("value")).output(literal("\"")).output(expression().output(literal(", ")).output(mark("terminal")).next(expression().output(literal(", false")))).output(expression().output(literal(", ")).output(mark("required")).next(expression().output(literal(", false")))).output(literal(", new String[]{")).output(mark("with", "quoted").multiple(", ")).output(literal("}, new String[]{")).output(mark("without", "quoted").multiple(", ")).output(literal("})")).output(expression().output(literal(".has(")).output(mark("constraint").multiple(", ")).output(literal(")"))),
				rule().condition((type("constraint")), (type("oneOf")), (trigger("constraint"))).output(literal("oneOf(Arrays.asList(")).output(mark("rule").multiple(", ")).output(literal("), ")).output(expression().output(mark("constraint").multiple(", "))).output(literal(")")),
				rule().condition((type("constraint")), (type("redefine")), (trigger("constraint"))).output(literal("redefine(")).output(mark("name", "quoted")).output(literal(", ")).output(mark("supertype", "quoted")).output(literal(")")),
				rule().condition((trigger("constraint"))).output(mark("")).output(literal("()")),
				rule().condition((trigger("tags"))).output(literal("Tag.")).output(mark("")),
				rule().condition((allTypes("customRule", "metric")), (trigger("rule"))).output(mark("qn")).output(literal(".")).output(mark("default")),
				rule().condition((type("nativecustomwordrule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.WordRule(Arrays.asList(")).output(mark("words", "quoted").multiple(", ")).output(literal(")")).output(expression().output(literal(", ")).output(mark("externalWordClass", "quoted"))).output(literal(")")),
				rule().condition((type("customrule")), (trigger("rule"))).output(literal("new ")).output(mark("qn")).output(literal("()")),
				rule().condition((allTypes("rule", "customRule")), (trigger("size"))).output(literal("new ")).output(mark("qn")).output(literal("()")),
				rule().condition((allTypes("rule", "size")), (trigger("size"))).output(literal("new Size(")).output(mark("min")).output(literal(", ")).output(mark("max")).output(expression().output(literal(", ")).output(mark("into", "size"))).output(literal(")")),
				rule().condition((allTypes("rule", "size")), (trigger("rule"))).output(literal("new Size(")).output(mark("min")).output(literal(", ")).output(mark("max")).output(expression().output(literal(", ")).output(mark("into", "size"))).output(literal(")")),
				rule().condition((type("nativeObjectRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.NativeObjectRule(\"")).output(mark("type")).output(literal("\")")),
				rule().condition((type("nativeReferenceRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.NativeReferenceRule(Arrays.asList(")).output(mark("allowedReferences", "quoted").multiple(", ")).output(literal("))")),
				rule().condition((type("nativerule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.NativeRule(\"")).output(mark("interfaceClass")).output(literal("\", \"")).output(mark("signature")).output(literal("\", Arrays.asList(")).output(mark("imports", "quoted").multiple(", ")).output(literal("))")),
				rule().condition((type("wordrule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.WordRule(Arrays.asList(")).output(mark("words", "quoted").multiple(", ")).output(literal(")")).output(expression().output(literal(", ")).output(mark("externalWordClass", "quoted"))).output(literal(")")),
				rule().condition((type("referenceRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.ReferenceRule(Arrays.asList(")).output(mark("allowedReferences", "quoted").multiple(", ")).output(literal("))")),
				rule().condition((type("doubleRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.DoubleRule(")).output(mark("min", "cast")).output(literal(", ")).output(mark("max", "cast")).output(literal(", \"")).output(mark("metric")).output(literal("\")")),
				rule().condition((type("integerRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.IntegerRule(")).output(mark("min")).output(literal(", ")).output(mark("max")).output(literal(", \"")).output(mark("metric")).output(literal("\")")),
				rule().condition((type("dateRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.DateRule(")).output(expression().output(mark("parameters", "quoted")).output(literal(","))).output(literal(")")),
				rule().condition((type("instantRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.InstantRule(")).output(expression().output(mark("parameters", "quoted")).output(literal(","))).output(literal(")")),
				rule().condition((type("fileRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.FileRule(Arrays.asList(")).output(mark("extensions", "quoted").multiple(", ")).output(literal("))")),
				rule().condition((type("stringRule")), (trigger("rule"))).output(literal("new io.intino.magritte.lang.model.rules.variable.StringRule(")).output(mark("regex", "quoted")).output(literal(")")),
				rule().condition((trigger("rule"))).output(literal("null")),
				rule().condition((attribute("", "Infinity")), (trigger("cast"))).output(literal("Double.POSITIVE_INFINITY")),
				rule().condition((attribute("", "-Infinity")), (trigger("cast"))).output(literal("Double.NEGATIVE_INFINITY")),
				rule().condition(not(attribute("", "-Infinity")), not(attribute("", "Infinity")), (trigger("cast"))).output(mark("")),
				rule().condition((type("assumptions")), (trigger("assumptions"))).output(literal("assume(")).output(mark("assumption").multiple(", ")).output(literal(")")),
				rule().condition((type("doc")), (trigger("doc"))).output(literal("doc(")).output(mark("layer", "quoted")).output(literal(", ")).output(mark("file", "quoted")).output(literal(", ")).output(mark("line")).output(literal(", ")).output(mark("doc", "quoted")).output(literal(")")),
				rule().condition((type("stashNodeName")), (trigger("assumption"))).output(literal("stashNodeName(\"")).output(mark("value", "withDollar")).output(literal("\")")),
				rule().condition((trigger("assumption"))).output(literal("is")).output(mark("", "toCamelCase")).output(literal("()")),
				rule().condition((trigger("quoted"))).output(literal("\"")).output(mark("")).output(literal("\"")),
				rule().condition((trigger("primitive"))).output(literal("Primitive.")).output(mark("", "UpperCase")),
				rule().condition((trigger("locale")), (attribute("", "es"))).output(literal("new Locale(\"es\", \"Spain\", \"es_ES\")")),
				rule().condition((trigger("locale")), (attribute("", "en"))).output(literal("Locale.ENGLISH"))
		);
	}
}