/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.Language;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.EmptyMogram;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Flags;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Valued;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.variable.NativeRule;
import io.intino.tara.language.model.rules.variable.VariableCustomRule;
import io.intino.tara.language.model.rules.variable.WordRule;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.PrimitiveTypeCompatibility;
import io.intino.tara.language.semantics.constraints.flags.AnnotationCoherenceCheckerFactory;
import io.intino.tara.language.semantics.constraints.flags.FlagChecker;
import io.intino.tara.language.semantics.constraints.flags.FlagCoherenceCheckerFactory;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class GlobalConstraints {
    private static boolean isOverridden(Variable variable, Variable parentVar) {
        return parentVar.type() != null && parentVar.type().equals((Object)variable.type()) && parentVar.name() != null && parentVar.name().equals(variable.name());
    }

    private static void error(String message, Element element, List<?> parameters) throws SemanticException {
        throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, element, parameters));
    }

    private static void error(String message, Element element) throws SemanticException {
        throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, element));
    }

    public Constraint[] all() {
        return new Constraint[]{this.parentConstraint(), this.referencesInInstances(), this.invalidNodeFlags(), this.duplicatedTags(), this.duplicatedInstances(), this.tagsCoherence(), this.invalidNodeRules(), this.checkVariables(), this.nodeName(), this.duplicatedFacets()};
    }

    private Constraint invalidNodeRules() {
        return element -> {
            Mogram mogram = (Mogram)element;
            for (Mogram component : mogram.components()) {
                if (mogram.rulesOf(component).stream().filter(r -> r instanceof Size).count() <= 1L) continue;
                GlobalConstraints.error("reject.component.with.multiple.size.rule", mogram);
            }
        };
    }

    private Constraint parentConstraint() {
        return element -> {
            Mogram mogram = (Mogram)element;
            Mogram parent = mogram.parent();
            if (parent == null) {
                return;
            }
            parent.resolve();
            String nodeType = mogram.type();
            if (!parent.type().equals(nodeType.split(":")[0]) && !parent.type().equals(nodeType)) {
                GlobalConstraints.error("reject.parent.different.type", mogram, Arrays.asList(parent.type(), nodeType));
            }
            if (parent.is(Tag.Instance)) {
                GlobalConstraints.error("reject.sub.of.instance", mogram);
            }
        };
    }

    private Constraint referencesInInstances() {
        return element -> {
            Mogram mogram = (Mogram)element;
            if (!mogram.is(Tag.Instance)) {
                return;
            }
            Mogram reference = mogram.components().stream().filter(Mogram::isReference).findFirst().orElse(null);
            if (reference != null) {
                GlobalConstraints.error("reject.reference.in.instance", mogram, Collections.emptyList());
            }
        };
    }

    private Constraint duplicatedInstances() {
        return element -> {
            Mogram mogram = (Mogram)element;
            if (!mogram.is(Tag.Instance) || mogram.isAnonymous()) {
                return;
            }
            List<Mogram> siblings = mogram.siblings();
            for (Mogram sibling : siblings) {
                if (!mogram.name().equals(sibling.name()) || !mogram.name().equals(sibling.file())) continue;
                GlobalConstraints.error("reject.duplicate.entries", mogram, Collections.singletonList(mogram.container().name()));
            }
        };
    }

    private Constraint duplicatedTags() {
        return element -> {
            Mogram mogram = (Mogram)element;
            HashSet<String> tags = new HashSet<String>();
            for (Tag annotation : mogram.annotations()) {
                if (tags.add(annotation.name())) continue;
                GlobalConstraints.error("reject.duplicate.annotation", mogram, Arrays.asList(new Serializable[]{annotation, mogram.type()}));
            }
            tags.clear();
            for (Tag flag : mogram.flags()) {
                if (tags.add(flag.name())) continue;
                GlobalConstraints.error("reject.duplicate.flag", mogram, Arrays.asList(new Serializable[]{flag, mogram.type() + " " + mogram.name()}));
            }
        };
    }

    private Constraint invalidNodeFlags() {
        return element -> {
            List<Tag> availableTags;
            Mogram mogram = (Mogram)element;
            if (mogram.flags().isEmpty()) {
                return;
            }
            if (mogram.isReference()) {
                return;
            }
            if (mogram.container() instanceof MogramRoot) {
                availableTags = new ArrayList<Tag>(Flags.forRoot());
                if (!mogram.isFacet()) {
                    availableTags.remove((Object)Tag.Required);
                }
            } else {
                availableTags = Flags.forComponent();
            }
            for (Tag tag : mogram.flags()) {
                if (this.isInternalFlag(tag) || availableTags.contains((Object)tag)) continue;
                GlobalConstraints.error("reject.invalid.flag", mogram, Arrays.asList(tag.name(), mogram.type()));
            }
        };
    }

    private boolean isInternalFlag(Tag tag) {
        return Flags.internalTags().contains((Object)tag);
    }

    private Constraint tagsCoherence() {
        return element -> {
            Mogram mogram = (Mogram)element;
            for (Tag tag : mogram.flags()) {
                this.checkFlagConstrains(tag.name(), mogram);
            }
            for (Tag tag : mogram.annotations()) {
                this.checkAnnotationConstrains(tag.name(), mogram);
            }
            if (mogram.isTerminal() && !mogram.annotations().isEmpty()) {
                GlobalConstraints.error("reject.annotations.in.terminal", mogram);
            }
        };
    }

    private void checkFlagConstrains(String flag, Mogram mogram) throws SemanticException {
        FlagChecker aClass = FlagCoherenceCheckerFactory.get(flag.toLowerCase());
        if (aClass != null) {
            aClass.check(mogram);
        }
    }

    private void checkAnnotationConstrains(String flag, Mogram mogram) throws SemanticException {
        FlagChecker aClass = AnnotationCoherenceCheckerFactory.get(flag.toLowerCase());
        if (aClass != null) {
            aClass.check(mogram);
        }
    }

    private Constraint checkVariables() {
        return element -> {
            Mogram mogram = (Mogram)element;
            this.checkDuplicatesBetween(mogram.components(), mogram.variables());
            this.checkDuplicates(mogram.variables());
            this.checkDuplicates(mogram.parameters());
            for (Variable variable : mogram.variables()) {
                this.checkVariable(variable);
            }
        };
    }

    private void checkDuplicatesBetween(List<Mogram> components, List<Variable> variables) throws SemanticException {
        if (variables == null) {
            return;
        }
        for (Variable var : variables) {
            if (!components.stream().anyMatch(c -> var.name() != null && var.name().equals(c.name()))) continue;
            GlobalConstraints.error("reject.duplicated.name.between.variables.and.components", var, Collections.singletonList(var.name()));
        }
    }

    private void checkDuplicates(List<? extends Valued> values) throws SemanticException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Valued valued : values) {
            if (valued.name() == null || valued.name().isEmpty() || names.add(valued.name())) continue;
            GlobalConstraints.error("reject.duplicated.valued", valued, Collections.singletonList(valued.getClass().getSimpleName().contains("Parameter") ? "parameter" : "variable"));
        }
    }

    private void checkVariable(Variable variable) throws SemanticException {
        List<Object> values = variable.values();
        if (variable.container().is(Tag.Instance)) {
            GlobalConstraints.error("reject.variable.in.node", variable);
        } else if (Primitive.WORD.equals((Object)variable.type()) && !values.isEmpty() && !this.hasCorrectValues(variable) && variable.rule() != null) {
            GlobalConstraints.error("reject.invalid.word.values", variable, Collections.singletonList(variable.rule().errorParameters()));
        } else if (Primitive.WORD.equals((Object)variable.type()) && variable.name().equals(variable.container().name())) {
            GlobalConstraints.error("reject.invalid.word.name", variable, Collections.singletonList(variable.rule().errorParameters()));
        } else if (Primitive.WORD.equals((Object)variable.type()) && variable.rule() instanceof WordRule && ((WordRule)variable.rule()).words().isEmpty()) {
            GlobalConstraints.error("reject.invalid.word.names", variable, Collections.emptyList());
        } else if (!(Primitive.WORD.equals((Object)variable.type()) || values.isEmpty() || this.compatibleTypes(variable))) {
            GlobalConstraints.error("reject.invalid.variable.type", variable, Collections.singletonList(variable.type().javaName()));
        } else if (Primitive.FUNCTION.equals((Object)variable.type()) && variable.rule() == null) {
            GlobalConstraints.error("reject.nonexistent.variable.rule", variable, Collections.singletonList(variable.type().javaName()));
        } else if (Primitive.REFERENCE.equals((Object)variable.type()) && !this.hasCorrectReferenceValues(variable)) {
            GlobalConstraints.error("reject.default.value.reference.variable", variable);
        } else if (Primitive.INSTANT.equals((Object)variable.type()) && !this.hasCorrectInstantValues(variable)) {
            GlobalConstraints.error("reject.value.instant.variable", variable);
        } else if (variable.isReference() && variable.targetOfReference() != null && variable.targetOfReference().is(Tag.Instance)) {
            GlobalConstraints.error("reject.default.value.reference.to.instance", variable);
        } else if (!variable.isReference() && this.isRedefiningTerminal(variable)) {
            GlobalConstraints.error("reject.terminal.variable.redefinition", variable);
        } else if (!values.isEmpty() && !variable.size().accept(values)) {
            GlobalConstraints.error("reject.element.not.in.range", variable, Arrays.asList(variable.size().min(), variable.size().max()));
        } else if (!(values.isEmpty() || values.get(0) instanceof EmptyMogram || variable.rule() == null || variable.rule() instanceof NativeRule || this.hasExpressionValue(values) || variable.rule().accept(values, variable.defaultMetric()))) {
            String message = variable.rule().errorMessage();
            GlobalConstraints.error(message == null || message.isEmpty() ? "custom.rule.class.not.comply" : message, variable, Collections.singletonList(variable.rule().errorParameters()));
        }
        this.checkVariableFlags(variable);
        if (variable.name() != null && Character.isUpperCase(variable.name().charAt(0))) {
            this.warning("warning.variable.name.starts.uppercase", variable);
        }
    }

    private boolean hasCorrectInstantValues(Variable variable) {
        return variable.values().stream().filter(v -> v != null && !(v instanceof Primitive.Expression)).noneMatch(o -> o.toString().isEmpty());
    }

    private boolean isRedefiningTerminal(Variable variable) {
        Language language = variable.language();
        if (language == null || variable.container() == null) {
            return false;
        }
        List<Constraint> constraints = language.constraints(variable.container().type());
        if (constraints == null) {
            return false;
        }
        Constraint constraint = constraints.stream().filter(c -> c instanceof Constraint.Parameter && ((Constraint.Parameter)c).name().equals(variable.name())).findFirst().orElse(null);
        return constraint != null && ((Constraint.Parameter)constraint).flags().contains((Object)Tag.Terminal);
    }

    private boolean hasCorrectReferenceValues(Variable variable) {
        for (Object value : variable.values()) {
            if (value instanceof EmptyMogram || this.hasInstanceValue(variable.values()) || this.hasExpressionValue(variable.values())) continue;
            return false;
        }
        return true;
    }

    private void checkVariableFlags(Variable variable) throws SemanticException {
        if (variable.flags().contains((Object)Tag.Private) && !variable.isInherited() && !this.isInAbstract(variable) && variable.values().isEmpty()) {
            GlobalConstraints.error("reject.private.variable.without.default.value", variable, Collections.singletonList(variable.name()));
        }
        if (variable.flags().contains((Object)Tag.Reactive) && variable.type().equals((Object)Primitive.FUNCTION)) {
            GlobalConstraints.error("reject.invalid.flag", variable, Arrays.asList(Tag.Reactive.name(), variable.name()));
        }
        if (!Primitive.WORD.equals((Object)variable.type()) && variable.flags().contains((Object)Tag.Reactive) && variable.rule() != null && variable.rule() instanceof VariableCustomRule) {
            if (variable.values().isEmpty() || this.hasExpressionValue(variable)) {
                GlobalConstraints.error("reject.reactive.variable.with.rules", variable, Arrays.asList(Tag.Reactive.name(), variable.name()));
            } else if (variable.rule() instanceof VariableCustomRule || !this.hasExpressionValue(variable)) {
                GlobalConstraints.error("reject.reactive.with.no.expression.value", variable, Arrays.asList(Tag.Reactive.name(), variable.name()));
            }
        }
        List<Tag> availableTags = Flags.forVariable();
        for (Tag tag : variable.flags()) {
            if (availableTags.contains((Object)tag)) continue;
            if (tag.equals((Object)Tag.Instance)) {
                GlobalConstraints.error("reject.variable.in.instance", variable, Collections.singletonList(variable.name()));
                continue;
            }
            GlobalConstraints.error("reject.invalid.flag", variable, Arrays.asList(tag.name(), variable.name()));
        }
        Variable parentVariable = this.findParentVariable(variable);
        if (parentVariable != null) {
            this.checkParentVariables(variable, parentVariable);
        }
    }

    private boolean hasExpressionValue(Variable variable) {
        return variable.values().get(0) instanceof Primitive.Expression || variable.values().get(0) instanceof Primitive.MethodReference;
    }

    private void checkParentVariables(Variable variable, Variable parentVariable) throws SemanticException {
        if (parentVariable.flags().contains((Object)Tag.Reactive) != variable.flags().contains((Object)Tag.Reactive)) {
            GlobalConstraints.error("reject.parent.variable.tags", variable);
        }
    }

    private Variable findParentVariable(Variable variable) {
        Mogram mogram = variable.container();
        if (mogram == null) {
            return null;
        }
        for (Mogram parent = mogram.parent(); parent != null; parent = parent.parent()) {
            for (Variable parentVar : parent.variables()) {
                if (!GlobalConstraints.isOverridden(variable, parentVar)) continue;
                return parentVar;
            }
        }
        return null;
    }

    private boolean isInAbstract(Variable variable) {
        return variable.container() != null && variable.container().isAbstract();
    }

    private boolean compatibleTypes(Variable variable) {
        Primitive inferredType = PrimitiveTypeCompatibility.inferType(variable.values().get(0));
        return inferredType != null && PrimitiveTypeCompatibility.checkCompatiblePrimitives(variable.isReference() ? Primitive.REFERENCE : variable.type(), inferredType, variable.isMultiple());
    }

    private boolean hasCorrectValues(Variable variable) {
        return variable.values().get(0) instanceof EmptyMogram || this.hasExpressionValue(variable.values()) || variable.rule() != null && variable.rule().accept(variable.values());
    }

    private boolean hasExpressionValue(List<Object> values) {
        return !values.isEmpty() && (values.get(0) instanceof Primitive.Expression || values.get(0) instanceof Primitive.MethodReference);
    }

    private boolean hasInstanceValue(List<Object> values) {
        return !values.isEmpty() && this.asPrimitiveReference(values) || this.asNode(values);
    }

    private boolean asNode(List<Object> values) {
        return values.get(0) instanceof Mogram && ((Mogram)values.get(0)).is(Tag.Instance);
    }

    private boolean asPrimitiveReference(List<Object> values) {
        return values.get(0) instanceof Primitive.Reference && ((Primitive.Reference)values.get(0)).reference().is(Tag.Instance);
    }

    private Constraint nodeName() {
        return element -> {
            Mogram mogram = (Mogram)element;
            mogram.resolve();
            if (!mogram.is(Tag.Instance) && mogram.isAnonymous()) {
                GlobalConstraints.error("concept.with.no.name", mogram);
            } else if (mogram.is(Tag.Instance)) {
                return;
            }
            if (mogram.container() != null && mogram.container() != null && !mogram.isReference() && !mogram.isAnonymous() && mogram.name().equals(mogram.container().name())) {
                GlobalConstraints.error("reject.container.and.component.namesake", mogram);
            }
        };
    }

    private Constraint duplicatedFacets() {
        return element -> {
            Mogram mogram = (Mogram)element;
            HashSet<String> facets = new HashSet<String>();
            for (Facet facet : mogram.appliedFacets()) {
                if (facets.add(facet.type())) continue;
                GlobalConstraints.error("reject.duplicated.facet", facet);
            }
        };
    }

    private void warning(String message, Element element) throws SemanticException {
        throw new SemanticException(new SemanticNotification(SemanticNotification.Level.WARNING, message, element));
    }
}

