/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.semantic;

import io.intino.tara.Checker;
import io.intino.tara.Resolver;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticFatalException;
import java.util.ArrayList;
import java.util.List;

public class SemanticAnalyzer {
    private final MogramRoot root;
    private final Resolver resolver;
    private Checker checker;
    private List<SemanticException> notifications;

    public SemanticAnalyzer(MogramRoot root) {
        this.root = root;
        this.resolver = new Resolver(root.language());
        this.checker = new Checker(root.language());
        this.notifications = new ArrayList<SemanticException>();
    }

    public void analyze() throws SemanticFatalException {
        this.resolveTypes(this.root);
        this.checkNode(this.root);
        if (!this.notifications.isEmpty()) {
            throw new SemanticFatalException(this.notifications);
        }
    }

    private void resolveTypes(Mogram mogram) {
        mogram.components().forEach(this::resolveNode);
    }

    private void check(Mogram mogram) {
        mogram.components().forEach(this::checkNode);
    }

    private void resolveNode(Mogram mogram) {
        this.resolver.resolve(mogram);
        if (!mogram.isReference()) {
            this.resolveTypes(mogram);
        }
    }

    private void checkNode(Mogram mogram) {
        block3: {
            try {
                this.checker.check(mogram);
                if (!mogram.isReference()) {
                    this.check(mogram);
                }
            }
            catch (SemanticFatalException e) {
                this.notifications.addAll(e.exceptions());
                if (this.hasFatal(e.exceptions()) || mogram.isReference()) break block3;
                this.check(mogram);
            }
        }
    }

    private boolean hasFatal(List<SemanticException> exceptions) {
        for (SemanticException exception : exceptions) {
            if (!exception.isFatal()) continue;
            return true;
        }
        return false;
    }
}

