/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.model;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.variable.VariableRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class VariableImpl
implements Variable {
    private static final Logger LOG = Logger.getGlobal();
    private final List<Object> defaultValues = new ArrayList<Object>();
    private final List<Tag> flags = new ArrayList<Tag>();
    private VariableRule rule;
    private Mogram container;
    private Primitive type;
    private String name;
    private String file;
    private int line;
    private int column;
    private String defaultExtension;
    private boolean inherited;
    private boolean overridden;
    private Size size = new Size(1, 1);
    private String uid;
    private final String scope;

    public VariableImpl(Mogram container, Primitive type, String name, String scope) {
        this.container = container;
        this.type = type;
        this.name = name;
        this.scope = scope;
    }

    @Override
    public Primitive type() {
        return this.type;
    }

    @Override
    public void type(Primitive type) {
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public Mogram container() {
        return this.container;
    }

    @Override
    public Mogram targetOfReference() {
        return null;
    }

    @Override
    public void container(Mogram container) {
        this.container = container;
    }

    @Override
    public List<Tag> flags() {
        return this.flags;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    @Override
    public boolean isTerminal() {
        return this.flags.contains((Object)Tag.Terminal);
    }

    @Override
    public boolean isFinal() {
        return this.flags.contains((Object)Tag.Final);
    }

    @Override
    public boolean isPrivate() {
        return this.flags.contains((Object)Tag.Private);
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    protected void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    @Override
    public boolean isMultiple() {
        return this.size().max() > 1;
    }

    @Override
    public Size size() {
        return this.size;
    }

    @Override
    public void size(Size size) {
        this.size = size;
    }

    @Override
    public VariableRule rule() {
        return this.rule;
    }

    @Override
    public void rule(VariableRule rule) {
        this.rule = rule;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public void values(List<Object> values) {
        this.defaultValues.clear();
        this.defaultValues.addAll(values);
    }

    @Override
    public List<Object> values() {
        return Collections.unmodifiableList(this.makeUp(this.model().resourcesRoot(), this.type(), this.defaultValues));
    }

    private MogramRoot model() {
        Mogram container = this.container();
        while (!(container instanceof MogramRoot)) {
            container = container.container();
        }
        return (MogramRoot)container;
    }

    @Override
    public String defaultMetric() {
        return this.defaultExtension;
    }

    @Override
    public void defaultMetric(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    @Override
    public String getUID() {
        if (this.uid == null) {
            this.uid = "" + Variable.NativeCounter.next(this.container(), this.name());
        }
        return this.uid;
    }

    @Override
    public String file() {
        return this.file;
    }

    @Override
    public void file(String file) {
        this.file = file;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void line(int line) {
        this.line = line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public void column(int column) {
        this.column = column;
    }

    public Variable clone() throws CloneNotSupportedException {
        super.clone();
        VariableImpl clone = new VariableImpl(this.container, this.type, this.name, this.scope);
        clone.file(this.file);
        clone.line(this.line());
        clone.column(this.column());
        clone.size(this.size());
        clone.defaultMetric(this.defaultExtension);
        clone.rule(this.rule);
        this.flags.forEach(xva$0 -> clone.addFlags((Tag)((Object)xva$0)));
        clone.values(this.defaultValues);
        clone.setInherited(true);
        return clone;
    }

    @Override
    public Variable cloneIt(Mogram container) {
        try {
            Variable clone = this.clone();
            clone.container(container);
            return clone;
        }
        catch (CloneNotSupportedException ignored) {
            LOG.severe("Error cloning variable: " + this.name());
            return null;
        }
    }

    public String toString() {
        return this.type + ":" + this.name;
    }

    @Override
    public boolean isOverridden() {
        return this.overridden;
    }

    @Override
    public void overriden(boolean overriden) {
        this.overridden = overriden;
    }
}

