/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.model;

import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MogramReference
implements Mogram {
    private Mogram container;
    private MogramImpl destination;
    private String reference;
    private String file;
    private int line;
    private String doc;
    private List<Tag> flags = new ArrayList<Tag>();
    private List<Tag> annotations = new ArrayList<Tag>();
    private List<String> uses = new ArrayList<String>();
    private boolean has;
    private String language;

    public MogramReference(String reference) {
        this.reference = reference;
    }

    public MogramReference(MogramImpl destination) {
        this.destination = destination;
        this.reference = destination.qualifiedName();
    }

    public String getReference() {
        return this.reference;
    }

    public MogramImpl destination() {
        return this.destination;
    }

    public void destination(MogramImpl destination) {
        this.destination = destination;
    }

    public String layerQualifiedName() {
        return ((MogramImpl)this.container).layerQualifiedName() + "$" + this.destination.name();
    }

    @Override
    public String name() {
        return this.destination != null ? this.destination.name() : "";
    }

    @Override
    public void name(String name) {
    }

    @Override
    public String file() {
        return this.file;
    }

    @Override
    public void file(String file) {
        this.file = file;
    }

    @Override
    public String languageName() {
        return this.language;
    }

    @Override
    public void languageName(String language) {
        this.language = language;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void line(int line) {
        this.line = line;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    @Override
    public void doc(String doc) {
        this.doc = doc;
    }

    @Override
    public boolean isSub() {
        return false;
    }

    public boolean isHas() {
        return this.has;
    }

    public void setHas(boolean has) {
        this.has = has;
    }

    @Override
    public List<Mogram> subs() {
        return Collections.unmodifiableList(this.destination.subs());
    }

    @Override
    public Mogram container() {
        return this.container;
    }

    @Override
    public List<String> uses() {
        return this.uses;
    }

    @Override
    public void container(Mogram container) {
        this.container = container;
    }

    @Override
    public boolean isTerminal() {
        return this.is(Tag.Terminal);
    }

    @Override
    public boolean isAbstract() {
        return this.is(Tag.Abstract);
    }

    @Override
    public boolean isFacet() {
        return this.destination.isFacet();
    }

    @Override
    public boolean isMetaFacet() {
        return this.destination.isMetaFacet();
    }

    @Override
    public boolean is(Tag tag) {
        return this.destination.is(tag) || this.flags().contains((Object)tag);
    }

    @Override
    public boolean into(Tag tag) {
        return this.destination.into(tag) || this.annotations().contains((Object)tag);
    }

    @Override
    public List<Tag> annotations() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.destination.annotations());
        this.annotations.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        return Collections.unmodifiableList(tags);
    }

    @Override
    public List<Tag> flags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.flags.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        if (this.isHas()) {
            tags.addAll(this.destination.flags());
        }
        return Collections.unmodifiableList(tags);
    }

    @Override
    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    @Override
    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    @Override
    public void addUses(List<String> uses) {
        this.uses.addAll(uses);
    }

    @Override
    public Mogram parent() {
        return null;
    }

    @Override
    public String parentName() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return this.destination.isAnonymous();
    }

    @Override
    public String qualifiedName() {
        return this.container.qualifiedName() + "." + this.destination.name();
    }

    @Override
    public String type() {
        return this.destination.type();
    }

    @Override
    public List<String> types() {
        return this.destination.types();
    }

    @Override
    public List<String> secondaryTypes() {
        return this.destination.secondaryTypes();
    }

    @Override
    public void type(String type) {
    }

    @Override
    public void stashNodeName(String name) {
    }

    @Override
    public Mogram resolve() {
        return this;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public List<Parameter> parameters() {
        return Collections.emptyList();
    }

    @Override
    public List<Mogram> siblings() {
        ArrayList<Mogram> components = new ArrayList<Mogram>(this.container.components());
        components.remove(this);
        return Collections.unmodifiableList(components);
    }

    @Override
    public List<Mogram> components() {
        return Collections.unmodifiableList(this.destination.components());
    }

    @Override
    public List<Rule> rulesOf(Mogram component) {
        return this.destination.rulesOf(component);
    }

    public boolean contains(Mogram mogramContainer) {
        return false;
    }

    @Override
    public List<Variable> variables() {
        return Collections.unmodifiableList(this.destination.variables());
    }

    @Override
    public List<Mogram> referenceComponents() {
        return Collections.unmodifiableList(this.destination.referenceComponents());
    }

    @Override
    public Mogram targetOfReference() {
        return this.destination;
    }

    @Override
    public List<Mogram> children() {
        return Collections.unmodifiableList(this.destination.children());
    }

    @Override
    public List<Facet> appliedFacets() {
        return Collections.unmodifiableList(this.destination.appliedFacets());
    }

    @Override
    public String toString() {
        return this.destination != null ? this.qualifiedName() : this.reference;
    }
}

