/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.dependencyresolution;

import io.intino.tara.Language;
import io.intino.tara.builder.core.errorcollection.DependencyException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.dependencyresolution.CustomRuleLoader;
import io.intino.tara.builder.dependencyresolution.ReferenceManager;
import io.intino.tara.builder.model.LanguageMogramReference;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Parametrized;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.CustomRule;
import io.intino.tara.language.model.rules.variable.ReferenceRule;
import io.intino.tara.language.model.rules.variable.VariableCustomRule;
import io.intino.tara.language.model.rules.variable.VariableRule;
import io.intino.tara.language.model.rules.variable.WordRule;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyResolver {
    private final File rulesDirectory;
    private final File semanticLib;
    private final File tempDirectory;
    private final Model model;
    private final ReferenceManager manager;
    private final Map<String, Class<?>> loadedRules = new HashMap();
    private final String workingPackage;
    private final List<DependencyException> rulesNotLoaded = new ArrayList<DependencyException>();

    public DependencyResolver(Model model, String workingPackage, File rulesDirectory, File semanticLib, File tempDirectory) {
        this.model = model;
        this.workingPackage = workingPackage;
        this.rulesDirectory = rulesDirectory;
        this.semanticLib = semanticLib;
        this.tempDirectory = tempDirectory;
        this.manager = new ReferenceManager(this.model);
    }

    public void resolve() throws DependencyException {
        this.resolveParentReference(this.model);
        this.resolveInNodes(this.model);
    }

    public List<DependencyException> rulesNotLoaded() {
        return this.rulesNotLoaded;
    }

    private void resolveParentReference(Mogram mogram) throws DependencyException {
        if (mogram instanceof MogramReference) {
            return;
        }
        this.resolveParent(mogram);
        for (Mogram component : mogram.components()) {
            this.resolveParentReference(component);
        }
    }

    private void resolveInNodes(Mogram mogram) throws DependencyException {
        this.resolveCustomRules(mogram);
        for (Mogram component : mogram.components()) {
            this.resolve(component);
        }
    }

    private void resolve(Mogram mogram) throws DependencyException {
        if (!(mogram instanceof MogramImpl)) {
            return;
        }
        this.resolveNodesReferences(mogram);
        this.resolveVariables(mogram);
        this.resolveParametersReference(mogram);
        this.resolveInNodes(mogram);
    }

    private void resolveCustomRules(Mogram mogram) throws DependencyException {
        if (mogram.container() == null) {
            return;
        }
        for (Rule rule : mogram.container().rulesOf(mogram)) {
            if (!(rule instanceof CustomRule)) continue;
            this.loadCustomRule(mogram, (CustomRule)((Object)rule));
        }
    }

    private void resolveParametersReference(Parametrized parametrized) throws DependencyException {
        for (Parameter parameter : parametrized.parameters()) {
            this.resolveParameterValue((Mogram)parametrized, parameter);
        }
    }

    private void resolveParameterValue(Mogram mogram, Parameter parameter) throws DependencyException {
        if (parameter.values().isEmpty() || !this.areReferenceValues(parameter)) {
            return;
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Object value : parameter.values()) {
            Mogram reference = this.resolveReferenceParameter(mogram, (Primitive.Reference)value);
            if (reference != null) {
                nodes.add(reference);
                continue;
            }
            if (!this.tryWithAnInstance((Primitive.Reference)value)) continue;
            nodes.add(value);
        }
        if (!nodes.isEmpty()) {
            parameter.type(Primitive.REFERENCE);
            parameter.substituteValues(nodes);
        }
    }

    private boolean tryWithAnInstance(Primitive.Reference value) {
        Language language = this.model.language();
        if (language != null && language.instances().containsKey(value.get())) {
            value.setToInstance(true);
            value.instanceTypes(language.instances().get(value.get()).types());
            value.path(language.instances().get(value.get()).path());
            return true;
        }
        return false;
    }

    private Mogram resolveReferenceParameter(Mogram mogram, Primitive.Reference value) throws DependencyException {
        return this.manager.resolveParameterReference(value, mogram);
    }

    private boolean areReferenceValues(Parameter parameter) {
        return parameter.values().get(0) instanceof Primitive.Reference;
    }

    private void resolveParent(Mogram mogram) throws DependencyException {
        if (mogram.parent() == null && mogram.parentName() != null) {
            Mogram parent = this.manager.resolveParent(mogram.parentName(), this.getNodeContainer(mogram.container()));
            if (parent == null) {
                throw new DependencyException("reject.dependency.parent.node.not.found", mogram, new String[0]);
            }
            ((MogramImpl)mogram).setParent(parent);
            parent.addChild(mogram);
        }
    }

    private void resolveNodesReferences(Mogram mogram) throws DependencyException {
        for (Mogram mogramReference : mogram.referenceComponents()) {
            this.resolveNodeReference((MogramReference)mogramReference);
            this.resolveCustomRules(mogramReference);
        }
    }

    private void resolveNodeReference(MogramReference nodeReference) throws DependencyException {
        if (nodeReference.destination() != null) {
            return;
        }
        MogramImpl destination = this.manager.resolve(nodeReference);
        if (destination == null) {
            throw new DependencyException("reject.dependency.reference.node.not.found", nodeReference, new String[0]);
        }
        nodeReference.destination(destination);
    }

    private void resolveVariables(Mogram container) throws DependencyException {
        for (Variable variable : container.variables()) {
            if (variable instanceof VariableReference) {
                this.resolveVariable((VariableReference)variable, container);
            }
            if (!(variable.rule() instanceof VariableCustomRule)) continue;
            this.loadCustomRule(variable);
        }
    }

    private void loadCustomRule(Variable variable) {
        VariableCustomRule rule = (VariableCustomRule)variable.rule();
        String source = rule.externalClass();
        File classFile = null;
        Class<?> aClass = null;
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : ((classFile = CustomRuleLoader.compile(rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory)) != null ? CustomRuleLoader.load(rule, this.workingPackage, this.semanticLib, this.tempDirectory) : CustomRuleLoader.tryAsProvided(rule));
        }
        catch (TaraException e) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", variable, rule.externalClass(), e.getMessage()));
            rule.qualifiedName(CustomRuleLoader.composeQualifiedName(this.workingPackage, rule.externalClass()));
        }
        if (aClass == null) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", variable, rule.externalClass()));
            return;
        }
        this.loadedRules.put(source, aClass);
        if (classFile != null) {
            this.model.addRule(source, this.tempDirectory);
        }
        if (variable.type().equals((Object)Primitive.WORD)) {
            this.updateRule(variable, aClass);
        } else {
            rule.setLoadedClass(aClass);
            rule.classFile(classFile);
        }
    }

    private void loadCustomRule(Mogram mogram, CustomRule rule) throws DependencyException {
        Class<?> aClass;
        String source = rule.externalClass();
        File classFile = null;
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : ((classFile = CustomRuleLoader.compile(rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory)) != null ? CustomRuleLoader.load(rule, this.workingPackage, this.semanticLib, this.tempDirectory) : CustomRuleLoader.tryAsProvided(rule));
        }
        catch (TaraException e) {
            throw new DependencyException("impossible.load.rule.class", mogram, rule.externalClass(), e.getMessage().split("\n")[0]);
        }
        if (aClass != null) {
            this.loadedRules.put(source, aClass);
            if (classFile != null) {
                this.model.addRule(source, this.tempDirectory);
            }
            rule.setLoadedClass(aClass);
            rule.classFile(classFile);
        }
    }

    private void updateRule(Variable variable, Class<?> aClass) {
        if (aClass != null) {
            variable.rule((VariableRule)new WordRule(this.collectEnums(Arrays.asList(aClass.getDeclaredFields())), aClass.getSimpleName()));
        }
    }

    private List<String> collectEnums(List<Field> fields) {
        return fields.stream().filter(Field::isEnumConstant).map(Field::getName).collect(Collectors.toList());
    }

    private void resolveVariable(VariableReference variable, Mogram container) throws DependencyException {
        MogramImpl target = this.manager.resolve(variable, container);
        if (target != null) {
            variable.setTarget(target);
        } else if (!this.tryAsLanguageReference(variable)) {
            throw new DependencyException("reject.reference.variable.not.found", container, variable.targetName());
        }
        variable.rule((VariableRule)this.createReferenceRule(variable));
        this.resolveVariableDefaultValue(variable, container);
    }

    private void resolveVariableDefaultValue(VariableReference variable, Mogram container) throws DependencyException {
        if (variable.values().isEmpty() || !(variable.values().get(0) instanceof Primitive.Reference)) {
            return;
        }
        List collect = variable.values().stream().map(v -> (Primitive.Reference)v).collect(Collectors.toList());
        for (Primitive.Reference v2 : collect) {
            Mogram target = this.manager.resolve(v2.get(), container);
            if (target == null) {
                throw new DependencyException("reject.reference.variable.not.found", container, variable.targetName());
            }
            v2.reference(target);
        }
    }

    private boolean tryAsLanguageReference(VariableReference variable) {
        Language language = this.model.language();
        if (language == null) {
            return false;
        }
        List<String> types = language.types(variable.targetName());
        if (types != null) {
            variable.setTypeReference();
            variable.setTarget(new LanguageMogramReference(types, variable.targetName()));
            return true;
        }
        return false;
    }

    private ReferenceRule createReferenceRule(VariableReference variable) {
        return new ReferenceRule(this.collectTypes(variable.targetOfReference()));
    }

    private Set<String> collectTypes(Mogram mogram) {
        HashSet<String> set = new HashSet<String>();
        if (!mogram.isAbstract()) {
            set.add(mogram.qualifiedName());
        }
        for (Mogram child : mogram.children()) {
            set.addAll(this.collectTypes(child));
        }
        return set;
    }

    private Mogram getNodeContainer(MogramContainer reference) {
        MogramContainer container = reference;
        while (!(container instanceof MogramImpl) && container.container() != null) {
            container = container.container();
        }
        return (Mogram)container;
    }
}

