/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.model;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.ToNativeTransformerTemplate;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.parser.NativeExtractor;
import io.intino.tara.builder.utils.FileSystemUtils;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.EmptyMogram;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Parametrized;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Valued;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.variable.NativeRule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeTransformationOperation
extends ModelOperation {
    private final File resources;
    private final List<File> sources;

    public NativeTransformationOperation(CompilationUnit unit) {
        super(unit);
        this.resources = unit.configuration().resourcesDirectory();
        this.sources = unit.configuration().sourceDirectories();
    }

    @Override
    public void call(Model model) throws CompilationFailedException {
        for (Parameter parameter : this.findReactiveParameters(model)) {
            parameter.substituteValues(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformValueToExpression(parameter))));
        }
        for (Variable variable : this.findReactiveVariables(model)) {
            variable.values(new ArrayList<Object>(Collections.singletonList(this.transformValueToExpression(variable))));
        }
        for (Valued valued : this.findMethodReferences(model)) {
            valued.values(new ArrayList<Object>(Collections.singletonList(this.transformMethodReference(valued, new File(valued.file()).getName()))));
        }
    }

    private Primitive.Expression transformMethodReference(Valued v, String fileName) {
        return new Primitive.Expression(this.wrapMethodReference(v, fileName));
    }

    private String wrapMethodReference(Valued v, String fileName) {
        List<Object> value = v.values();
        return this.transformMethodReference(v.file(), (NativeRule)v.rule(), (Primitive.MethodReference)value.get(0), fileName);
    }

    private Primitive.Expression transformValueToExpression(Valued v) {
        return new Primitive.Expression(this.wrap(v));
    }

    private String wrap(Valued v) {
        if (v.values().get(0) instanceof EmptyMogram) {
            return "null";
        }
        List result = v.values().stream().map(value -> this.wrapValue(v, value)).collect(Collectors.toList());
        return v.isMultiple() ? "java.util.Arrays.asList(" + String.join((CharSequence)", ", result) + ")" : (String)result.get(0);
    }

    private String wrapValue(Valued v, Object value) {
        Template template = new ToNativeTransformerTemplate().add("url", url -> url.toString().substring(this.resources.getAbsolutePath().length() + 1));
        FrameBuilder builder = new FrameBuilder(v.type().name(), "native");
        String toAdd = value.toString();
        if (value instanceof File) {
            toAdd = ((File)value).getAbsolutePath().replace("\\", "/");
        }
        builder.add("value", toAdd);
        return template.render((Object)builder.toFrame());
    }

    private String transformMethodReference(String file, NativeRule rule, Primitive.MethodReference value, String fileName) {
        String parameters = rule == null ? "" : this.namesOf(new NativeExtractor(rule.signature()).parameters());
        String packageOf = this.packageOf(new File(file).getParent());
        return (String)(!packageOf.isEmpty() ? packageOf + "." : "") + Format.javaValidName().format(FileSystemUtils.getNameWithoutExtension(fileName)).toString() + "." + value.target() + "(self" + (String)(parameters.isEmpty() ? "" : ", " + parameters) + ");";
    }

    private String packageOf(String path) {
        File file = this.selectSource(path);
        if (file == null) {
            return "";
        }
        String replace = path.replace(file.getAbsolutePath(), "");
        return replace.isEmpty() ? "" : replace.substring(1).replace(File.separator, ".");
    }

    private File selectSource(String file) {
        if (this.sources.isEmpty()) {
            return null;
        }
        for (File source : this.sources) {
            if (!file.startsWith(source.getAbsolutePath())) continue;
            return source;
        }
        return this.sources.get(0);
    }

    private String namesOf(String parameters) {
        return Format.nativeParameterWithoutType().format(parameters).toString();
    }

    private Set<Parameter> findReactiveParameters(Parametrized parametrized) {
        Set<Parameter> parameters = parametrized.parameters().stream().filter(p -> p.flags().contains((Object)Tag.Reactive) && !(p.values().get(0) instanceof Primitive.Expression) && !(p.values().get(0) instanceof Primitive.MethodReference)).collect(Collectors.toSet());
        if (parametrized instanceof Mogram && !((Mogram)parametrized).isReference()) {
            ((Mogram)parametrized).components().forEach(n -> parameters.addAll(this.findReactiveParameters((Parametrized)n)));
        }
        return parameters;
    }

    private Set<Variable> findReactiveVariables(MogramContainer node) {
        HashSet<Variable> parameters = new HashSet<Variable>();
        for (Mogram component : node.components()) {
            parameters.addAll(component.variables().stream().filter(v -> v.flags().contains((Object)Tag.Reactive) && !v.values().isEmpty() && !(v.values().get(0) instanceof Primitive.Expression) && !(v.values().get(0) instanceof Primitive.MethodReference)).collect(Collectors.toList()));
            if (component.isReference()) continue;
            parameters.addAll(this.findReactiveVariables(component));
        }
        return parameters;
    }

    private Set<Valued> findMethodReferences(Mogram mogram) {
        HashSet<Valued> valued = new HashSet<Valued>();
        valued.addAll(mogram.variables().stream().filter(v -> !v.values().isEmpty() && v.values().get(0) instanceof Primitive.MethodReference).collect(Collectors.toList()));
        valued.addAll(mogram.parameters().stream().filter(v -> !v.values().isEmpty() && v.values().get(0) instanceof Primitive.MethodReference).collect(Collectors.toList()));
        if (!mogram.isReference()) {
            for (Mogram component : mogram.components()) {
                valued.addAll(this.findMethodReferences(component));
            }
        }
        return valued;
    }
}

