/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.model;

import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.errorcollection.DependencyException;
import io.intino.tara.builder.core.errorcollection.message.DependencyErrorMessage;
import io.intino.tara.builder.core.errorcollection.message.WarningMessage;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.dependencyresolution.DependencyResolver;
import io.intino.tara.builder.dependencyresolution.InheritanceResolver;
import io.intino.tara.builder.dependencyresolution.NativeResolver;
import io.intino.tara.builder.dependencyresolution.TerminalResolver;
import io.intino.tara.builder.model.Model;
import io.intino.tara.language.model.Element;
import java.util.Collection;
import java.util.logging.Logger;

public class ModelDependencyResolutionOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getGlobal();

    public ModelDependencyResolutionOperation(CompilationUnit unit) {
        super(unit);
    }

    @Override
    public void call(Model model) {
        try {
            CompilerConfiguration conf = this.unit.configuration();
            if (conf.isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:[" + conf.getModule() + " - " + conf.model().outDsl() + "] Resolving dependencies...");
            }
            DependencyResolver dependencyResolver = new DependencyResolver(model, conf.workingPackage(), conf.rulesDirectory(), conf.getSemanticRulesLib(), conf.getTempDirectory());
            dependencyResolver.resolve();
            this.notifyRulesNotLoaded(dependencyResolver);
            new InheritanceResolver(model).resolve();
            new TerminalResolver(model, conf.model().level()).resolve();
            new NativeResolver(model, conf.functionsDirectory()).resolve();
        }
        catch (DependencyException e) {
            LOG.severe("Error during dependency resolution: " + e.getMessage());
            this.unit.getErrorCollector().addError(DependencyErrorMessage.create(e, this.unit.getSourceUnits().get(e.getElement().file())), true);
        }
    }

    private void notifyRulesNotLoaded(DependencyResolver dependencyResolver) {
        for (DependencyException entry : dependencyResolver.rulesNotLoaded()) {
            SourceUnit sourceFromFile = this.getSourceFromFile(this.unit.getSourceUnits().values(), entry.getElement());
            this.unit.getErrorCollector().addWarning(new WarningMessage(3, entry.getMessage(), sourceFromFile, entry.getLine(), entry.getElement().column()));
        }
    }

    private SourceUnit getSourceFromFile(Collection<SourceUnit> values, Element origin) {
        if (origin == null) {
            return null;
        }
        for (SourceUnit value : values) {
            if (!value.getName().equals(origin.file())) continue;
            return value;
        }
        return null;
    }
}

