/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.FrameBuilder;
import io.intino.tara.builder.codegeneration.language.LanguageCreator;
import io.intino.tara.builder.codegeneration.language.POMTemplate;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.utils.FileSystemUtils;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.builder.utils.JavaCompiler;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.Context;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LanguageSerializer {
    private static final Logger LOG = Logger.getGlobal();
    private static final String JAVA = ".java";
    private static final String JAR = ".jar";
    private static final String TARA_LANG_PACKAGE = "tara.lang";
    private final CompilerConfiguration conf;
    private final Collection<Model> models;

    public LanguageSerializer(CompilerConfiguration conf, Collection<Model> models) {
        this.conf = conf;
        this.models = models;
    }

    public void serialize() throws TaraException {
        this.serialize(new LanguageCreator(this.conf, this.models).create(), this.getDslDestination(), this.collectRules(this.models));
    }

    private List<File> collectRules(Collection<Model> models) {
        HashSet<File> classes = new HashSet<File>();
        for (Model model : models) {
            classes.addAll(this.filesOf(model));
            classes.addAll(this.collectLanguageRules(model));
        }
        return new ArrayList<File>(classes);
    }

    private Collection<File> filesOf(Model model) {
        return model.rules().values();
    }

    private List<File> collectLanguageRules(Model model) {
        return model.language().catalog().values().stream().flatMap(context -> this.getRulesOfNode((Context)context).stream().map(c -> new File(c.getProtectionDomain().getCodeSource().getLocation().getPath())).distinct()).collect(Collectors.toList());
    }

    private List<Class<?>> getRulesOfNode(Context context) {
        return context.constraints().stream().filter(constraint -> constraint instanceof Constraint.Parameter && ((Constraint.Parameter)constraint).rule() != null && !((Constraint.Parameter)constraint).rule().getClass().getName().startsWith(TARA_LANG_PACKAGE)).map(constraint -> ((Constraint.Parameter)constraint).rule().getClass()).collect(Collectors.toList());
    }

    private File getDslDestination() {
        File file = new File(this.conf.languagesRepository(), this.conf.dslGroupId().replace(".", File.separator) + File.separator + this.conf.model().outDsl().toLowerCase() + File.separator + (this.conf.version() == null ? "1.0.0" : this.conf.version()));
        file.mkdirs();
        return new File(file, Format.reference().format(Format.firstUpperCase().format(this.conf.model().outDsl())) + JAVA);
    }

    private void serialize(String content, File javaFile, List<File> rules) throws TaraException {
        try {
            File dslDirectory = javaFile.getParentFile();
            if (dslDirectory.exists()) {
                FileSystemUtils.removeDir(dslDirectory);
            }
            dslDirectory.mkdirs();
            Files.write(javaFile.toPath(), content.getBytes(), new OpenOption[0]);
            JavaCompiler.compile(javaFile, String.join((CharSequence)File.pathSeparator, this.collectClassPath(rules)), this.getDslDestination().getParentFile());
            this.jar(dslDirectory, rules.stream().filter(v -> !v.getName().startsWith(TARA_LANG_PACKAGE)).collect(Collectors.toList()));
            this.createPOM(dslDirectory);
        }
        catch (IOException e) {
            throw new TaraException("Error creating languageName: " + e.getMessage(), e);
        }
    }

    private void createPOM(File dslDirectory) throws IOException {
        String text = new POMTemplate().render(new FrameBuilder().add("POM").add("name", this.conf.model().outDsl()).add("version", this.conf.version()));
        Files.write(new File(this.jarFile(dslDirectory).getAbsolutePath().replace(JAR, ".pom")).toPath(), text.getBytes(), new OpenOption[0]);
    }

    private Collection<String> collectClassPath(Collection<File> values) throws IOException {
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.add(this.conf.getSemanticRulesLib().getAbsolutePath());
        for (Model model : this.models) {
            try {
                dependencies.add(Paths.get(model.language().getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toFile().getCanonicalPath().replaceAll("%20", " "));
                dependencies.addAll(values.stream().filter(v -> !v.getName().startsWith(TARA_LANG_PACKAGE)).map(File::getPath).toList());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return dependencies;
    }

    private void jar(File dslDir, List<File> rules) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, this.conf.version());
        manifest.getEntries().put("tara", this.createTaraProperties());
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(this.jarFile(dslDir)), manifest);
        File src = new File(dslDir, "tara");
        this.add(dslDir, src, target);
        this.addRules(rules, target);
        this.addInheritedRules(target);
        target.close();
        FileSystemUtils.removeDir(src);
    }

    private File jarFile(File dslDir) {
        return new File(dslDir, this.conf.model().outDsl() + "-" + this.conf.version() + JAR);
    }

    private Attributes createTaraProperties() {
        Attributes taraAttributes = new Attributes();
        taraAttributes.put(new Attributes.Name("groupId"), this.conf.groupId());
        taraAttributes.put(new Attributes.Name("artifactId"), this.conf.artifactId());
        taraAttributes.put(new Attributes.Name("version"), this.conf.version());
        taraAttributes.put(new Attributes.Name("level"), this.descendantLevel(this.conf.model().level()).name());
        taraAttributes.put(new Attributes.Name(this.normalize("out.dsl")), this.conf.model().outDsl());
        taraAttributes.put(new Attributes.Name(this.normalize("builder.groupId")), this.conf.dslBuilder().groupId());
        taraAttributes.put(new Attributes.Name(this.normalize("builder.artifactId")), this.conf.dslBuilder().artifactId());
        taraAttributes.put(new Attributes.Name(this.normalize("builder.version")), this.conf.dslBuilder().version());
        taraAttributes.put(new Attributes.Name(this.normalize("runtime.groupId")), this.conf.runtime().groupId());
        taraAttributes.put(new Attributes.Name(this.normalize("runtime.artifactId")), this.conf.runtime().artifactId());
        taraAttributes.put(new Attributes.Name(this.normalize("runtime.version")), this.conf.runtime().version());
        taraAttributes.put(new Attributes.Name(this.normalize("generation.package")), this.conf.workingPackage());
        return taraAttributes;
    }

    private CompilerConfiguration.Level descendantLevel(CompilerConfiguration.Level level) {
        return CompilerConfiguration.Level.values()[level.ordinal() - 1];
    }

    private String normalize(String tag) {
        return tag.replace(".", "-");
    }

    private void addInheritedRules(JarOutputStream target) {
        for (Model model : this.models) {
            File tempDirectory = this.conf.getTempDirectory();
            this.conf.cleanTemp();
            FileSystemUtils.extractJar(model.language().getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), tempDirectory);
            File[] languageDirectories = this.languageDirectory(tempDirectory);
            ArrayList<File> rules = new ArrayList<File>();
            for (File d : languageDirectories) {
                FileSystemUtils.getAllFiles(d, rules);
            }
            rules.stream().filter(f -> f.getName().endsWith(".class")).forEach(r -> {
                try {
                    this.add(this.conf.getTempDirectory(), (File)r, target);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            });
        }
    }

    private File[] languageDirectory(File tempDirectory) {
        return tempDirectory.listFiles(file -> file.isDirectory() && !file.getName().equals("META-INF") && !file.getName().equals("tara"));
    }

    private void addRules(List<File> rules, JarOutputStream target) throws IOException {
        HashMap<File, String> ruleFiles = new HashMap<File, String>();
        for (File file : rules) {
            ArrayList<File> files = new ArrayList<File>();
            FileSystemUtils.getAllFiles(file, files);
            for (File file2 : files) {
                ruleFiles.put(file2, file.getAbsolutePath());
            }
        }
        for (Map.Entry entry : ruleFiles.entrySet()) {
            this.add(new File((String)entry.getValue()), (File)entry.getKey(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(File base, File source, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            if (source.isDirectory()) {
                this.createDirectory(base, source, target);
                return;
            }
            JarEntry entry = new JarEntry(this.getRelativePath(base, source).replace("\\", "/"));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = this.writeEntry(source, target);
            target.closeEntry();
        }
    }

    private BufferedInputStream writeEntry(File source, OutputStream target) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        FileSystemUtils.writeBuffer(in, target);
        return in;
    }

    private void createDirectory(File base, File source, JarOutputStream target) throws IOException {
        String name = this.getRelativePath(base, source).replace("\\", "/");
        if (!name.isEmpty()) {
            this.createEntry(source, target, name);
        }
        for (File nestedFile : Objects.requireNonNull(source.listFiles())) {
            this.add(base, nestedFile, target);
        }
    }

    private void createEntry(File source, JarOutputStream target, String name) throws IOException {
        if (!((String)name).endsWith("/")) {
            name = (String)name + "/";
        }
        JarEntry entry = new JarEntry((String)name);
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        target.closeEntry();
    }

    private String getRelativePath(File base, File source) {
        return source.getPath().replace(base.getAbsolutePath() + File.separator, "");
    }
}

