/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.adapters.ExcludeAdapter;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.TemplateTags;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.variable.NativeRule;
import io.intino.tara.language.model.rules.variable.VariableCustomRule;
import io.intino.tara.language.model.rules.variable.VariableRule;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class LanguageParameterAdapter
implements TemplateTags {
    private final Language language;
    private final String workingPackage;
    private final CompilerConfiguration.Level level;

    LanguageParameterAdapter(Language language, String workingPackage, CompilerConfiguration.Level level) {
        this.language = language;
        this.workingPackage = workingPackage;
        this.level = level;
    }

    static int terminalParameters(Language language, Mogram mogram) {
        int index = 0;
        List<Constraint> constraints = language.constraints(mogram.type());
        if (constraints == null) {
            return 0;
        }
        for (Constraint c : constraints) {
            if (!LanguageParameterAdapter.isSuitableParameter(mogram, c)) continue;
            ++index;
        }
        return index;
    }

    private static boolean isSuitableParameter(Mogram mogram, Constraint c) {
        return c instanceof Constraint.Parameter && LanguageParameterAdapter.isTerminal((Constraint.Parameter)c) && !LanguageParameterAdapter.isRedefined((Constraint.Parameter)c, mogram.variables()) && !LanguageParameterAdapter.isRequired((Constraint.Parameter)c) && !LanguageParameterAdapter.isFilled(mogram, (Constraint.Parameter)c);
    }

    private static boolean isTerminal(Constraint.Parameter constraint) {
        for (Tag flag : constraint.flags()) {
            if (!flag.equals((Object)Tag.Terminal)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRequired(Constraint.Parameter constraint) {
        return constraint.size().isRequired();
    }

    private static boolean isRedefined(Constraint.Parameter constraint, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(constraint.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFilled(Mogram mogram, Constraint.Parameter constraint) {
        for (Parameter parameter : mogram.parameters()) {
            if (!parameter.name().equals(constraint.name()) || constraint.size() != null && !constraint.size().accept(parameter.values())) continue;
            return true;
        }
        return false;
    }

    void addParameterConstraint(FrameBuilder frame, String facet, int position, Variable variable, String relation) {
        if (variable instanceof VariableReference) {
            frame.add(relation, this.referenceParameter(position, facet, variable, relation));
        } else {
            frame.add(relation, this.primitiveParameter(position, facet, variable, relation));
        }
    }

    int addTerminalParameterConstraints(Mogram mogram, FrameBuilder constraintsFrame) {
        int index = 0;
        List<Constraint> constraints = this.language.constraints(mogram.type());
        if (constraints == null) {
            return 0;
        }
        for (Constraint c : constraints) {
            if (!LanguageParameterAdapter.isSuitableParameter(mogram, c)) continue;
            this.addTerminalParameter(constraintsFrame, (Constraint.Parameter)c, index, "constraint");
            ++index;
        }
        return index;
    }

    private void addTerminalParameter(FrameBuilder builder, Constraint.Parameter parameter, int position, String type) {
        if (parameter instanceof ReferenceParameter) {
            builder.add(type, this.referenceParameter((ReferenceParameter)parameter, position, type));
        } else {
            builder.add(type, this.primitiveParameter(parameter, position, type));
        }
    }

    private void addDefaultInfo(int position, Variable variable, FrameBuilder frame) {
        FrameBuilder ruleFrame;
        Frame rule;
        frame.add("position", position);
        frame.add("tags", this.getFlags(variable));
        frame.add("scope", this.workingPackage);
        frame.add("size", this.isTerminal(variable) ? this.transformSizeRuleOfTerminalNode(variable) : new FrameBuilder().append(variable.size()).toFrame());
        Frame frame2 = rule = variable.rule() == null || variable.rule() instanceof VariableCustomRule && ((VariableCustomRule)variable.rule()).loadedClass() == null ? null : this.ruleToFrame(variable.rule()).toFrame();
        if (rule != null) {
            frame.add("rule", rule);
        } else if (variable.flags().contains((Object)Tag.Reactive) && (ruleFrame = this.ruleToFrame(new NativeRule("", "", Collections.emptyList()))) != null) {
            frame.add("rule", ruleFrame.toFrame());
        }
    }

    protected FrameBuilder ruleToFrame(Rule rule) {
        if (rule == null) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder();
        builder.put(Rule.class, new ExcludeAdapter("loadedClass"));
        builder.append(rule);
        if (rule instanceof VariableCustomRule) {
            FrameBuilder frameBuilder = new FrameBuilder("customRule");
            frameBuilder.add("qn", LanguageParameterAdapter.cleanQn(((VariableCustomRule)rule).qualifiedName()));
            frameBuilder.add("aClass", LanguageParameterAdapter.cleanQn(((VariableCustomRule)rule).externalClass()));
            if (((VariableCustomRule)rule).isMetric()) {
                frameBuilder.add("metric");
                frameBuilder.add("default", ((VariableCustomRule)rule).getDefaultUnit());
            }
            return frameBuilder;
        }
        return builder;
    }

    public static String cleanQn(String qualifiedName) {
        return qualifiedName.replace("anonymous@", "").replace("[", "").replace("]", "").replace(":", "").replace("$", ".");
    }

    private boolean isTerminal(Variable variable) {
        return variable.isTerminal() && !variable.container().isTerminal() && CompilerConfiguration.Level.MetaModel.compareLevelWith(this.level) > 0;
    }

    private Frame transformSizeRuleOfTerminalNode(Variable variable) {
        Size rule = variable.size();
        Size size = new Size(0, rule.max(), rule);
        return new FrameBuilder().append(size).toFrame();
    }

    private Frame referenceParameter(int i, String facet, Variable variable, String relation) {
        FrameBuilder builder = new FrameBuilder(relation, "parameter", "reference").add("name", variable.name()).add("facet", facet).add("type", variable.targetOfReference().qualifiedName());
        this.addDefaultInfo(i, variable, builder);
        return builder.toFrame();
    }

    private Frame primitiveParameter(int i, String facet, Variable variable, String relation) {
        FrameBuilder builder = new FrameBuilder(relation, "parameter").add("name", variable.name()).add("facet", facet).add("type", (Object)variable.type());
        this.addDefaultInfo(i, variable, builder);
        return builder.toFrame();
    }

    private Frame referenceParameter(ReferenceParameter parameter, int position, String type) {
        FrameBuilder builder = new FrameBuilder(type, "parameter", "reference").add("name", parameter.name()).add("facet", parameter.facet());
        this.addDefaultInfo(parameter, builder, position);
        return builder.toFrame();
    }

    private Frame primitiveParameter(Constraint.Parameter parameter, int position, String type) {
        FrameBuilder builder = new FrameBuilder(type, "parameter").add("facet", parameter.facet()).add("name", parameter.name()).add("type", (Object)parameter.type());
        this.addDefaultInfo(parameter, builder, position);
        return builder.toFrame();
    }

    private void addDefaultInfo(Constraint.Parameter parameter, FrameBuilder frame, int position) {
        frame.add("size", new FrameBuilder().append(new Size(1, parameter.size().max())).toFrame());
        frame.add("position", position);
        frame.add("tags", this.getFlags(parameter));
        Frame rule = this.calculateRule(parameter);
        if (rule != null) {
            frame.add("rule", rule);
        }
    }

    private Frame calculateRule(Constraint.Parameter parameter) {
        VariableRule rule = parameter.rule();
        if (rule == null) {
            return null;
        }
        FrameBuilder builder = this.ruleToFrame(rule);
        return builder.add(parameter.type().getName()).toFrame();
    }

    private String[] getFlags(Variable variable) {
        return (String[])variable.flags().stream().map(Enum::name).toArray(String[]::new);
    }

    private String[] getFlags(Constraint.Parameter variable) {
        ArrayList<Tag> flags = new ArrayList<Tag>();
        for (Tag tag : variable.flags()) {
            if (tag.equals((Object)Tag.Terminal)) {
                flags.add(Tag.Instance);
                continue;
            }
            flags.add(tag);
        }
        return (String[])flags.stream().map(Enum::name).toArray(String[]::new);
    }
}

