/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder;

import io.intino.tara.builder.TaraCompilerRunner;
import io.intino.tara.builder.core.CompilerConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Tarac {
    public static void main(String[] args) {
        if (args[0].equals("--help")) {
            System.out.println(Tarac.help());
            return;
        }
        TaraCompilerRunner runner = new TaraCompilerRunner(false, Collections.emptyList());
        runner.run(Tarac.loadConfiguration(args), Tarac.sourcesFrom(args));
    }

    private static String help() {
        return "Usage: tarac <options> <source files>\nwhere possible options include:\n  --level <level>         \t\tREQUIRED. Specify the abstraction level in MDE: model (1), meta-model (2), meta-meta-model (3)\n  --dsl <name:version> \t\t\tREQUIRED. Specify the name and version of the language used for define models\n  --out-dsl <name:version>      REQUIRED. Specify the name and version of the language created. Not necessary if level is model\n  --dsl-repository <directory>  Specify the directory where the where the language will be found and out language will be created. Used '~/.m2/repository' as default\n  --encoding <encoding>         Specify character encoding used by source files. UTF-8 is used by default\n";
    }

    private static Map<File, Boolean> sourcesFrom(String[] args) {
        return Arrays.stream(args).dropWhile(a -> a.startsWith("-")).map(File::new).collect(Collectors.toMap(f -> f, f -> true, (a, b) -> b, LinkedHashMap::new));
    }

    private static CompilerConfiguration loadConfiguration(String[] args) {
        Map<String, String> arguments = Arrays.stream(args).takeWhile(a -> a.startsWith("-")).map(a -> a.split(" ")).collect(Collectors.toMap(a -> a[0].replace("-", ""), a -> a[1]));
        CompilerConfiguration conf = new CompilerConfiguration();
        arguments.keySet().forEach(name -> Tarac.processArg(conf, name, (String)arguments.get(name)));
        return conf;
    }

    private static void processArg(CompilerConfiguration conf, String name, String value) {
        switch (name) {
            case "dslrepository": {
                conf.languagesRepository(new File(value));
                break;
            }
            case "outdsl": {
                String[] dsl = value.trim().split(":");
                conf.model().outDsl(dsl[0]);
                conf.version(dsl[1]);
                if (conf.getModule() == null) {
                    conf.setModule(dsl[0]);
                }
                if (conf.workingPackage() != null) break;
                conf.workingPackage(dsl[0]);
                break;
            }
            case "encoding": {
                conf.sourceEncoding(value);
                break;
            }
            case "level": {
                conf.model().level(CompilerConfiguration.Level.values()[Integer.parseInt(value) - 1]);
                break;
            }
            case "dsl": {
                String[] aDsl = value.trim().split(":");
                conf.language(aDsl[0], aDsl[1]);
                break;
            }
        }
    }
}

