/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework.utils;

import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.PersistenceManager;
import io.intino.magritte.framework.Predicate;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.FileSystemStore;
import io.intino.magritte.io.model.Stash;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StoreAuditor {
    private static final String CHECKSUM_FILE = ".checksum";
    private final Store store;
    private final Map<String, String> oldChecksums;
    private final PersistenceManager manager;
    private final String checksumName;
    private Map<String, String> newChecksums = new HashMap<String, String>();
    private Map<String, Action> changeMap;

    public StoreAuditor(Store store) {
        this(store, StoreAuditor.defaultPersistenceManager(store), CHECKSUM_FILE);
    }

    public StoreAuditor(Store store, String checksumName) {
        this(store, StoreAuditor.defaultPersistenceManager(store), checksumName);
    }

    public StoreAuditor(Store fileSystemStore, PersistenceManager manager, String checksumName) {
        this.manager = manager;
        this.checksumName = checksumName;
        this.store = fileSystemStore;
        this.oldChecksums = this.readOldChecksums();
    }

    private static PersistenceManager defaultPersistenceManager(Store store) {
        return store instanceof FileSystemStore ? new PersistenceManager.FilePersistenceManager(((FileSystemStore)store).directory()) : new PersistenceManager.InMemoryPersistenceManager();
    }

    private static String calculateChecksum(io.intino.magritte.io.model.Node node) {
        return "" + node.hashCode();
    }

    private static boolean isUUID(String str) {
        return str.length() == 36 && str.charAt(8) == '-' && str.charAt(13) == '-' && str.charAt(18) == '-' && str.charAt(23) == '-';
    }

    public void removeTrack(String nodeId) {
        Map.Entry entry = this.oldChecksums.entrySet().stream().filter(e -> ((String)e.getValue()).equals(nodeId)).findFirst().orElse(null);
        if (entry == null) {
            return;
        }
        this.oldChecksums.remove(entry.getKey());
        entry = this.newChecksums.entrySet().stream().filter(e -> ((String)e.getValue()).equals(nodeId)).findFirst().orElse(null);
        if (entry == null) {
            return;
        }
        this.newChecksums.remove(entry.getKey());
        this.changeMap = null;
    }

    private Map<String, String> readOldChecksums() {
        return new BufferedReader(new InputStreamReader(this.manager.read(this.checksumName))).lines().collect(Collectors.toMap(l -> l.split("@")[0], l -> l.split("@")[1]));
    }

    public void commit() {
        this.writeNewChecksums();
    }

    public void trace(String path) {
        Stash stash = this.store.stashFrom(path);
        if (stash == null) {
            return;
        }
        this.calculateChecksums(stash);
        this.changeMap = null;
    }

    private void calculateChecksums(Stash stash) {
        for (int i = 0; i < stash.nodes.size(); ++i) {
            this.put(this.checksumOf(stash.nodes.get(i)), stash.nodes.get((int)i).name);
        }
    }

    private void put(String checksum, String nodeId) {
        if (!this.newChecksums.containsKey(checksum)) {
            this.newChecksums.put(checksum, nodeId);
        }
        int counter = 1;
        while (this.newChecksums.containsKey(checksum + counter++)) {
        }
        this.newChecksums.put(checksum, nodeId);
    }

    private String checksumOf(io.intino.magritte.io.model.Node node) {
        this.processNames(node.nodes);
        return StoreAuditor.calculateChecksum(node);
    }

    private void processNames(List<io.intino.magritte.io.model.Node> nodes) {
        for (io.intino.magritte.io.model.Node node : nodes) {
            String name = Predicate.nameOf(node.name);
            node.name = StoreAuditor.isUUID(name) ? "" : name;
            this.processNames(node.nodes);
        }
    }

    public List<Change> changeList() {
        return this.calculateMap().entrySet().stream().map(e -> new Change((String)e.getKey(), (Action)((Object)((Object)e.getValue())))).collect(Collectors.toList());
    }

    private Map<String, Action> calculateMap() {
        if (this.changeMap != null) {
            return this.changeMap;
        }
        this.changeMap = new HashMap<String, Action>();
        HashSet<String> checksums = new HashSet<String>(this.oldChecksums.keySet());
        checksums.addAll(this.newChecksums.keySet());
        for (String checksum : checksums) {
            if (this.oldChecksums.containsKey(checksum) && this.newChecksums.containsKey(checksum)) continue;
            if (this.oldChecksums.containsKey(checksum)) {
                this.put(this.changeMap, this.oldChecksums.get(checksum), Action.Removed);
            }
            if (!this.newChecksums.containsKey(checksum)) continue;
            this.put(this.changeMap, this.newChecksums.get(checksum), Action.Created);
        }
        return this.changeMap;
    }

    public boolean isModified(Node node) {
        return this.isModified(node.id());
    }

    public boolean isModified(String nodeId) {
        return this.calculateMap().containsKey(nodeId) && this.calculateMap().get(nodeId) == Action.Modified;
    }

    public boolean isCreated(Node node) {
        return this.isCreated(node.id());
    }

    public boolean isCreated(String nodeId) {
        return this.calculateMap().containsKey(nodeId) && this.calculateMap().get(nodeId) == Action.Created;
    }

    public boolean isRemoved(Node node) {
        return this.isRemoved(node.id());
    }

    public boolean isRemoved(String nodeId) {
        return this.calculateMap().containsKey(nodeId) && this.calculateMap().get(nodeId) == Action.Removed;
    }

    private void put(Map<String, Action> result, String nodeId, Action action) {
        if (result.containsKey(nodeId)) {
            result.put(nodeId, Action.Modified);
        } else {
            result.put(nodeId, action);
        }
    }

    private void writeNewChecksums() {
        try {
            DataOutputStream stream = new DataOutputStream(this.manager.write(this.checksumName));
            stream.write(this.newChecksums.entrySet().stream().map(e -> (String)e.getKey() + "@" + (String)e.getValue()).collect(Collectors.joining("\n")).getBytes());
            stream.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static enum Action {
        Created,
        Modified,
        Removed;

    }

    public static class Change {
        String nodeId;
        Action action;

        public Change(String nodeId, Action action) {
            this.nodeId = nodeId;
            this.action = action;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public Action action() {
            return this.action;
        }
    }
}

