/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework.types;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;

public class DateX {
    private final Instant start;
    private final Instant end;

    public static DateX parse(String text) {
        return Parser.of(text).date();
    }

    public DateX(Instant start, Instant end) {
        this.start = start;
        this.end = end;
        this.checkRange();
    }

    public Instant from() {
        return this.start;
    }

    public Instant to() {
        return this.end;
    }

    private void checkRange() {
        if (this.start.compareTo(this.end) > 0) {
            throw new RangeException("Invalid range: start is after end");
        }
        if (this.start.compareTo(this.end) == 0) {
            throw new RangeException("Invalid range: start is equals to end");
        }
    }

    private static class Parser {
        private final String text;

        static Parser of(String text) {
            return new Parser(text);
        }

        private Parser(String text) {
            this.text = text;
        }

        DateX date() {
            return this.isRange() ? this.parseRange() : this.parseDate();
        }

        private DateX parseRange() {
            String[] split = this.text.split(",");
            return new DateX(this.parseText(split[0]), this.parseText(split[1]));
        }

        private Instant parseText(String text) {
            return this.isInstant(text) ? Instant.parse(text) : this.instantOf(this.valuesOf(text));
        }

        private DateX parseDate() {
            return this.parseDate(this.valuesOf(this.text));
        }

        private DateX parseDate(int[] values) {
            Instant from = this.instantOf(values);
            Instant to = this.instantOf(this.next(values));
            return new DateX(from, to);
        }

        private int[] valuesOf(String text) {
            return this.normalize(this.split(text));
        }

        private int[] normalize(int[] values) {
            return Arrays.copyOf(values, 7);
        }

        private int[] next(int[] values) {
            int[] result = Arrays.copyOf(values, 7);
            for (int i = 0; i < values.length; ++i) {
                if (result[i] != 0) continue;
                int n = i - 1;
                result[n] = result[n] + 1;
                break;
            }
            return result;
        }

        private int[] split(String text) throws ParseException {
            try {
                return Arrays.stream(text.split("[-T\\|/\\. :]")).filter(s -> !s.isEmpty()).mapToInt(Integer::parseInt).toArray();
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number " + e.getMessage().toLowerCase());
            }
        }

        private Instant instantOf(int[] v) {
            try {
                return LocalDateTime.of(v[0], this.noZero(v[1]), this.noZero(v[2]), v[3], v[4], v[5], v[6] * 1000000).toInstant(ZoneOffset.UTC);
            }
            catch (DateTimeException e) {
                throw new ParseException(e.getMessage());
            }
        }

        private int noZero(int v) {
            return v == 0 ? 1 : v;
        }

        private boolean isInstant(String text) {
            return text.endsWith("Z") && text.length() == 24;
        }

        private boolean isRange() {
            return this.text.contains(",");
        }
    }

    public static class RangeException
    extends RuntimeException {
        public RangeException(String message) {
            super(message);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }
    }
}

