/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.operations;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.AbstractGraphCreator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.GraphLoaderCreator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerFrameCreator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.templates.GraphTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativesCreator;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LayerGenerationOperation
extends ModelOperation
implements TemplateTags {
    private static final Logger LOG = Logger.getGlobal();
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private static final String GRAPH = "Graph";
    private final CompilerConfiguration conf;
    private final File srcFolder;
    private final File outFolder;
    private final Template template;
    private final Map<String, List<String>> outMap = new LinkedHashMap<String, List<String>>();

    public LayerGenerationOperation(CompilationUnit compilationUnit) {
        super(compilationUnit);
        this.conf = compilationUnit.configuration();
        this.outFolder = this.conf.getOutDirectory();
        this.srcFolder = this.conf.sourceDirectories().isEmpty() ? null : this.conf.sourceDirectories().stream().filter(d -> !d.getName().equals("gen")).findFirst().orElse(this.conf.sourceDirectories().get(0));
        this.template = Format.customize(new LayerTemplate());
    }

    @Override
    public void call(Model model) {
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Cleaning Old Layers...");
            }
            if (!this.conf.model().level().equals((Object)CompilerConfiguration.Level.Model)) {
                this.cleanOldLayers(model);
            }
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Generating Layers...");
            }
            this.createClasses(model);
            this.registerOutputs(this.writeNativeClasses(model));
            this.unit.addOutputItems(this.outMap);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error during java className generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.unit.getPhase(), this.unit, e);
        }
    }

    private Map<String, String> writeNativeClasses(Model model) {
        return new NativesCreator(model, this.conf).create();
    }

    private void createClasses(Model model) {
        if (!model.level().equals((Object)CompilerConfiguration.Level.Model)) {
            Map<String, Map<String, String>> layers = this.createLayerClasses(model);
            layers.values().forEach(this::writeLayers);
            this.writeAbstractGraph(model, layers);
            this.writeGraph(this.createGraph());
        } else {
            this.writeGraphLoader(model);
        }
    }

    private void writeGraphLoader(Model model) {
        File target = new File(new File(this.outFolder, this.conf.workingPackage().toLowerCase().replace(DOT, File.separator)), "GraphLoader.java");
        this.write(target, new GraphLoaderCreator(model.language(), this.conf).create(model));
        if (this.outMap.isEmpty()) {
            this.unit.getSourceUnits().forEach((s, v) -> this.put((String)s, target.getAbsolutePath()));
        } else {
            for (List<String> paths : this.outMap.values()) {
                paths.add(target.getAbsolutePath());
            }
        }
    }

    private void writeAbstractGraph(Model model, Map<String, Map<String, String>> layers) {
        AbstractGraphCreator abstractGraphCreator = new AbstractGraphCreator(model.language(), this.conf);
        this.registerOutputs(layers, this.writeAbstractGraph(abstractGraphCreator.create(model)));
    }

    private void registerOutputs(Map<String, Map<String, String>> layers, String abstractGraphPath) {
        this.fillLayerInOutMap(layers);
        for (List<String> paths : this.outMap.values()) {
            paths.add(abstractGraphPath);
        }
    }

    private void registerOutputs(Map<String, String> nativeOuts) {
        for (Map.Entry<String, String> src : nativeOuts.entrySet()) {
            if (!this.outMap.containsKey(src.getValue())) {
                this.outMap.put(src.getValue(), new ArrayList());
            }
            this.outMap.get(src.getValue()).add(src.getKey());
        }
    }

    private void fillLayerInOutMap(Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            for (String out : entry.getValue().keySet()) {
                if (this.isUnderSource(new File(out))) continue;
                this.put(entry.getKey(), out);
            }
        }
    }

    private void put(String key, String value) {
        if (!this.outMap.containsKey(key)) {
            this.outMap.put(key, new ArrayList());
        }
        this.outMap.get(key).add(value);
    }

    private String createGraph() {
        FrameBuilder builder = new FrameBuilder("wrapper");
        builder.add("generatedLanguage", this.conf.model().outDsl());
        builder.add("workingPackage", this.conf.workingPackage());
        return Format.customize(new GraphTemplate()).render((Object)builder.toFrame());
    }

    private Map<String, Map<String, String>> createLayerClasses(Model model) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Mogram node : model.components()) {
            if (node.is(Tag.Instance) || !((MogramImpl)node).isDirty() || ((MogramImpl)node).isVirtual()) continue;
            this.renderNode(map, node);
        }
        return map;
    }

    private void renderNode(Map<String, Map<String, String>> map, Mogram node) {
        boolean modified;
        Map.Entry<String, Frame> layerFrame = new LayerFrameCreator(this.conf, node.languageName()).create(node);
        if (!map.containsKey(node.file())) {
            map.put(node.file(), new LinkedHashMap());
        }
        String destination = this.destination(layerFrame);
        map.get(node.file()).put(destination, !(modified = true) && new File(destination).exists() ? "" : this.render(layerFrame));
        this.renderFrame(map, node, layerFrame);
    }

    private void renderFrame(Map<String, Map<String, String>> map, Mogram node, Map.Entry<String, Frame> layerFrame) {
        if (node.is(Tag.Decorable)) {
            Map.Entry<String, Frame> frame = new LayerFrameCreator(this.conf, node.languageName()).createDecorable(node);
            File file = new File(this.srcTarget(frame));
            if (file.exists() && node.isAbstract()) {
                this.checkAbstractDecorable(file);
            }
            map.get(node.file()).put(file.getAbsolutePath(), file.exists() ? "" : this.render(frame));
        } else {
            this.removeDecorable(layerFrame.getKey(), node.name());
        }
    }

    private void checkAbstractDecorable(File file) {
        try {
            String text = Files.readString(file.toPath());
            if (text.contains("public class")) {
                text = text.replaceFirst("public class", "public abstract class");
                Files.writeString(file.toPath(), (CharSequence)text, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void removeDecorable(String key, String name) {
        File parentFile = new File(this.outFolder, key.replace(DOT, File.separator) + JAVA).getParentFile();
        File file = new File(parentFile, Format.firstUpperCase().format(Format.javaValidName().format("abstract" + name)).toString() + JAVA);
        if (file.exists()) {
            file.delete();
        }
    }

    private String destination(Map.Entry<String, Frame> layerFrameMap) {
        return new File(this.outFolder, layerFrameMap.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String srcTarget(Map.Entry<String, Frame> layerFrameMap) {
        return new File(this.srcFolder, layerFrameMap.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private void writeLayers(Map<String, String> layersMap) {
        for (Map.Entry<String, String> entry : layersMap.entrySet()) {
            File file = new File(entry.getKey());
            if (entry.getValue().isEmpty() || this.isUnderSource(file) && file.exists()) continue;
            file.getParentFile().mkdirs();
            this.write(file, entry.getValue());
        }
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private String writeAbstractGraph(String text) {
        File target = new File(new File(this.outFolder, this.conf.workingPackage().replace(DOT, File.separator)), "AbstractGraph.java");
        target.getParentFile().mkdirs();
        return this.write(target, text) ? target.getAbsolutePath() : null;
    }

    private void writeGraph(String text) {
        File target = new File(new File(this.srcFolder, this.conf.workingPackage().toLowerCase().replace(DOT, File.separator)), String.valueOf(Format.firstUpperCase().format(Format.javaValidName().format(this.conf.model().outDsl()))) + "Graph.java");
        if (!target.exists()) {
            this.write(target, text);
        }
    }

    private void cleanOldLayers(Model model) {
        String workingPackage = this.conf.workingPackage() == null ? this.conf.getModule() : this.conf.workingPackage();
        File out = new File(this.conf.getOutDirectory(), workingPackage.toLowerCase());
        List<File> layers = this.filterOld(this.collectAllLayers(out), out, model);
        layers.forEach(File::delete);
    }

    private List<File> filterOld(List<File> files, File base, Model model) {
        List<File> current = this.calculateCurrentLayers(base, model);
        return files.stream().filter(layer -> !current.contains(layer) && !this.isUnderSource((File)layer)).collect(Collectors.toList());
    }

    private List<File> calculateCurrentLayers(File base, Model model) {
        return model.components().stream().filter(n -> !n.is(Tag.Instance) && !n.isAnonymous()).map(node -> new File(this.calculateLayerPath((Mogram)node, base) + JAVA)).collect(Collectors.toList());
    }

    private String calculateLayerPath(Mogram node, File workingPackage) {
        return workingPackage.getPath() + File.separator + Format.javaValidName().format(node.name()).toString();
    }

    private List<File> collectAllLayers(File out) {
        ArrayList<File> list = new ArrayList<File>();
        if (!out.isDirectory() && !out.getName().equals("Graph.java")) {
            list.add(out);
        } else if (!out.isDirectory()) {
            for (File file : Objects.requireNonNull(out.listFiles(f -> !"natives".equals(f.getName())))) {
                list.addAll(this.collectAllLayers(file));
            }
        }
        return list;
    }

    private boolean write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)text, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private String render(Map.Entry<String, Frame> layerFrame) {
        return this.template.render((Object)layerFrame.getValue());
    }

    private String prefix() {
        return "@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.model().outDsl() + "]";
    }
}

