/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.language.model.EmptyMogram;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class TypesProvider
implements TemplateTags {
    private TypesProvider() {
    }

    static List<String> getTypes(Mogram mogram, Language language) {
        Size size;
        List<String> types = mogram.flags().stream().map(Enum::name).collect(Collectors.toList());
        types.add("Node");
        if (mogram instanceof MogramImpl) {
            types.add("NodeImpl");
        }
        if ((size = mogram.container().sizeOf(mogram)) != null && size.isSingle()) {
            types.add("single");
        }
        if (TypesProvider.isOverriding(mogram)) {
            types.add("overriden");
        }
        types.addAll(TypesProvider.nodeAnnotations(mogram, language));
        return types;
    }

    private static boolean isOverriding(Mogram node) {
        return node.parent() != null && (node.container() instanceof MogramImpl && node.parent().container().equals(node.container().parent()) || node.container().parent() != null && TypesProvider.containerContainsParent(node));
    }

    private static boolean containerContainsParent(Mogram node) {
        boolean contains = node.container().parent().contains(node.parent());
        return contains || TypesProvider.hasReference(node.container().parent(), node.parent());
    }

    private static boolean hasReference(Mogram node, Mogram component) {
        for (Mogram candidate : node.components()) {
            if (!candidate.isReference() || !candidate.targetOfReference().equals(component)) continue;
            return true;
        }
        return false;
    }

    static String[] getTypes(Facet aspect) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aspect");
        list.add(aspect.type());
        return list.toArray(new String[0]);
    }

    private static List<String> nodeAnnotations(Mogram node, Language language) {
        ArrayList<String> annotations = new ArrayList<String>();
        List<Assumption> assumptions = language.assumptions(node.type());
        if (assumptions == null) {
            return annotations;
        }
        for (Assumption assumption : assumptions) {
            String name = assumption.getClass().getInterfaces()[0].getSimpleName();
            if (!name.endsWith("Instance")) continue;
            annotations.add(name);
        }
        return annotations;
    }

    public static Set<String> getTypes(Variable variable, CompilerConfiguration.Level type) {
        HashSet<String> types = new HashSet<String>();
        if (variable.values().isEmpty()) {
            types.add("required");
        }
        if (!variable.values().isEmpty() && (variable.values().get(0) instanceof EmptyMogram || variable.values().get(0) == null)) {
            types.add("empty");
        }
        types.add(variable.getClass().getSimpleName());
        if (type.equals((Object)CompilerConfiguration.Level.MetaModel)) {
            types.add("terminal");
        }
        types.add("variable");
        if (variable instanceof VariableReference) {
            types.add("reference");
            if (variable.flags().contains((Object)Tag.Concept)) {
                types.add("concept");
            }
        }
        if (variable.type().equals((Object)Primitive.OBJECT)) {
            types.add("objectVariable");
        }
        types.add(variable.type().getName());
        if (Primitive.isJavaPrimitive(variable.type().getName())) {
            types.add("primitive");
        }
        if (variable.isInherited()) {
            types.add("inherited");
        }
        if (variable.isOverridden()) {
            types.add("overriden");
        }
        if (variable.isMultiple()) {
            types.add("multiple");
        }
        types.addAll(variable.flags().stream().map(tag -> tag.name().toLowerCase()).toList());
        return types;
    }

    public static String[] getTypes(Constraint.Parameter parameter, boolean isRequired) {
        HashSet<String> types = new HashSet<String>();
        types.add(parameter.getClass().getSimpleName());
        types.add("variable");
        if (parameter instanceof ReferenceParameter && !parameter.type().equals((Object)Primitive.WORD)) {
            types.add("reference");
        }
        types.add(parameter.type().getName());
        if (isRequired && parameter.flags().contains((Object)Tag.Terminal)) {
            types.add("required");
        }
        if (parameter.size().max() > 1) {
            types.add("multiple");
        }
        types.addAll(parameter.flags().stream().map(Enum::name).toList());
        return types.toArray(new String[0]);
    }

    public static String[] getTypes(Parameter parameter) {
        HashSet<String> types = new HashSet<String>();
        types.add(parameter.getClass().getSimpleName());
        types.add("variable");
        types.add("parameter");
        types.add(parameter.type().getName());
        if (parameter.values().size() > 1) {
            types.add("multiple");
        }
        types.addAll(parameter.flags().stream().map(Enum::name).toList());
        return types.toArray(new String[0]);
    }
}

